/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.primitives;

public class MutableFloat extends Number implements Comparable<MutableFloat> {

	private static final long serialVersionUID = 1L;
	
	public float value;

	public MutableFloat() {}
	
	public MutableFloat(float value) { this.value = value; }
	
    public boolean isNaN() {
	return Float.isNaN(value);
    }

    public boolean isInfinite() {
	return Float.isInfinite(value);
    }

    public String toString() {
	return String.valueOf(value);
    }

    public byte byteValue() {
	return (byte)value;
    }

    public short shortValue() {
	return (short)value;
    }

    public int intValue() {
	return (int)value;
    }

    public long longValue() {
	return (long)value;
    }

    public float floatValue() {
	return value;
    }

    public double doubleValue() {
	return (double)value;
    }

    public int hashCode() {
	return Float.floatToIntBits(value);
    }
    
    public boolean equals(Object obj) {
		if (obj == null) return false;
		if (obj == this) return true;
		
		return (obj instanceof MutableFloat)
	       && (Float.floatToIntBits(((MutableFloat)obj).value) == Float.floatToIntBits(value));
    }
    
    public int compareTo(MutableFloat anotherFloat) {
        return Float.compare(value, anotherFloat.value);
    }    
	
}

