package org.simantics.databoard.channel;

import java.util.Collection;

/**
 * Server interface of command channel. <p>
 * 
 * For each callable command there is a well-known commandId and datatype. <p>
 *
 * @author Toni Kalajainen <toni.kalajainen@iki.fi>
 */
public interface ServiceHandler {

	/**
	 * Handle service request from the client. The implementation may handle
	 * the service at once or later, even in another thread. The result is
	 * written to the asynchronous result object. <p>
	 * 
	 * @param request
	 */
	void handleRequest( ServiceRequest request );
	
	/**
	 * Get all callable commands handled by this service handler.
	 * This result is list of command specifications. For each command there is
	 * unique identification, result type and error type.  
	 * 
	 * @return commands
	 */
	Collection<CommandSpec> getCommands();
	
}
