/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.WeakHashMap;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.type.RecordType;

/**
 * AsmBindingFactory creates code-generated bindings for classes.
 * 
 * @author toni.kalajainen
 */
public class AsmBindingProvider implements RecordBindingProvider {
	
	WeakHashMap<ClassLoader, AsmBindingClassLoader> bindingClassLoaders = new WeakHashMap<ClassLoader, AsmBindingClassLoader>();

	public AsmBindingProvider() {		
	}

	@Override
	public synchronized RecordBinding provideRecordBinding(Class<?> clazz, RecordType type)
			throws BindingConstructionException {
		
		ClassLoader cl = clazz.getClassLoader();
		if (cl == null) {
			cl = Thread.currentThread().getContextClassLoader();
		}
		AsmBindingClassLoader bcl = bindingClassLoaders.get(cl);
		if ( bcl == null ) {
			bcl = new AsmBindingClassLoader(cl);
			bindingClassLoaders.put(cl, bcl);
		}
		
		ClassInfo ci = ClassInfo.getInfo(clazz);
		try {			
			Class<?> bindingClass = bcl.getBindingClass( clazz );
			Constructor<?> c = bindingClass.getConstructor( RecordType.class );
			RecordBinding binding = (RecordBinding) c.newInstance( type );
	       	binding.componentBindings = new Binding[ ci.fields.length ];  
			return binding;
		} catch (InstantiationException e) {
			throw new BindingConstructionException(e);
		} catch (IllegalAccessException e) {
			throw new BindingConstructionException(e);
		} catch (SecurityException e) {
			throw new BindingConstructionException(e);
		} catch (NoSuchMethodException e) {
			throw new BindingConstructionException(e);
		} catch (IllegalArgumentException e) {
			throw new BindingConstructionException(e);
		} catch (InvocationTargetException e) {
			throw new BindingConstructionException(e.getCause());
		} catch (ClassNotFoundException e) {
			throw new BindingConstructionException(e);
		}
	}
			
}
