/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.annotations;

import java.lang.annotation.Annotation;

public class PatternImpl implements Pattern {

	String str;
	
	public PatternImpl( String str ) {
		this.str = str;
	}
	
	@Override
	public Class<? extends Annotation> annotationType() {
		return Pattern.class;
	}

	@Override
	public String value() {
		return str;
	}
	
	@Override
	public int hashCode() {
		return str.hashCode();
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof Pattern == false) return false;
		Pattern length = (Pattern) obj;
		return length.value().equals(str);
	}	
}
