/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.exception;

import org.simantics.browsing.ui.PrimitiveQueryUpdater;

/**
 * Used with {@link PrimitiveQueryUpdater#getDataSource(Class)} to indicate
 * missing data sources.
 * 
 * @author Tuukka Lehtonen
 */
public class NoDataSourceException extends RuntimeException {

    private static final long serialVersionUID = -2394930587477837261L;

    public NoDataSourceException(Class<?> clazz) {
        super("No DataSource available for class " + clazz);
    }

}
