/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui;

import java.io.File;

/**
 * @author Antti Villberg
 * @see GraphExplorer#setPersistor(StatePersistor)
 */
public interface StatePersistor {

	/**
	 * Deserializes a possibly stored state for the specified input from the
	 * specified location. The locality of the restored state is up to the
	 * implementation to decide (i.e. input-specific or more global).
	 * 
	 * @param stateLocation
	 *            the base location to deserialize the possible state from
	 * @param root
	 *            the current input to deserialize the state for or
	 *            <code>null</code> if no input is defined
	 * @return the deserialized state, may not be <code>null</code>.
	 *         Implementations may return {@link ExplorerState#EMPTY} if there's
	 *         no state to restore.
	 * @see ExplorerState#EMPTY
	 */
	ExplorerState deserialize(File stateLocation, NodeContext root);

	/**
	 * Serializes the specified explorer state for the specified input to the
	 * specified location. The locality of the stored state is up to the
	 * implementation to decide (i.e. input-specific or more global).
	 * 
	 * @param stateLocation
	 *            the base location to serialize the state to
	 * @param root
	 *            the current input to serialize the state for or
	 *            <code>null</code> if no input is defined
	 * @param state
	 *            the state to serialize
	 */
	void serialize(File stateLocation, NodeContext root, ExplorerState state);

}
