/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui;

import java.util.function.Consumer;

/**
 * This interface represents anything that can be used to retrieve data through
 * scheduling of callback objects. It is used in the Graph Explorer for
 * off-loading of possibly heavy data retrieval tasks into other threads running
 * in the background from the the UI thread(s).
 * 
 * @param <Source>
 */
public interface DataSource<Source> {

    public void schedule(Consumer<Source> callback);

    Class<Source> getProvidedClass();

}
