/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.matlablink;

import java.util.Arrays;
import org.simantics.matlablink.MatlabArray;

public class DoubleArray
extends MatlabArray {
    double[] value;
    int[] dims;

    public DoubleArray(double[] value) {
        this.value = value;
        this.dims = new int[]{1, value.length};
    }

    public DoubleArray(int m, int n, double[] value) {
        if (m * n != value.length) {
            throw new IllegalArgumentException("Array dimension and value mismatch");
        }
        this.value = value;
        this.dims = new int[]{m, n};
    }

    public DoubleArray(int[] dims, double[] value) {
        int nelem = dims.length > 0 ? 1 : 0;
        int[] nArray = dims;
        int n = dims.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            nelem *= n3;
            ++n2;
        }
        if (nelem != value.length) {
            throw new IllegalArgumentException("Array dimension and value mismatch");
        }
        this.value = value;
        this.dims = dims;
    }

    @Override
    public boolean isDouble() {
        return true;
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public int[] dims() {
        return this.dims;
    }

    @Override
    public double[] getDoubleValue() {
        return this.value;
    }

    @Override
    public double getDoubleValue(int index) {
        return this.value[index];
    }

    public double getDoubleValue(int i, int j) {
        return this.value[i + this.dims[0] * j];
    }

    public double getDoubleValue(int ... k) {
        if (k.length > this.dims.length) {
            throw new IllegalArgumentException("Too many indexes for array of dimension " + this.dims.length);
        }
        int s = 1;
        int index = 0;
        int l = 0;
        while (l < k.length) {
            index += s * k[l];
            s *= this.dims[l];
            ++l;
        }
        return this.value[index];
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DoubleArray && Arrays.equals(this.dims, ((DoubleArray)obj).dims) && Arrays.equals(this.value, ((DoubleArray)obj).value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        while (i < Math.min(this.size(), 10)) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.value[i]);
            ++i;
        }
        if (this.size() > 10) {
            sb.append(", ...");
        }
        sb.append(" (");
        i = 0;
        while (i < this.dims.length) {
            if (i > 0) {
                sb.append("x");
            }
            sb.append(this.dims[i]);
            ++i;
        }
        sb.append(")]");
        return sb.toString();
    }
}

