/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.utils;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TreeColumn;
import org.simantics.interop.utils.StringColumnComparator;

public class TableUtils {
    public static TableViewerColumn addColumn(final TableViewer viewer, String text, boolean resize, boolean sort, int width) {
        TableViewerColumn twc = new TableViewerColumn(viewer, 0);
        final TableColumn tc = twc.getColumn();
        tc.setText(text);
        tc.setResizable(resize);
        tc.setWidth(width);
        if (sort) {
            tc.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    StringColumnComparator comparator = null;
                    if (viewer.getComparator() instanceof StringColumnComparator) {
                        comparator = (StringColumnComparator)viewer.getComparator();
                    } else {
                        comparator = new StringColumnComparator();
                        viewer.setComparator((ViewerComparator)comparator);
                    }
                    TableColumn[] tcs = viewer.getTable().getColumns();
                    int index = -1;
                    int i = 0;
                    while (i < tcs.length) {
                        if (tcs[i].equals(tc)) {
                            index = i;
                            break;
                        }
                        ++i;
                    }
                    if (index == -1) {
                        return;
                    }
                    comparator.setColumnt(index);
                    int dir = viewer.getTable().getSortDirection();
                    dir = viewer.getTable().getSortColumn() == tc ? (dir == 128 ? 1024 : 128) : 1024;
                    viewer.getTable().setSortDirection(dir);
                    viewer.getTable().setSortColumn(tc);
                    viewer.refresh();
                }
            });
        }
        return twc;
    }

    public static TreeViewerColumn addColumn(TreeViewer viewer, String text, boolean resize, int width) {
        TreeViewerColumn tvc = new TreeViewerColumn(viewer, 0);
        TreeColumn tc = tvc.getColumn();
        tc.setResizable(resize);
        tc.setText(text);
        tc.setWidth(width);
        return tvc;
    }
}

