/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.test;

import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.utils.datastructures.BijectionMap;
import org.simantics.utils.datastructures.Pair;

public class GraphChanges {
    private Resource r1;
    private Resource r2;
    private List<Statement> deletions;
    private List<Statement> additions;
    private List<Pair<Statement, Statement>> modifications;
    private BijectionMap<Resource, Resource> comparable;

    public GraphChanges(Resource r1, Resource r2, List<Statement> deletions, List<Statement> additions, List<Pair<Statement, Statement>> modifications, BijectionMap<Resource, Resource> comparable) {
        this.r1 = r1;
        this.r2 = r2;
        this.deletions = deletions;
        this.additions = additions;
        this.modifications = modifications;
        this.comparable = comparable;
    }

    public Resource getResource1() {
        return this.r1;
    }

    public Resource getResource2() {
        return this.r2;
    }

    public List<Statement> getAdditions() {
        return this.additions;
    }

    public List<Statement> getDeletions() {
        return this.deletions;
    }

    public List<Pair<Statement, Statement>> getModifications() {
        return this.modifications;
    }

    public BijectionMap<Resource, Resource> getComparable() {
        return this.comparable;
    }

    public String toString(ReadGraph graph) throws ValidationException, ServiceException {
        StringBuilder sb = new StringBuilder();
        sb.append("Del:\n");
        for (Statement statement : this.deletions) {
            sb.append(String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)statement.getSubject())) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)statement.getPredicate()) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)statement.getObject()) + " (" + statement.getSubject() + " " + statement.getPredicate() + " " + statement.getObject() + ")\n");
        }
        sb.append("Add:\n");
        for (Statement statement : this.additions) {
            sb.append(String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)statement.getSubject())) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)statement.getPredicate()) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)statement.getObject()) + " (" + statement.getSubject() + " " + statement.getPredicate() + " " + statement.getObject() + ")\n");
        }
        sb.append("Mod:\n");
        for (Pair pair : this.modifications) {
            Statement stm = (Statement)pair.first;
            sb.append(String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getSubject())) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getPredicate()) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getObject()) + " (" + stm.getSubject() + " " + stm.getPredicate() + " " + stm.getObject() + ")\n");
            stm = (Statement)pair.second;
            sb.append(String.valueOf(NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getSubject())) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getPredicate()) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getObject()) + " (" + stm.getSubject() + " " + stm.getPredicate() + " " + stm.getObject() + ")\n");
        }
        return sb.toString();
    }
}

