/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.browsing;

import java.util.Collection;
import java.util.function.Supplier;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.interop.browsing.BaseViewpointFactory;
import org.simantics.interop.browsing.INode;
import org.simantics.modeling.ui.modelBrowser.model.IChildrenCallback;
import org.simantics.modeling.ui.modelBrowser.model.IDisposable;
import org.simantics.modeling.ui.modelBrowser.model.IUpdateable;

class NodeViewpointFactory
extends BaseViewpointFactory {
    NodeViewpointFactory() {
    }

    public String toString() {
        return "Standard";
    }

    public Viewpoint create(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ViewpointKey key) {
        return new VP(updater, context, key);
    }

    class VP
    extends BaseViewpointFactory.VPB {
        public VP(PrimitiveQueryUpdater updater, NodeContext context, BuiltinKeys.ViewpointKey key) {
            super(updater, context, key);
        }

        public NodeContext[] children(ReadGraph graph) throws DatabaseException {
            INode node = (INode)this.context.getConstant(BuiltinKeys.INPUT);
            if (node instanceof IUpdateable) {
                ((IUpdateable)node).setChildrenCallback((IChildrenCallback)this);
            }
            Collection<?> children = node.getChildren(graph);
            for (Object child : children) {
                if (!(child instanceof IDisposable)) continue;
                ((IDisposable)child).setDisposedCallable((Supplier)this);
            }
            return this.toContextsWithInput(children);
        }
    }
}

