/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.toolbar;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.CommandEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ICommandListener;
import org.eclipse.core.commands.State;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.WorkbenchWindowControlContribution;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.simantics.db.common.utils.ErrorLogger;
import org.simantics.g3d.Activator;
import org.simantics.g3d.toolbar.CommandStateRegistry;
import org.simantics.g3d.toolbar.ToolBarCommandRegistry;
import org.simantics.utils.datastructures.MapList;

public abstract class ToolbarContributor
extends EditorActionBarContributor
implements ICommandListener,
IPartListener {
    private static final String PLATFORM = "platform:/plugin/";
    private IEditorPart activePart;
    private Set<IEditorPart> parts = new HashSet<IEditorPart>();
    IToolBarManager mgr;
    ICommandService service;
    IHandlerService handlerService;
    List<IContributionItem> items = new ArrayList<IContributionItem>();
    MapList<String, CommandAction> actions = new MapList();
    CommandStateRegistry stateRegistry;
    private Map<String, ComboContribution> menus = new HashMap<String, ComboContribution>();

    public ToolbarContributor() {
        this.service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        this.stateRegistry = CommandStateRegistry.getInstance();
    }

    public abstract String getToolbarId();

    public void contributeToCoolBar(ICoolBarManager coolBarManager) {
        IContributionItem toolBar = coolBarManager.find(this.getToolbarId());
        if (toolBar instanceof ToolBarContributionItem) {
            this.mgr = ((ToolBarContributionItem)toolBar).getToolBarManager();
        }
        if (this.mgr == null) {
            return;
        }
        this.createCommands();
        this.mgr.markDirty();
    }

    private void createCommands() {
        for (ToolBarCommandRegistry.ToolbarCommandExtension ext : ToolBarCommandRegistry.getInstance().getExtensions(this.getToolbarId())) {
            this.addCommand(ext);
        }
    }

    private void addCommand(ToolBarCommandRegistry.ToolbarCommandExtension ext) {
        String commandId = ext.commandId;
        Command command = this.service.getCommand(commandId);
        String type = ext.type;
        State toggleState = command.getState("org.eclipse.ui.commands.toggleState");
        State radioState = command.getState("org.eclipse.ui.commands.radioState");
        String name = ext.name;
        ImageDescriptor image = this.getImage(ext);
        CommandAction a = null;
        if (type.equals("toggle") && toggleState != null) {
            a = new CommandCheckboxAction(command, name, image);
            this.stateRegistry.storeDefaultState(commandId);
        } else if (radioState != null && ext.value != null) {
            this.stateRegistry.storeDefaultState(commandId);
            if (type.equals("radio")) {
                a = new CommandRadioAction(command, name, ext.value, image);
            } else if (type.equals("combo")) {
                a = new CommandRadioAction(command, name, ext.value, image);
                ComboContribution combo = this.menus.get(commandId);
                if (combo == null) {
                    combo = new ComboContribution();
                    this.menus.put(commandId, combo);
                    this.items.add((IContributionItem)combo);
                    this.mgr.add((IContributionItem)combo);
                    a.getCommand().addCommandListener((ICommandListener)this);
                }
                this.actions.add((Object)commandId, (Object)a);
                combo.addAction(a);
                return;
            }
        } else if (type.equals("push")) {
            a = new CommandPushAction(command, name, image);
        } else {
            ErrorLogger.defaultLogError((String)(ext + " is not valid."));
            return;
        }
        a.getCommand().addCommandListener((ICommandListener)this);
        ActionContributionItem item = new ActionContributionItem((IAction)a);
        this.actions.add((Object)commandId, (Object)a);
        this.items.add((IContributionItem)item);
        this.mgr.add((IContributionItem)item);
    }

    private ImageDescriptor getImage(ToolBarCommandRegistry.ToolbarCommandExtension ext) {
        ImageDescriptor image = null;
        if (ext.image != null) {
            String plugin = null;
            String file = null;
            if (ext.image.startsWith(PLATFORM)) {
                String s = ext.image.substring(PLATFORM.length());
                int i = s.indexOf("/");
                plugin = s.substring(0, i);
                file = s.substring(i + 1);
            } else {
                plugin = ext.contributorId;
                file = ext.image;
            }
            image = Activator.imageDescriptorFromPlugin((String)plugin, (String)file);
        }
        return image;
    }

    public void commandChanged(CommandEvent commandEvent) {
        if (commandEvent.isHandledChanged() || commandEvent.isEnabledChanged()) {
            Command command = commandEvent.getCommand();
            String commandId = command.getId();
            for (CommandAction a : this.actions.getValues((Object)commandId)) {
                a.setEnabled(command.isHandled() && command.isEnabled());
            }
        }
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (targetEditor == this.activePart) {
            return;
        }
        this.setContext(targetEditor);
    }

    private void setContext(IEditorPart part) {
        this.activePart = part;
        if (!this.parts.contains(this.activePart)) {
            this.activePart.getSite().getPage().addPartListener((IPartListener)this);
        }
        if (part != null) {
            for (String commandId : this.actions.getKeys()) {
                for (CommandAction a : this.actions.getValues((Object)commandId)) {
                    a.setEnabled(true);
                }
            }
            this.updateActionBars(part);
        } else {
            for (String commandId : this.actions.getKeys()) {
                for (CommandAction a : this.actions.getValues((Object)commandId)) {
                    a.setEnabled(false);
                }
            }
        }
    }

    private void updateActionBars(IEditorPart part) {
        this.restoreActionStates();
        part.getEditorSite().getActionBars().updateActionBars();
    }

    public void dispose() {
        if (this.mgr != null) {
            for (IContributionItem item : this.items) {
                this.mgr.remove(item);
                item.dispose();
            }
            this.mgr.markDirty();
            this.mgr.update(true);
            if (this.activePart != null) {
                this.activePart.getEditorSite().getActionBars().updateActionBars();
            }
            for (String commandId : this.actions.getKeys()) {
                for (CommandAction a : this.actions.getValues((Object)commandId)) {
                    a.getCommand().removeCommandListener((ICommandListener)this);
                }
            }
            this.actions.clear();
        }
        super.dispose();
        this.activePart = null;
    }

    private void storeRadioActionState(CommandRadioAction action, boolean checked) {
        if (this.activePart == null) {
            return;
        }
        this.stateRegistry.setEditorState((IWorkbenchPart)this.activePart, action.getCommandId(), action.getValue());
    }

    private void storeToggleActionState(CommandAction action, boolean checked) {
        if (this.activePart == null) {
            return;
        }
        this.stateRegistry.setEditorState((IWorkbenchPart)this.activePart, action.getCommandId(), checked);
    }

    private void restoreActionStates() {
        if (this.activePart == null) {
            return;
        }
        Map<String, Boolean> defaultToggleStates = this.stateRegistry.getDefaultToggleStates();
        for (String commandId : defaultToggleStates.keySet()) {
            for (Object a : this.actions.getValues((Object)commandId)) {
                a.setChecked(defaultToggleStates.get(commandId));
            }
        }
        Map<String, Boolean> editorStates = this.stateRegistry.getEditorToggleStates((IWorkbenchPart)this.activePart);
        if (editorStates != null) {
            for (String commandId : editorStates.keySet()) {
                for (Object a : this.actions.getValues((Object)commandId)) {
                    a.setChecked(editorStates.get(commandId));
                }
            }
        }
        Map<String, String> defaultRadioStates = this.stateRegistry.getDefaultRadioStates();
        for (String commandId : defaultRadioStates.keySet()) {
            String defaultValue = defaultRadioStates.get(commandId);
            for (CommandAction a : this.actions.getValues((Object)commandId)) {
                CommandRadioAction r = (CommandRadioAction)a;
                r.setChecked(r.getValue().equals(defaultValue));
            }
        }
        Map<String, String> editorRadioStates = this.stateRegistry.getEditorRadioStates((IWorkbenchPart)this.activePart);
        if (editorRadioStates != null) {
            for (String commandId : editorRadioStates.keySet()) {
                String defaultValue = editorRadioStates.get(commandId);
                for (CommandAction a : this.actions.getValues((Object)commandId)) {
                    CommandRadioAction r = (CommandRadioAction)a;
                    r.setChecked(r.getValue().equals(defaultValue));
                }
            }
        }
        for (ComboContribution c : this.menus.values()) {
            c.updateSelection();
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        this.parts.remove(part);
        this.stateRegistry.clearStates(part);
        part.getSite().getPage().removePartListener((IPartListener)this);
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    private boolean getToggleState(Command command) {
        State toggleState = command.getState("org.eclipse.ui.commands.toggleState");
        return (Boolean)toggleState.getValue();
    }

    private class ComboContribution
    extends WorkbenchWindowControlContribution {
        private TableCombo combo;
        private List<Action> actions = new ArrayList<Action>();

        private ComboContribution() {
        }

        protected Control createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout glContainer = new GridLayout(1, false);
            glContainer.marginTop = 0;
            glContainer.marginHeight = 0;
            glContainer.marginWidth = 0;
            container.setLayout((Layout)glContainer);
            GridData glReader = new GridData(4, 4, false, false, 1, 1);
            this.combo = new TableCombo(container, 2056);
            this.combo.setLayoutData((Object)glReader);
            for (Action a : this.actions) {
                TableItem item = new TableItem(this.combo.getTable(), 0);
                item.setText(a.getText());
                if (a.getImageDescriptor() == null) continue;
                item.setImage(a.getImageDescriptor().createImage());
            }
            this.combo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    int index = ComboContribution.this.combo.getSelectionIndex();
                    if (index == -1) {
                        return;
                    }
                    ((Action)ComboContribution.this.actions.get(index)).run();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.updateSelection();
            return container;
        }

        public void addAction(Action a) {
            this.actions.add(a);
        }

        void updateSelection() {
            if (this.combo == null) {
                return;
            }
            int i = 0;
            while (i < this.actions.size()) {
                if (this.actions.get(i).isChecked()) {
                    this.combo.select(i);
                    return;
                }
                ++i;
            }
        }
    }

    private abstract class CommandAction
    extends Action {
        private Command command;

        public CommandAction(Command command, String name, ImageDescriptor image, int style) {
            super(name, style);
            this.command = command;
            if (image != null) {
                this.setImageDescriptor(image);
            }
        }

        public void run() {
            try {
                ToolbarContributor.this.handlerService.executeCommand(this.command.getId(), null);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public Command getCommand() {
            return this.command;
        }

        public String getCommandId() {
            return this.command.getId();
        }
    }

    private class CommandCheckboxAction
    extends CommandAction {
        public CommandCheckboxAction(Command command, String name, ImageDescriptor image) {
            super(command, name, image, 2);
        }

        @Override
        public void run() {
            boolean checked = this.isChecked();
            ToolbarContributor.this.storeToggleActionState(this, checked);
            try {
                if (checked == ToolbarContributor.this.getToggleState(this.getCommand())) {
                    HandlerUtil.toggleCommandState((Command)this.getCommand());
                }
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            super.run();
        }
    }

    private class CommandPushAction
    extends CommandAction {
        public CommandPushAction(Command command, String name, ImageDescriptor image) {
            super(command, name, image, 1);
        }
    }

    private class CommandRadioAction
    extends CommandAction {
        private String value;

        public CommandRadioAction(Command command, String name, String value, ImageDescriptor image) {
            super(command, name, image, 8);
            this.value = value;
        }

        @Override
        public void run() {
            boolean checked = this.isChecked();
            ToolbarContributor.this.storeRadioActionState(this, checked);
            try {
                HandlerUtil.updateRadioState((Command)this.getCommand(), (String)this.value);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
                return;
            }
            super.run();
        }

        public String getValue() {
            return this.value;
        }
    }
}

