/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.toolbar;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.State;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

public class CommandStateRegistry {
    private static CommandStateRegistry instance;
    private Map<IWorkbenchPart, Map<String, Boolean>> toggleStates = new HashMap<IWorkbenchPart, Map<String, Boolean>>();
    private Map<String, Boolean> defaultToggleStates = new HashMap<String, Boolean>();
    private Map<String, String> defaultRadioStates = new HashMap<String, String>();
    private Map<IWorkbenchPart, Map<String, String>> radioStates = new HashMap<IWorkbenchPart, Map<String, String>>();
    private ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
    private IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);

    public static CommandStateRegistry getInstance() {
        if (instance == null) {
            instance = new CommandStateRegistry();
        }
        return instance;
    }

    private CommandStateRegistry() {
    }

    public void storeDefaultState(String commandId) {
        Command command = this.service.getCommand(commandId);
        State toggleState = command.getState("org.eclipse.ui.commands.toggleState");
        State radioState = command.getState("org.eclipse.ui.commands.radioState");
        if (toggleState != null) {
            if (!this.defaultToggleStates.containsKey(commandId)) {
                this.defaultToggleStates.put(commandId, this.getToggleState(command));
            }
        } else if (radioState != null) {
            String value = (String)radioState.getValue();
            if (!this.defaultRadioStates.containsKey(commandId)) {
                this.defaultRadioStates.put(commandId, value);
            }
        } else {
            throw new IllegalArgumentException("Command " + commandId + " does not have a state");
        }
    }

    public void setEditorState(IWorkbenchPart part, String commandId, boolean checked) {
        Map<String, Boolean> editorStates = this.toggleStates.get(part);
        if (editorStates == null) {
            editorStates = new HashMap<String, Boolean>();
            this.toggleStates.put(part, editorStates);
        }
        editorStates.put(commandId, checked);
    }

    public void setEditorState(IWorkbenchPart part, String commandId, String value) {
        Map<String, String> editorStates = this.radioStates.get(part);
        if (editorStates == null) {
            editorStates = new HashMap<String, String>();
            this.radioStates.put(part, editorStates);
        }
        editorStates.put(commandId, value);
    }

    public Map<String, Boolean> getDefaultToggleStates() {
        return this.defaultToggleStates;
    }

    public Map<String, String> getDefaultRadioStates() {
        return this.defaultRadioStates;
    }

    public Map<String, Boolean> getEditorToggleStates(IWorkbenchPart part) {
        return this.toggleStates.get(part);
    }

    public Map<String, String> getEditorRadioStates(IWorkbenchPart part) {
        return this.radioStates.get(part);
    }

    public Boolean getToggleState(IWorkbenchPart part, String commandId) {
        if (part == null) {
            return this.defaultToggleStates.get(commandId);
        }
        Map<String, Boolean> editorStates = this.toggleStates.get(part);
        if (editorStates == null) {
            return this.defaultToggleStates.get(commandId);
        }
        return editorStates.get(commandId);
    }

    public String getRadioState(IWorkbenchPart part, String commandId) {
        if (part == null) {
            return this.defaultRadioStates.get(commandId);
        }
        Map<String, String> editorStates = this.radioStates.get(part);
        if (editorStates == null) {
            return this.defaultRadioStates.get(commandId);
        }
        return editorStates.get(commandId);
    }

    public void clearStates(IWorkbenchPart part) {
        this.toggleStates.remove(part);
        this.radioStates.remove(part);
    }

    private boolean getToggleState(Command command) {
        State toggleState = command.getState("org.eclipse.ui.commands.toggleState");
        return (Boolean)toggleState.getValue();
    }
}

