/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.shape;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.shape.Color4d;
import org.simantics.g3d.shape.Mesh;

public class Tube {
    List<Vector3d> vertices;
    List<Color4d> colors;
    List<Double> radiis;
    Double radius = 1.0;
    int resolution = 8;

    public void setResolution(int resolution) {
        if (resolution > 2) {
            this.resolution = resolution;
        }
    }

    public void setVertices(List<Vector3d> vertices) {
        this.vertices = vertices;
    }

    public void setColors(List<Color4d> colors) {
        this.colors = colors;
    }

    public void setRadiis(List<Double> radiis) {
        this.radiis = radiis;
    }

    public void setRadius(Double radius) {
        this.radius = radius;
    }

    public Mesh create() {
        if (this.vertices.size() < 2) {
            throw new IllegalArgumentException("Tube must have at least two vertices");
        }
        Vector3d t = new Vector3d();
        int i = 0;
        while (i < this.vertices.size() - 1) {
            t.set((Tuple3d)this.vertices.get(i + 1));
            t.sub((Tuple3d)this.vertices.get(i));
            if (t.lengthSquared() < 1.0E-4) {
                throw new IllegalArgumentException("vertices at index " + i + " are too close to each other");
            }
            ++i;
        }
        ArrayList<Vector3d> points = new ArrayList<Vector3d>(this.vertices.size() * this.resolution);
        ArrayList<Vector3d> normals = new ArrayList<Vector3d>(this.vertices.size() * this.resolution);
        int i2 = 0;
        while (i2 < this.vertices.size()) {
            this.createCircle(i2, points, normals);
            ++i2;
        }
        int[] index = new int[(this.vertices.size() - 1) * this.resolution * 6];
        this.createIndices(index);
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int i3 = 0;
        while (i3 < index.length) {
            indices.add(index[i3]);
            ++i3;
        }
        this.vertices.clear();
        if (this.colors != null) {
            this.colors.clear();
        }
        if (this.radiis != null) {
            this.radiis.clear();
        }
        return new Mesh(points, normals, indices);
    }

    private void createCircle(int i, List<Vector3d> points, List<Vector3d> normals) {
        Vector3d up = new Vector3d(0.0, 1.0, 0.0);
        Vector3d up2 = new Vector3d(0.0, 0.0, 1.0);
        Vector3d p = this.vertices.get(i);
        Vector3d t = this.getTangent(i);
        Vector3d n = new Vector3d();
        if (up.dot(t) < 0.99) {
            n.cross(up, t);
        } else {
            n.cross(up2, t);
        }
        n.normalize();
        if (this.radiis != null) {
            n.scale(this.radiis.get(i).doubleValue());
        } else {
            n.scale(this.radius.doubleValue());
        }
        int index = 0;
        while (index < this.resolution) {
            Vector3d v;
            if (index == 0) {
                v = new Vector3d(n);
            } else {
                AxisAngle4d aa = new AxisAngle4d(t, Math.PI * 2 * (double)index / (double)this.resolution);
                v = new Vector3d();
                MathTools.rotate(MathTools.getQuat(aa), (Tuple3d)n, (Tuple3d)v);
            }
            Vector3d pt = new Vector3d(p);
            pt.add((Tuple3d)v);
            points.add(pt);
            v.normalize();
            normals.add(v);
            ++index;
        }
    }

    private Vector3d getTangent(int i) {
        Vector3d n;
        Vector3d p;
        if (i == 0) {
            p = this.vertices.get(0);
            n = this.vertices.get(1);
        } else if (i == this.vertices.size() - 1) {
            p = this.vertices.get(i - 1);
            n = this.vertices.get(i);
        } else {
            p = this.vertices.get(i - 1);
            n = this.vertices.get(i + 1);
        }
        n = new Vector3d(n);
        n.sub((Tuple3d)p);
        n.normalize();
        return n;
    }

    private void createIndices(int[] index) {
        int c = 0;
        while (c < this.vertices.size() - 1) {
            int s = 0;
            while (s < this.resolution) {
                int ii = (c * this.resolution + s) * 6;
                int iv = c * this.resolution + s;
                if (s < this.resolution - 1) {
                    index[ii + 2] = iv;
                    index[ii + 1] = iv + this.resolution;
                    index[ii + 0] = iv + this.resolution + 1;
                    index[ii + 5] = iv;
                    index[ii + 4] = iv + this.resolution + 1;
                    index[ii + 3] = iv + 1;
                } else {
                    index[ii + 2] = iv;
                    index[ii + 1] = iv + this.resolution;
                    index[ii + 0] = iv + 1;
                    index[ii + 5] = iv;
                    index[ii + 4] = iv + 1;
                    index[ii + 3] = iv + 1 - this.resolution;
                }
                ++s;
            }
            ++c;
        }
    }
}

