/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.scenegraph.base;

import java.util.ArrayList;
import java.util.List;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.g3d.scenegraph.base.NodeListener;
import org.simantics.g3d.scenegraph.base.ParentNode;

public abstract class Node
implements INode {
    public static transient long IDCOUNTER = 1L;
    protected transient ParentNode<?> parent = null;
    protected transient String parentName = null;
    protected Long id = IDCOUNTER++;
    protected List<NodeListener> listeners = new ArrayList<NodeListener>();

    public Long getId() {
        return this.id;
    }

    @Override
    public ParentNode<?> getParent() {
        return this.parent;
    }

    @Override
    public String getParentRel() {
        return this.parentName;
    }

    @Override
    public void setParent(ParentNode<?> parent, String name) {
        this.parent = parent;
        this.parentName = name;
    }

    @Override
    public ParentNode<?> getRootNode() {
        return this.parent != null ? this.parent.getRootNode() : null;
    }

    @Override
    public void remove() {
        if (this.parent != null) {
            this.parent.removeNode(this.parentName, this);
        }
    }

    public void deattach() {
        if (this.parent != null) {
            this.parent.deattachNode(this.parentName, this);
        }
    }

    public void init() {
    }

    @Override
    public void cleanup() {
        if (this.parent != null) {
            this.parent.removeNode(this.parentName, this);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void addListener(NodeListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeListener(NodeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public List<NodeListener> getListeners() {
        return this.listeners;
    }

    protected void firePropertyChanged(String id) {
        for (NodeListener listener : this.listeners) {
            listener.propertyChanged(this, id);
        }
    }
}

