/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.scenegraph;

import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import org.simantics.g3d.math.MathTools;
import org.simantics.g3d.property.annotations.GetPropertyValue;
import org.simantics.g3d.property.annotations.SetPropertyValue;
import org.simantics.g3d.scenegraph.IG3DNode;
import org.simantics.g3d.scenegraph.base.ParentNode;
import org.simantics.g3d.tools.NodeTools;
import org.simantics.objmap.graph.annotations.RelatedGetValue;
import org.simantics.objmap.graph.annotations.RelatedSetValue;

public class G3DparentNode<T extends IG3DNode>
extends ParentNode<T>
implements IG3DNode {
    private Vector3d position = new Vector3d();
    private Quat4d orientation = MathTools.getIdentityQuat();

    @Override
    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasOrientation", tabId="Transform", name="Orientation")
    public Quat4d getOrientation() {
        return this.orientation;
    }

    @RelatedGetValue(value="http://www.simantics.org/G3D-0.1/hasOrientation")
    public double[] getOrientationArr() {
        double[] arr = new double[4];
        this.orientation.get(arr);
        return arr;
    }

    @Override
    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasPosition", tabId="Transform", name="Position")
    public Vector3d getPosition() {
        return this.position;
    }

    @RelatedGetValue(value="http://www.simantics.org/G3D-0.1/hasPosition")
    public double[] getPositionArr() {
        double[] arr = new double[3];
        this.position.get(arr);
        return arr;
    }

    @Override
    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasOrientation")
    public void setOrientation(Quat4d orientation) {
        assert (orientation != null);
        this.orientation = orientation;
    }

    @Override
    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasPosition")
    public void setPosition(Vector3d position) {
        assert (position != null);
        this.position = position;
    }

    @RelatedSetValue(value="http://www.simantics.org/G3D-0.1/hasOrientation")
    public void setOrientation(double[] arr) {
        if (arr == null) {
            return;
        }
        this.setOrientation(new Quat4d(arr));
    }

    @RelatedSetValue(value="http://www.simantics.org/G3D-0.1/hasPosition")
    public void setPosition(double[] arr) {
        if (arr == null) {
            return;
        }
        this.setPosition(new Vector3d(arr));
    }

    @Override
    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldPosition", tabId="Transform", name="World Position")
    public Vector3d getWorldPosition() {
        IG3DNode parent = (IG3DNode)((Object)this.getParent());
        if (parent == null) {
            return this.position;
        }
        return NodeTools.getWorldPosition(parent, new Vector3d(this.position));
    }

    @Override
    public Vector3d getWorldPosition(Vector3d localPosition) {
        return NodeTools.getWorldPosition(this, localPosition);
    }

    @Override
    @GetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldOrientation", tabId="Transform", name="World Orientation")
    public Quat4d getWorldOrientation() {
        return this.getWorldOrientation(new Quat4d(this.orientation));
    }

    @Override
    public Quat4d getWorldOrientation(Quat4d localOrientation) {
        IG3DNode parent = (IG3DNode)((Object)this.getParent());
        if (parent == null) {
            return localOrientation;
        }
        return NodeTools.getWorldOrientation(parent, localOrientation);
    }

    @Override
    public Vector3d getLocalPosition(Vector3d worldPosition) {
        IG3DNode parent = (IG3DNode)((Object)this.getParent());
        if (parent == null) {
            return worldPosition;
        }
        return NodeTools.getLocalPosition(parent, new Vector3d(worldPosition));
    }

    @Override
    public Quat4d getLocalOrientation(Quat4d worldOrientation) {
        IG3DNode parent = (IG3DNode)((Object)this.getParent());
        if (parent == null) {
            return worldOrientation;
        }
        return NodeTools.getLocalOrientation(parent, new Quat4d(worldOrientation));
    }

    @Override
    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldPosition")
    public void setWorldPosition(Vector3d position) {
        Vector3d localPos = this.getLocalPosition(position);
        this.setPosition(localPos);
    }

    @Override
    @SetPropertyValue(value="http://www.simantics.org/G3D-0.1/hasWorldOrientation")
    public void setWorldOrientation(Quat4d orientation) {
        Quat4d localOr = this.getLocalOrientation(orientation);
        this.setOrientation(localOr);
    }

    public Object getAdapter(Class adapter) {
        return null;
    }
}

