/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g3d.property;

import javax.vecmath.Vector3d;
import org.simantics.g3d.property.PropertyManipulator;
import org.simantics.g3d.property.ValueProvider;

public class VectorPropertyManipulator
implements PropertyManipulator {
    ValueProvider provider;
    protected Object input;
    boolean editMode;
    Vector3d editValue = null;

    public VectorPropertyManipulator(ValueProvider provider, Object input) {
        this.provider = provider;
        this.input = input;
    }

    @Override
    public int getValueCount() {
        return 3;
    }

    @Override
    public String getDescription(int i) {
        if (i == 0) {
            return "X";
        }
        if (i == 1) {
            return "Y";
        }
        if (i == 2) {
            return "Z";
        }
        return null;
    }

    @Override
    public String getValue(int i) {
        Vector3d v;
        block6: {
            try {
                v = this._getValue();
                if (v != null) break block6;
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        if (i == 0) {
            return Double.toString(v.x);
        }
        if (i == 1) {
            return Double.toString(v.y);
        }
        if (i == 2) {
            return Double.toString(v.z);
        }
        return null;
    }

    @Override
    public String setValue(String value, int i) {
        try {
            Double d = Double.parseDouble(value);
            Vector3d v = this._getValue();
            v = new Vector3d(v.x, v.y, v.z);
            if (i == 0) {
                v.x = d;
            }
            if (i == 1) {
                v.y = d;
            }
            if (i == 2) {
                v.z = d;
            }
            this.editValue = v;
            this.setValue(v);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return null;
    }

    protected void setValue(Vector3d v) throws Exception {
        this.provider.setValue(this.input, v);
    }

    private Vector3d _getValue() throws Exception {
        if (this.editMode) {
            return this.editValue;
        }
        return (Vector3d)this.provider.getValue(this.input);
    }

    @Override
    public boolean getEditMode() {
        return this.editMode;
    }

    @Override
    public void setEditMode(boolean b) {
        this.editMode = b;
        if (this.editMode) {
            try {
                this.editValue = (Vector3d)this.provider.getValue(this.input);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

