/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.experiment;

import org.simantics.fmi.experiment.FMIExperiment;
import org.simantics.fmi.experiment.FMINodeBase;
import org.simantics.fmi.experiment.FMINodeManager;
import org.simantics.simulator.toolkit.DynamicExperimentThreadListener;
import org.simantics.simulator.toolkit.StandardNodeManager;
import org.simantics.simulator.toolkit.StandardNodeManagerSupport;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMIRealm
extends StandardRealm<FMINodeBase, FMIExperiment> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FMIRealm.class);
    public static final long VARIABLE_UPDATE_INTERVAL = 500000000L;
    volatile long previousVariableUpdateTime = 0L;
    volatile boolean skippedVariableUpdate = true;

    public FMIRealm(FMIExperiment engine, String id) {
        super((StandardNodeManagerSupport)engine, id);
        engine.thread.addListener(new DynamicExperimentThreadListener(){

            public void afterStep() {
                FMIRealm.this.asyncExec(() -> {
                    try {
                        FMIRealm.this.refreshVariables(false, 500000000L);
                    }
                    catch (NodeManagerException e) {
                        LOGGER.error("Error while processing updated from FMI simulation", (Throwable)e);
                    }
                });
            }
        });
    }

    protected StandardNodeManager<FMINodeBase, FMIExperiment> createManager() {
        return new FMINodeManager(this.getId(), this, (FMIExperiment)this.getEngine());
    }

    public Logger getLogger() {
        return LOGGER;
    }

    private void updateSubscriptions() {
        this.asyncExec(() -> {
            this.nodeManager.refreshVariablesSync();
            this.nodeManager.fireNodeListenersSync();
            this.skippedVariableUpdate = false;
        });
    }

    public void refreshVariables(boolean force, long updateIntervalNs) throws NodeManagerException {
        assert (this.executorThread == Thread.currentThread());
        long time = System.nanoTime();
        if (force || time - this.previousVariableUpdateTime > updateIntervalNs) {
            this.updateSubscriptions();
            this.previousVariableUpdateTime = time;
        } else {
            this.skippedVariableUpdate = true;
        }
    }
}

