/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.experiment;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.fmi.experiment.FMIChildNode;
import org.simantics.fmi.experiment.FMIExperimentDataFrame;
import org.simantics.fmi.experiment.FMIFolderNode;
import org.simantics.fmi.experiment.FMINodeBase;
import org.simantics.fmi.experiment.FMIValueNode;
import org.simantics.fmi.experiment.FMIVariableNode;
import org.simantics.fmi.experiment.HDF5Subscriptions;
import org.simantics.fmi.experiment.HDF5Support;
import org.simantics.fmil.core.FMIL;
import org.simantics.fmil.core.FMILException;
import org.simantics.simulator.ExperimentState;
import org.simantics.simulator.IDynamicExperimentLocal;
import org.simantics.simulator.toolkit.DynamicExperimentThread;
import org.simantics.simulator.toolkit.StandardExperimentStates;
import org.simantics.simulator.toolkit.StandardNodeManagerSupport;
import org.simantics.simulator.variable.exceptions.NodeManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMIExperiment
implements StandardNodeManagerSupport<FMINodeBase>,
IDynamicExperimentLocal {
    private static final Logger LOGGER = LoggerFactory.getLogger(FMIExperiment.class);
    private FMIExperimentDataFrame frame;
    private FMIL fmu;
    private String identifier;
    private HDF5Subscriptions subscriptions;
    private List<String> variableNames;
    protected DynamicExperimentThread thread;
    private final FMIFolderNode ROOT = new FMIFolderNode(null, "");
    private final HDF5Support hdf;
    private boolean initialized = false;

    public FMINodeBase getRootNode() {
        return this.ROOT;
    }

    private void createNodeImpl(FMIFolderNode folder, String variableName) {
        String[] parts = variableName.split("\\.");
        int i = 0;
        while (i < parts.length) {
            if (i == parts.length - 1) {
                FMIVariableNode variable = new FMIVariableNode(folder, parts[i]);
                folder.addChild(variable);
            } else {
                FMIChildNode node = folder.getChild(parts[i]);
                if (node == null) {
                    FMIFolderNode child = new FMIFolderNode(folder, parts[i]);
                    folder.addChild(child);
                    folder = child;
                } else {
                    folder = (FMIFolderNode)node;
                }
            }
            ++i;
        }
    }

    private void createNodes(String[] names) {
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            this.createNodeImpl(this.ROOT, name);
            ++n2;
        }
    }

    public FMIExperiment(File workingDirectory, File fmuFile, String id) throws Exception {
        Semaphore started = new Semaphore(0);
        this.hdf = new HDF5Support(workingDirectory);
        this.thread = new FMISimulatorThread(started, fmuFile, id);
        this.thread.start();
        started.acquire();
    }

    public <T> T getService(Class<T> clazz) {
        return null;
    }

    public List<String> getVariables() {
        return this.variableNames;
    }

    public boolean subscribe(String id) throws FMILException {
        return this.fmu.subscribe(id);
    }

    public boolean store(String name, boolean force) throws FMILException {
        block6: {
            block5: {
                if (this.initialized) {
                    throw new IllegalStateException("Stored variables cannot be set after initialization.");
                }
                try {
                    if (!force) break block5;
                    this.subscribe(name);
                    this.hdf.store(name);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            Object value = this.getVariableValueById(name);
            if (value == null) break block6;
            this.subscribe(name);
            this.hdf.store(name);
            return true;
        }
        LOGGER.error("Tried to subscribe to a variable that might be Internal datatype: <" + name + ">. Ignoring.");
        System.err.println("Tried to subscribe to a variable that might be Internal datatype: <" + name + ">. Ignoring.");
        return false;
    }

    public void setVariableValueById(String id, Object value, Binding binding) {
        if (!Bindings.DOUBLE.equals((Object)binding)) {
            throw new IllegalArgumentException("Invalid binding for variable '" + id + "' " + binding);
        }
        try {
            this.fmu.setRealValue(id, ((Double)value).doubleValue());
        }
        catch (FMILException e) {
            LOGGER.error("Cannot set variable value for id '" + id + "'", (Throwable)e);
        }
    }

    public Object getVariableValueById(String id) {
        try {
            return this.fmu.getRealValue(id);
        }
        catch (FMILException e) {
            LOGGER.error("Cannot retrive variable value for id '" + id + "'", (Throwable)e);
            return null;
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ExperimentState getStateL() {
        return this.thread.getExperimentState();
    }

    public void changeStateL(ExperimentState state) {
        this.thread.changeState(state);
    }

    protected boolean inState(Class<? extends ExperimentState> state) {
        return this.thread.inState(state);
    }

    public void shutdown(IProgressMonitor monitor) {
        this.changeStateL(StandardExperimentStates.TO_BE_DISPOSED);
    }

    protected void doDispose() {
        block6: {
            if (this.inState(StandardExperimentStates.Disposed.class)) {
                return;
            }
            this.changeStateL(StandardExperimentStates.DISPOSED);
            try {
                try {
                    this.fmu.unloadFMU();
                }
                catch (FMILException e) {
                    LOGGER.error("FMIExperiment.shutdown: fmu.unloadFMU failed", (Throwable)e);
                    this.fmu = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                this.fmu = null;
                throw throwable;
            }
            this.fmu = null;
        }
        this.hdf.end();
    }

    private void fetchSubscriptionsAndTime() throws Exception {
        double time = this.fmu.getTime();
        List subs = this.fmu.getSubscribedNames();
        double[] results = this.fmu.getSubscribedResults();
        this.frame = new FMIExperimentDataFrame(time, results.length);
        int i = 0;
        while (i < results.length) {
            this.frame.setValue((String)subs.get(i), results[i]);
            ++i;
        }
        this.hdf.update(subs, results, time);
    }

    public void simulate(boolean enabled) {
        if (enabled) {
            this.checkInitialization();
            long simulationStepNs = BigDecimal.valueOf(0.1).multiply(BigDecimal.valueOf(1.0E9)).longValue();
            System.out.println("Called simulate with: " + simulationStepNs);
            this.thread.setSimulationStepNs(simulationStepNs);
            long runDurationNs = Long.MAX_VALUE;
            this.thread.runDuration(runDurationNs);
        } else {
            this.thread.runDuration(0L);
        }
    }

    public void simulateDuration(double duration) {
        this.checkInitialization();
        long simulationStepNs = BigDecimal.valueOf(duration).multiply(BigDecimal.valueOf(1.0E9)).longValue();
        this.thread.setSimulationStepNs(simulationStepNs);
        this.thread.runDuration(simulationStepNs);
    }

    private void checkInitialization() {
        if (!this.initialized) {
            try {
                this.fmu.initializeSimulation();
                this.hdf.start();
                this.fetchSubscriptionsAndTime();
                this.initialized = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.initialized = false;
            }
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean initializeSimulation() {
        if (this.fmu == null) {
            return false;
        }
        if (!this.initialized) {
            this.checkInitialization();
        }
        return this.initialized;
    }

    public FMIExperimentDataFrame getCurrentDataFrame() {
        return this.frame;
    }

    public double getSimulationTime() {
        return this.frame.getTime();
    }

    public void doStep(double stepLengthMilliseconds) {
        try {
            this.fmu.setStepLength(stepLengthMilliseconds * 0.001);
            this.fmu.simulateStep();
            this.fetchSubscriptionsAndTime();
        }
        catch (Exception e) {
            LOGGER.error("Exception while stepping ", (Throwable)e);
        }
    }

    public void setEngineValue(FMINodeBase node, Object value) throws NodeManagerException {
        try {
            this.fmu.setRealValue(node.getVariableName(), ((Double)value).doubleValue());
            if (this.getStateL() == StandardExperimentStates.STOPPED) {
                this.frame.setValue(node.getVariableName(), value);
            }
        }
        catch (FMILException e) {
            throw new NodeManagerException((Throwable)e);
        }
    }

    public Object getEngineValueById(String id) throws NodeManagerException {
        try {
            this.subscribe(id);
        }
        catch (FMILException e) {
            throw new NodeManagerException((Throwable)e);
        }
        Object value = this.frame.getValue(id);
        if (value != null) {
            return value;
        }
        try {
            return this.thread.syncExec(() -> {
                Double v = this.fmu.getRealValue(id);
                this.frame.setValue(id, v);
                return v;
            });
        }
        catch (InterruptedException e) {
            throw new NodeManagerException((Throwable)e);
        }
    }

    public Object getEngineValue(FMINodeBase node) throws NodeManagerException {
        if (node instanceof FMIValueNode) {
            String id = ((FMIChildNode)node.parent).getPath();
            return this.getEngineValueById(id);
        }
        return null;
    }

    public Binding getEngineBinding(FMINodeBase node) throws NodeManagerException {
        return Bindings.DOUBLE;
    }

    public String getName(FMINodeBase node) {
        return node.name;
    }

    public Map<String, FMINodeBase> getChildren(FMINodeBase node) {
        if (node instanceof FMIChildNode) {
            List<FMINodeBase> childList = ((FMIChildNode)node).getChildren();
            HashMap<String, FMINodeBase> result = new HashMap<String, FMINodeBase>(childList.size());
            for (FMINodeBase child : childList) {
                result.put(child.name, child);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    public Map<String, FMINodeBase> getProperties(FMINodeBase node) {
        if (node instanceof FMIVariableNode) {
            List<FMINodeBase> childList = ((FMIVariableNode)node).getProperties();
            HashMap<String, FMINodeBase> result = new HashMap<String, FMINodeBase>(childList.size());
            for (FMINodeBase child : childList) {
                result.put(child.name, child);
            }
            return result;
        }
        return Collections.emptyMap();
    }

    class FMISimulatorThread
    extends DynamicExperimentThread {
        final Semaphore started;
        private final File fmuFile;
        private final String id;

        FMISimulatorThread(Semaphore started, File fmuFile, String id) {
            this.started = started;
            this.fmuFile = fmuFile;
            this.id = id;
        }

        public void step(double stepLengthNanoSeconds) {
            this.fireBeforeStep();
            FMIExperiment.this.doStep(stepLengthNanoSeconds * 1.0E-6);
            this.fireAfterStep();
        }

        public void initialize() throws Exception {
            try {
                FMIExperiment.this.identifier = this.id;
                FMIExperiment.this.fmu = new FMIL();
                String absPath = this.fmuFile.getAbsolutePath();
                FMIExperiment.this.subscriptions = new HDF5Subscriptions(this.fmuFile.getAbsolutePath());
                FMIExperiment.this.fmu.loadFMUFile(absPath);
                FMIExperiment.this.fmu.instantiateSimulation();
                ArrayList<String> notSuccessful = new ArrayList<String>();
                for (String sub : FMIExperiment.this.subscriptions.getAll()) {
                    if (FMIExperiment.this.store(sub, false)) continue;
                    notSuccessful.add(sub);
                }
                for (String sub : notSuccessful) {
                    FMIExperiment.this.store(sub, true);
                }
                String[] names = FMIExperiment.this.fmu.getAllVariables();
                FMIExperiment.this.createNodes(names);
                FMIExperiment.this.variableNames = new ArrayList(names.length);
                String[] stringArray = names;
                int n = names.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    FMIExperiment.this.variableNames.add(name);
                    ++n2;
                }
                FMIExperiment.this.frame = new FMIExperimentDataFrame(0.0, FMIExperiment.this.variableNames.size());
                for (String s : FMIExperiment.this.variableNames) {
                    FMIExperiment.this.frame.setValue(s, 0.0);
                }
                FMIExperiment.this.changeStateL(StandardExperimentStates.STOPPED);
                this.started.release();
            }
            catch (FMILException e) {
                throw new Exception(e);
            }
            catch (IllegalArgumentException e) {
                throw new Exception(e);
            }
            catch (SecurityException e) {
                throw new Exception(e);
            }
        }

        public void deinitialize() throws Exception {
            FMIExperiment.this.doDispose();
        }
    }
}

