/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.fmi.experiment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.simantics.fmi.experiment.FMINodeBase;

public class FMIChildNode
extends FMINodeBase {
    private List<FMINodeBase> children = Collections.emptyList();

    public FMIChildNode(FMINodeBase parent, String name) {
        super(parent, name);
    }

    public void addChild(FMIChildNode child) {
        if (this.children.isEmpty()) {
            this.children = new ArrayList<FMINodeBase>();
        }
        this.children.add(child);
    }

    public List<FMINodeBase> getChildren() {
        return this.children;
    }

    public FMIChildNode getChild(String name) {
        for (FMINodeBase n : this.children) {
            if (!name.equals(n.name)) continue;
            return (FMIChildNode)n;
        }
        return null;
    }

    public String getPath() {
        if (this.parent == null) {
            return "";
        }
        if (this.parent.parent == null) {
            return this.name;
        }
        return String.valueOf(((FMIChildNode)this.parent).getPath()) + "." + this.name;
    }

    public String toString() {
        return "FMIChildNode " + this.getPath();
    }
}

