/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.example.old;

import java.awt.geom.Rectangle2D;
import java.io.IOException;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.type.Datatype;

/**
 * This example demostrates how to use String serialization.
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class SerializerExample2 {

	public static void main(String[] args) throws SerializationException, IOException, BindingException, DataTypeSyntaxError {

		// Create Rectangle
		Rectangle2D rect = new Rectangle2D.Double(5, 5, 100, 200);
		Binding rectangleBinding = Bindings.getBindingUnchecked( Rectangle2D.Double.class );
		Datatype rectangleDataType = rectangleBinding.type();
		
		// Print Rectangle Instance
		System.out.println( rectangleBinding.printValueDefinition(rect, true) );
		
		// Print Rectangle DataType
		Binding dataTypeBinding = Bindings.getBindingUnchecked( Datatype.class );
		System.out.println( dataTypeBinding.printValueDefinition(rectangleDataType, true) );
		
		Datatype vectorType = Datatypes.getDatatypeUnchecked(RepresentationExample2.Vector.class);
		System.out.println( dataTypeBinding.printValueDefinition(vectorType, true ) );
		
		// Decode Recrangle
		rect = (Rectangle2D) rectangleBinding.parseValueDefinition( "(10, 10, 200, 200)" );
		
		// Print decoded rectangle
		System.out.println(rect);
		
	}
	
}

