/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.ISessionContextProviderSource;
import org.simantics.db.management.SessionContextProvider;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.internal.SessionUtils;

public class WorkbenchWindowSessionContextProviderSource
implements ISessionContextProviderSource,
IWindowListener {
    private static final boolean DEBUG = false;
    ISessionContextProvider[] ZERO = new ISessionContextProvider[0];
    Object temporaryContext = new Object(){

        public String toString() {
            return "Temporary Context Object";
        }
    };
    Set<Object> manualProviders = new HashSet<Object>();
    Map<Object, ISessionContextProvider> providers = new HashMap<Object, ISessionContextProvider>();
    ISessionContextProvider[] allProviders = this.ZERO;
    IWorkbenchWindow activeWindow = null;
    ISessionContextProvider activeProvider = null;
    AtomicBoolean isFirstWindow = new AtomicBoolean(true);

    public WorkbenchWindowSessionContextProviderSource(IWorkbench workbench) {
        workbench.addWindowListener((IWindowListener)this);
        this.activeProvider = new SessionContextProvider(this.temporaryContext);
        this.addProvider(this.temporaryContext, this.activeProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISessionContextProvider get(Object context) {
        Map<Object, ISessionContextProvider> map = this.providers;
        synchronized (map) {
            return this.providers.get(context);
        }
    }

    public ISessionContextProvider getActive() {
        return this.activeProvider;
    }

    public ISessionContextProvider[] getAll() {
        return this.allProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object context, ISessionContextProvider provider) {
        Map<Object, ISessionContextProvider> map = this.providers;
        synchronized (map) {
            ISessionContextProvider prev = this.providers.get(context);
            if (prev != null) {
                throw new IllegalArgumentException("invalid context (" + context + "), a session context provider is already associated with this context: " + prev + ". Attempted to associate the context with this provider: " + provider);
            }
            this.providers.put(context, provider);
            this.manualProviders.add(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISessionContextProvider remove(Object context) {
        Map<Object, ISessionContextProvider> map = this.providers;
        synchronized (map) {
            if (!this.manualProviders.remove(context)) {
                throw new IllegalArgumentException("specified context not found: " + context);
            }
            return this.providers.remove(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windowActivated(IWorkbenchWindow window) {
        boolean firstActiveWindow = this.activeWindow == null;
        this.activeWindow = window;
        if (firstActiveWindow) {
            assert (this.activeProvider != null);
        } else {
            Map<Object, ISessionContextProvider> map = this.providers;
            synchronized (map) {
                this.activeProvider = this.providers.get(window);
                if (this.activeProvider == null) {
                    this.activeProvider = new SessionContextProvider((Object)window);
                    this.addProvider(window, this.activeProvider);
                }
            }
        }
    }

    public void windowClosed(IWorkbenchWindow window) {
        this.removeProvider(window);
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProvider(Object context, ISessionContextProvider p) {
        Map<Object, ISessionContextProvider> map = this.providers;
        synchronized (map) {
            if (this.providers.put(context, p) != null) {
                throw new Error("Bug encountered, contact application support with stack trace.");
            }
            this.allProviders = this.providers.values().toArray(this.ZERO);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeProvider(Object context) {
        Map<Object, ISessionContextProvider> map = this.providers;
        synchronized (map) {
            ISessionContextProvider provider = this.providers.remove(context);
            if (provider == null) {
                throw new Error("Bug encountered, contact application support with stack trace.");
            }
            this.allProviders = this.providers.values().toArray(this.ZERO);
            ISessionContext ctx = provider.getSessionContext();
            if (ctx != null && !SimanticsUI.isInUse(ctx)) {
                SessionUtils.releaseUnusedSessionAfterHoldTime(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createProviderForWindow(IWorkbenchWindow context) {
        Map<Object, ISessionContextProvider> map = this.providers;
        synchronized (map) {
            if (this.isFirstWindow.compareAndSet(true, false)) {
                assert (this.activeProvider != null);
                SessionContextProvider v = (SessionContextProvider)this.providers.remove(this.temporaryContext);
                if (v != null) {
                    v.setHandle((Object)context);
                    this.providers.put(context, (ISessionContextProvider)v);
                }
            } else {
                SessionContextProvider v = new SessionContextProvider((Object)context);
                ISessionContextProvider active = this.getActive();
                if (active != null) {
                    v.setSessionContext(active.getSessionContext());
                }
                this.addProvider(context, (ISessionContextProvider)v);
            }
        }
    }
}

