/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.history;

import gnu.trove.list.array.TDoubleArrayList;
import java.io.IOException;
import java.math.BigDecimal;
import org.simantics.history.HistoryException;
import org.simantics.history.HistorySamplerItem;
import org.simantics.history.HistorySamplerItem2;
import org.simantics.history.csv.ExportInterpolation;
import org.simantics.history.util.HistoryExportUtil;
import org.simantics.history.util.StreamIterator;
import org.simantics.history.util.ValueBand;

public class HistorySampler {
    public static synchronized TDoubleArrayList sample(HistorySamplerItem item, double from, double end, double timeWindow, double timeStep, boolean resample) throws HistoryException, IOException {
        try {
            if (item.collector != null) {
                item.collector.flush();
            }
            item.open();
            TDoubleArrayList tDoubleArrayList = HistorySampler.sample(item.iter, from, end, timeWindow, timeStep, resample);
            return tDoubleArrayList;
        }
        finally {
            item.close();
        }
    }

    public static TDoubleArrayList sample(StreamIterator iter, double from, double end, double timeWindow, double timeStep, boolean resample) throws HistoryException, IOException {
        return HistorySampler.sample(iter, from, end, timeWindow, timeStep, resample, 0.0);
    }

    public static TDoubleArrayList sample(StreamIterator iter, double from, double end, double timeWindow, double timeStep, boolean resample, Double sampleFrom) throws HistoryException, IOException {
        boolean hasMore;
        boolean ignore;
        ExportInterpolation numberInterpolation = ExportInterpolation.LINEAR_INTERPOLATION;
        double startTime = from;
        if (sampleFrom != null) {
            startTime = sampleFrom;
        }
        TDoubleArrayList result = new TDoubleArrayList();
        if (iter.isEmpty()) {
            return result;
        }
        double allFrom = iter.getFirstTime();
        double allEnd = 1.0E11;
        if (from > allEnd + timeStep) {
            from = allEnd - timeWindow;
            end = allEnd;
        }
        boolean hasAnyValues = allFrom != Double.MAX_VALUE && allEnd != -1.7976931348623157E308;
        double _from = Double.MAX_VALUE;
        double _end = -1.7976931348623157E308;
        if (hasAnyValues) {
            _from = Math.max(allFrom, from);
            _end = Math.min(allEnd, end);
        }
        if (!hasAnyValues) {
            return result;
        }
        double time = _from;
        if (!resample) {
            time = _from;
            timeStep = 0.0;
        } else if (timeStep > 0.0) {
            double n = Math.max(0.0, Math.ceil((_from - startTime) / timeStep));
            time = startTime + n * timeStep;
        } else if (startTime > _from) {
            time = startTime;
        }
        BigDecimal bigTime = new BigDecimal(String.valueOf(time));
        BigDecimal bigTimeStep = new BigDecimal(String.valueOf(timeStep));
        if (!iter.gotoTime(time)) {
            return result;
        }
        boolean bl = ignore = Math.abs(time - from) < 1.0E-6;
        do {
            block29: {
                Object value;
                block30: {
                    block31: {
                        if (!iter.hasValidValue()) break block29;
                        if (!ignore) {
                            result.add(time);
                        }
                        if (!((value = iter.getValueBand().getValue()) instanceof Number)) break block30;
                        if (!(value instanceof Float) && !(value instanceof Double)) break block31;
                        switch (numberInterpolation) {
                            case PREVIOUS_SAMPLE: {
                                if (!ignore) {
                                    result.add(((Number)value).doubleValue());
                                }
                                break block29;
                            }
                            case LINEAR_INTERPOLATION: {
                                if (time != iter.getValueBand().getTimeDouble() && iter.hasNext()) {
                                    int currentIndex = iter.getIndex();
                                    ValueBand band = iter.getValueBand();
                                    Number v1 = (Number)value;
                                    double t12 = band.getEndTimeDouble();
                                    iter.next();
                                    double t2 = iter.getValueBand().getTimeDouble();
                                    Number v2 = (Number)iter.getValueBand().getValue();
                                    iter.gotoIndex(currentIndex);
                                    double vs = v1.doubleValue();
                                    if (time > t12) {
                                        vs = HistoryExportUtil.biglerp(t12, v1.doubleValue(), t2, v2.doubleValue(), time);
                                    }
                                    if (!ignore) {
                                        result.add(vs);
                                    }
                                } else if (!ignore) {
                                    result.add(((Number)value).doubleValue());
                                }
                                break block29;
                            }
                            default: {
                                throw new UnsupportedOperationException("Unsupported interpolation: " + (Object)((Object)numberInterpolation));
                            }
                        }
                    }
                    throw new IllegalStateException("Value is not a number " + value);
                }
                if (value instanceof Boolean) {
                    if (!ignore) {
                        result.add((Boolean)value != false ? 1.0 : 0.0);
                    }
                } else {
                    throw new IllegalStateException("Value is not a number " + value);
                }
            }
            ignore = false;
            if (timeStep > 0.0) {
                bigTime = bigTime.add(bigTimeStep);
                time = bigTime.doubleValue();
            } else {
                Double nextTime = null;
                if (!iter.hasNext()) break;
                Double itemNextTime = iter.getNextTime(time);
                if (nextTime == null || nextTime > itemNextTime && !itemNextTime.equals(time)) {
                    nextTime = itemNextTime;
                }
                if (nextTime == null || nextTime.equals(time)) break;
                time = nextTime;
            }
            hasMore = false;
            iter.proceedToTime(time);
            if (!HistoryExportUtil.contains(iter, time)) continue;
            hasMore = true;
        } while (hasMore && time <= _end);
        return result;
    }

    public static synchronized TDoubleArrayList sample(HistorySamplerItem2 item, double end, double timeWindow, int maxSamples, boolean resample) throws HistoryException, IOException {
        try {
            if (item.collector != null) {
                item.collector.flush();
            }
            double pixelsPerSecond = (double)maxSamples / timeWindow;
            item.open(pixelsPerSecond);
            TDoubleArrayList tDoubleArrayList = HistorySampler.sample(item.iter, end, timeWindow, maxSamples, resample);
            return tDoubleArrayList;
        }
        finally {
            item.close();
        }
    }

    private static TDoubleArrayList sample(StreamIterator iter, double end, double timeWindow, int maxSamples, boolean resample) throws HistoryException, IOException {
        boolean hasMore;
        boolean ignore;
        boolean hasAnyValues;
        ExportInterpolation numberInterpolation = ExportInterpolation.LINEAR_INTERPOLATION;
        double timeStep = 0.0;
        double startTime = -1.0E10;
        TDoubleArrayList result = new TDoubleArrayList();
        if (iter.isEmpty()) {
            return result;
        }
        double allFrom = iter.getFirstTime();
        double allEnd = iter.getLastTime();
        double from = allEnd - timeWindow;
        end = allEnd;
        boolean bl = hasAnyValues = allFrom != Double.MAX_VALUE && allEnd != -1.7976931348623157E308;
        if (!hasAnyValues) {
            return result;
        }
        double _from = Math.max(allFrom, from);
        double _end = Math.min(allEnd, end);
        double time = _from;
        if (!resample) {
            time = _from;
            timeStep = 0.0;
        } else if (timeStep > 0.0) {
            double n = Math.max(0.0, Math.ceil((_from - startTime) / timeStep));
            time = startTime + n * timeStep;
        } else if (startTime > _from) {
            time = startTime;
        }
        BigDecimal bigTime = new BigDecimal(String.valueOf(time));
        BigDecimal bigTimeStep = new BigDecimal(String.valueOf(timeStep));
        if (!iter.gotoTime(time)) {
            return result;
        }
        boolean bl2 = ignore = Math.abs(time - from) < 1.0E-6;
        do {
            block26: {
                Object value;
                block27: {
                    block28: {
                        if (!iter.hasValidValue()) break block26;
                        if (!ignore) {
                            result.add(time);
                        }
                        if (!((value = iter.getValueBand().getValue()) instanceof Number)) break block27;
                        if (!(value instanceof Float) && !(value instanceof Double)) break block28;
                        switch (numberInterpolation) {
                            case PREVIOUS_SAMPLE: {
                                if (!ignore) {
                                    result.add(((Number)value).doubleValue());
                                }
                                break block26;
                            }
                            case LINEAR_INTERPOLATION: {
                                if (time != iter.getValueBand().getTimeDouble() && iter.hasNext()) {
                                    int currentIndex = iter.getIndex();
                                    ValueBand band = iter.getValueBand();
                                    Number v1 = (Number)value;
                                    double t12 = band.getEndTimeDouble();
                                    iter.next();
                                    double t2 = iter.getValueBand().getTimeDouble();
                                    Number v2 = (Number)iter.getValueBand().getValue();
                                    iter.gotoIndex(currentIndex);
                                    double vs = v1.doubleValue();
                                    if (time > t12) {
                                        vs = HistoryExportUtil.biglerp(t12, v1.doubleValue(), t2, v2.doubleValue(), time);
                                    }
                                    if (!ignore) {
                                        result.add(vs);
                                    }
                                } else if (!ignore) {
                                    result.add(((Number)value).doubleValue());
                                }
                                break block26;
                            }
                            default: {
                                throw new UnsupportedOperationException("Unsupported interpolation: " + (Object)((Object)numberInterpolation));
                            }
                        }
                    }
                    throw new IllegalStateException("Value is not a number " + value);
                }
                if (value instanceof Boolean) {
                    if (!ignore) {
                        result.add((Boolean)value != false ? 1.0 : 0.0);
                    }
                } else {
                    throw new IllegalStateException("Value is not a number " + value);
                }
            }
            ignore = false;
            if (timeStep > 0.0) {
                bigTime = bigTime.add(bigTimeStep);
                time = bigTime.doubleValue();
            } else {
                Double nextTime = null;
                if (!iter.hasNext()) break;
                Double itemNextTime = iter.getNextTime(time);
                if (nextTime == null || nextTime > itemNextTime && !itemNextTime.equals(time)) {
                    nextTime = itemNextTime;
                }
                if (nextTime == null || nextTime.equals(time)) break;
                time = nextTime;
            }
            hasMore = false;
            iter.proceedToTime(time);
            if (!HistoryExportUtil.contains(iter, time)) continue;
            hasMore = true;
        } while (hasMore && time <= _end);
        return result;
    }
}

