/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulation.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.ObjectIdentitySchedulingRule;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.ui.SimanticsUI;

public class SaveState
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IExperimentManager manager = (IExperimentManager)SimanticsUI.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment instanceof IDynamicExperiment) {
            SaveStateJob j = new SaveStateJob((IDynamicExperiment)experiment);
            j.setRule((ISchedulingRule)new ObjectIdentitySchedulingRule((Object)experiment));
            j.schedule();
        }
        return null;
    }

    static class SaveStateJob
    extends Job {
        private final IDynamicExperiment experiment;

        public SaveStateJob(IDynamicExperiment experiment) {
            super("Save Experiment State");
            this.experiment = experiment;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask("", -1);
                this.experiment.saveState();
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            catch (Throwable t) {
                Status status = new Status(4, "org.simantics.simulation.ui", "Failed to save state of dynamic experiment " + this.experiment + " with ID " + this.experiment.getIdentifier(), t);
                return status;
            }
            finally {
                monitor.done();
            }
        }
    }
}

