/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.swing;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.general.SeriesException;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.simantics.scenegraph.ExportableWidget;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.IdentityAffineTransform;
import org.simantics.scenegraph.g2d.nodes.Trend2DNode;
import org.simantics.scenegraph.swing.ComponentNode;

@ExportableWidget.RasterOutputWidget
public class JFreeTrendNode
extends ComponentNode<JPanel> {
    private static final long serialVersionUID = 8508750881358776559L;
    protected String title = null;
    protected String yTitle = null;
    protected String xTitle = null;
    protected transient List<Trend2DNode.TrendPoint> points = null;
    protected transient XYSeries series = null;

    @Override
    public void init() {
        this.series = new XYSeries((Comparable)((Object)"Trend"));
        XYSeriesCollection dataset = new XYSeriesCollection(this.series);
        if (this.title == null) {
            this.title = "Trend";
        }
        if (this.xTitle == null) {
            this.xTitle = "Value";
        }
        if (this.yTitle == null) {
            this.yTitle = "Time";
        }
        this.scale = true;
        JFreeChart chart = ChartFactory.createXYLineChart((String)this.title, (String)this.xTitle, (String)this.yTitle, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        XYPlot plot = chart.getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis.setAutoRange(true);
        this.component = new ChartPanel(chart, false);
        ((ChartPanel)this.component).setRefreshBuffer(false);
        ((JPanel)this.component).setIgnoreRepaint(true);
        ((JPanel)this.component).setDoubleBuffered(false);
        if (this.bounds != null) {
            ((JPanel)this.component).setBounds(0, 0, 0, 0);
        }
        if (this.points != null) {
            for (Trend2DNode.TrendPoint p : this.points) {
                try {
                    this.series.add(p.getX(), p.getY());
                }
                catch (SeriesException seriesException) {}
            }
        }
        super.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(Graphics2D g2d) {
        if (this.component != null) {
            AffineTransform ot = g2d.getTransform();
            double scaleX = ot.getScaleX();
            double scaleY = ot.getScaleY();
            if (this.transform == IdentityAffineTransform.INSTANCE) {
                this.transform = new AffineTransform();
            }
            AffineTransform affineTransform = this.transform;
            synchronized (affineTransform) {
                this.transform.setToTranslation(this.bounds.getMinX(), this.bounds.getMinY());
                this.transform.scale(1.0 / scaleX, 1.0 / scaleY);
            }
            g2d.transform(this.transform);
            int width = (int)(this.bounds.getWidth() * scaleX);
            int height = (int)(this.bounds.getHeight() * scaleY);
            ((JPanel)this.component).setLocation((int)g2d.getTransform().getTranslateX(), (int)g2d.getTransform().getTranslateY());
            if (((JPanel)this.component).getSize().getWidth() != (double)width || ((JPanel)this.component).getSize().getHeight() != (double)height) {
                ((JPanel)this.component).setSize(width, height);
            }
            ((JPanel)this.component).paint(g2d);
            g2d.setTransform(ot);
        }
    }

    @INode.SyncField(value={"title"})
    public void setTitle(String title) {
        this.title = title;
        if (this.component != null) {
            ((ChartPanel)this.component).getChart().setTitle(title);
        }
    }

    @INode.SyncField(value={"xTitle"})
    public void setXTitle(String xTitle) {
        this.xTitle = xTitle;
        if (this.component != null) {
            ((ChartPanel)this.component).getChart().getXYPlot().getDomainAxis().setLabel(xTitle);
        }
    }

    @INode.SyncField(value={"yTitle"})
    public void setYTitle(String yTitle) {
        this.yTitle = yTitle;
        if (this.component != null) {
            ((ChartPanel)this.component).getChart().getXYPlot().getRangeAxis().setLabel(yTitle);
        }
    }

    @Override
    @INode.SyncField(value={"bounds"})
    public void setBounds(Rectangle2D bounds) {
        this.bounds = bounds;
    }

    @INode.SyncField(value={"points"})
    protected void setPoints(List<Trend2DNode.TrendPoint> points) {
        this.points = points;
        if (this.series != null) {
            this.series.clear();
            for (Trend2DNode.TrendPoint p : points) {
                try {
                    this.series.add(p.getX(), p.getY());
                }
                catch (SeriesException seriesException) {}
            }
        }
    }

    @INode.ClientSide
    protected void appendPoints(List<Trend2DNode.TrendPoint> points) {
        if (this.points == null) {
            this.points = new ArrayList<Trend2DNode.TrendPoint>();
        }
        if (this.location.equals((Object)INode.Location.REMOTE)) {
            this.points.addAll(points);
        }
        for (Trend2DNode.TrendPoint p : points) {
            try {
                this.series.add(p.getX(), p.getY());
            }
            catch (SeriesException seriesException) {}
        }
    }

    public void updatePoints(List<Trend2DNode.TrendPoint> newpoints) {
        if (this.points == null) {
            this.points = new ArrayList<Trend2DNode.TrendPoint>();
        }
        int n = newpoints.size() - 1;
        while (n >= 0) {
            int t = 0;
            int o = this.points.size() - 1;
            while (o >= 0) {
                if (!newpoints.get(n - t).equals(this.points.get(o))) break;
                if (o == 0 || o < this.points.size() - 10) {
                    ArrayList<Trend2DNode.TrendPoint> appendedPoints = new ArrayList<Trend2DNode.TrendPoint>();
                    int i = n;
                    while (i < newpoints.size() - 1) {
                        appendedPoints.add(newpoints.get(i));
                        ++i;
                    }
                    this.points = new ArrayList<Trend2DNode.TrendPoint>(newpoints);
                    if (appendedPoints != null && appendedPoints.size() > 0) {
                        this.appendPoints(appendedPoints);
                    }
                    return;
                }
                if (n - t == 0) {
                    this.setPoints(newpoints);
                    return;
                }
                ++t;
                --o;
            }
            --n;
        }
        this.setPoints(newpoints);
    }
}

