/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.browser.sections;

import java.io.PrintWriter;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.sections.ResourceBrowserSection;
import org.simantics.debug.browser.utils.Escapes;

public class BreadcrumbSection
implements ResourceBrowserSection {
    public final Node[] breadcrumb;

    public BreadcrumbSection(Node[] breadcrumb) {
        this.breadcrumb = breadcrumb;
    }

    @Override
    public double getPriority() {
        return 0.0;
    }

    @Override
    public void toHtml(ReadGraph graph, PrintWriter out) throws DatabaseException {
        if (this.breadcrumb.length > 0) {
            out.println("<div class=\"breadcrumbSection\">");
            Node[] nodeArray = this.breadcrumb;
            int n = this.breadcrumb.length;
            int n2 = 0;
            while (n2 < n) {
                Node node = nodeArray[n2];
                out.print(node.separator);
                out.print("<a href=\"");
                out.print(node.resourceId);
                out.print("\">");
                out.print(Escapes.html(node.name));
                out.print("</a>");
                ++n2;
            }
            out.println("</div>");
        }
    }

    public static class Node {
        public final String separator;
        public final String name;
        public final long resourceId;

        public Node(String separator, String name, long resourceId) {
            this.separator = separator;
            this.name = name;
            this.resourceId = resourceId;
        }
    }
}

