/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.formula;

import org.simantics.spreadsheet.graph.CellFormulaFunction;
import org.simantics.spreadsheet.graph.CellValueVisitor;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.graph.SpreadsheetMatrix;
import org.simantics.spreadsheet.graph.formula.FormulaError2;
import org.simantics.spreadsheet.graph.parser.ast.AstArgList;
import org.simantics.spreadsheet.graph.parser.ast.AstValue;

class SumFormulaFunction
implements CellFormulaFunction<Object> {
    SumFormulaFunction() {
    }

    @Override
    public Object evaluate(CellValueVisitor visitor, AstArgList args) {
        Double sum = 0.0;
        for (AstValue value : args.values) {
            Object result = value.accept(visitor);
            if (result instanceof SpreadsheetMatrix) {
                Object value2 = ((SpreadsheetMatrix)result).sumWithFormulaError();
                if (value2 instanceof String) {
                    return value2;
                }
                sum = sum + ((Number)value2).doubleValue();
                continue;
            }
            if (result instanceof String && !result.equals("")) {
                FormulaError2 error = FormulaError2.forString(result.toString());
                if (error != null) {
                    return error.getString();
                }
                Double v = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(result);
                if (v == null) continue;
                sum = sum + v;
                continue;
            }
            sum = result instanceof Number ? Double.valueOf(sum + ((Number)result).doubleValue()) : Double.valueOf(sum + SpreadsheetGraphUtils.asNumber(result));
        }
        return sum;
    }
}

