/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.formula;

import org.apache.commons.math3.stat.regression.OLSMultipleLinearRegression;
import org.simantics.spreadsheet.graph.CellFormulaFunction;
import org.simantics.spreadsheet.graph.CellValueVisitor;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.graph.SpreadsheetMatrix;
import org.simantics.spreadsheet.graph.formula.FormulaError2;
import org.simantics.spreadsheet.graph.parser.ast.AstArgList;

public class LinestFormulaFunction
implements CellFormulaFunction<SpreadsheetMatrix> {
    @Override
    public SpreadsheetMatrix evaluate(CellValueVisitor visitor, AstArgList args) {
        if (args.values.size() != 4) {
            throw new IllegalStateException();
        }
        Object ys = args.values.get(0).accept(visitor);
        Object xs = args.values.get(1).accept(visitor);
        if (xs instanceof SpreadsheetMatrix) {
            OLSMultipleLinearRegression reg = new OLSMultipleLinearRegression();
            SpreadsheetMatrix xsm = (SpreadsheetMatrix)xs;
            SpreadsheetMatrix ysm = (SpreadsheetMatrix)ys;
            if (xsm.getWidth() > 1) {
                double[] y = new double[ysm.values.length];
                double[][] x = new double[ysm.values.length][xsm.getWidth()];
                int i = 0;
                while (i < ysm.values.length) {
                    y[i] = SpreadsheetGraphUtils.asNumber(ysm.values[i]);
                    int j = 0;
                    while (j < xsm.getWidth()) {
                        x[i][j] = SpreadsheetGraphUtils.asNumber(xsm.get(i, j));
                        ++j;
                    }
                    ++i;
                }
                reg.newSampleData(y, x);
                int width = xsm.getWidth() + 1;
                SpreadsheetMatrix result = new SpreadsheetMatrix(width, 5);
                double[] pars = reg.estimateRegressionParameters();
                int i2 = 0;
                while (i2 < width) {
                    result.set(0, width - i2 - 1, pars[i2]);
                    ++i2;
                }
                double[] errs = reg.estimateRegressionParametersStandardErrors();
                int i3 = 0;
                while (i3 < width) {
                    result.set(1, width - i3 - 1, errs[i3]);
                    ++i3;
                }
                double sstotal = reg.calculateTotalSumOfSquares();
                double ssresid = reg.calculateResidualSumOfSquares();
                double ssreg = sstotal - ssresid;
                double F = 0.0;
                double r2 = ssreg / sstotal;
                double sey = reg.estimateRegressionStandardError();
                double df = width;
                result.set(2, 0, r2);
                result.set(2, 1, sey);
                result.set(3, 0, F);
                result.set(3, 1, df);
                result.set(4, 0, ssreg);
                result.set(4, 1, ssresid);
                result.set(2, 2, FormulaError2.NA.getString());
                result.set(3, 2, FormulaError2.NA.getString());
                result.set(4, 2, FormulaError2.NA.getString());
                return result;
            }
        }
        return null;
    }
}

