/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Collection;
import java.util.HashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ProxyVariables;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.simulator.toolkit.db.StandardSessionManager;
import org.simantics.spreadsheet.graph.SheetNode;
import org.simantics.spreadsheet.graph.SpreadsheetBook;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.graph.SpreadsheetRealm;
import org.simantics.spreadsheet.graph.formula.SpreadsheetEvaluationEnvironment;
import org.simantics.spreadsheet.graph.synchronization.SpreadsheetSynchronizationEventHandler;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.structural.synchronization.Synchronizer;
import org.simantics.structural.synchronization.protocol.SynchronizationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadsheetSessionManager
extends StandardSessionManager<SheetNode, SpreadsheetBook> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpreadsheetSessionManager.class);
    private static SpreadsheetSessionManager INSTANCE;

    public static SpreadsheetSessionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SpreadsheetSessionManager();
        }
        return INSTANCE;
    }

    private SpreadsheetBook getPossibleInitialCondition(ReadGraph graph, Resource context, Resource book) throws DatabaseException {
        SpreadsheetResource SR = SpreadsheetResource.getInstance((ReadGraph)graph);
        Collection ics = graph.getObjects(context, SR.HasInitialCondition);
        Resource found = null;
        HashSet<Resource> founds = new HashSet<Resource>();
        HashSet<Resource> foundDefaults = new HashSet<Resource>();
        for (Resource initialCondition : ics) {
            if (graph.hasStatement(book, SR.Book_HasDefaultInitialCondition, initialCondition)) {
                foundDefaults.add(initialCondition);
            }
            if (!graph.hasStatement(initialCondition, SR.InitialCondition_ConditionOf, book)) continue;
            founds.add(initialCondition);
        }
        if (foundDefaults.size() == 1) {
            found = (Resource)foundDefaults.iterator().next();
        } else if (foundDefaults.size() == 0 && founds.size() == 1) {
            found = (Resource)founds.iterator().next();
        } else {
            System.err.println("Could not find IC for SpreadsheetBook " + graph.getPossibleURI(book));
            System.err.println("foundDefaults : " + foundDefaults.size());
            if (!foundDefaults.isEmpty()) {
                for (Resource foundDefault : foundDefaults) {
                    System.err.println(graph.getPossibleURI(foundDefault));
                }
            }
            System.err.println("founds : " + founds.size());
            if (!founds.isEmpty()) {
                for (Resource foun : founds) {
                    System.err.println(graph.getPossibleURI(foun));
                }
            }
        }
        if (found != null) {
            try {
                File tmp = SpreadsheetGraphUtils.extractInitialCondition(graph, found);
                System.err.println("Extracting IC from " + tmp.getAbsolutePath());
                BufferedInputStream fileIn = new BufferedInputStream(new FileInputStream(tmp));
                ClassLoaderObjectInputStream in = new ClassLoaderObjectInputStream(((Object)((Object)this)).getClass().getClassLoader(), fileIn);
                SpreadsheetBook srBook = (SpreadsheetBook)in.readObject();
                in.close();
                return srBook;
            }
            catch (IOException e) {
                throw new DatabaseException((Throwable)e);
            }
            catch (ClassNotFoundException e) {
                throw new DatabaseException((Throwable)e);
            }
        }
        return null;
    }

    protected SpreadsheetBook createEngine(ReadGraph graph, String id) throws DatabaseException {
        Variable run = Variables.getVariable((ReadGraph)graph, (String)id);
        Variable context = ProxyVariables.proxyVariableInput((ReadGraph)graph, (Variable)run);
        if (context != null) {
            SpreadsheetBook ic;
            Variable base = ProxyVariables.proxyVariableBase((ReadGraph)graph, (Variable)run);
            Resource bookResource = base.getRepresents(graph);
            Resource contextResource = context.getRepresents(graph);
            if (contextResource != null && (ic = this.getPossibleInitialCondition(graph, contextResource, bookResource)) != null) {
                return ic;
            }
            ic = this.getPossibleInitialCondition(graph, bookResource, bookResource);
            if (ic != null) {
                return ic;
            }
        }
        SpreadsheetBook book = new SpreadsheetBook();
        Variable base = ProxyVariables.proxyVariableBase((ReadGraph)graph, (Variable)run);
        Resource bookResource = base.getRepresents(graph);
        Variable configuration = Variables.getVariable((ReadGraph)graph, (Resource)bookResource);
        SpreadsheetSynchronizationEventHandler handler = new SpreadsheetSynchronizationEventHandler(graph, book);
        Synchronizer synchronizer = new Synchronizer(graph);
        synchronizer.fullSynchronization(configuration, (SynchronizationEventHandler)handler);
        return book;
    }

    protected StandardRealm<SheetNode, SpreadsheetBook> createRealm(SpreadsheetBook engine, String id) {
        return new SpreadsheetRealm(engine, id);
    }

    public void removeRealm(WriteGraph graph, String id) throws DatabaseException {
        StandardRealm realm = this.getOrCreateRealm((ReadGraph)graph, id);
        SpreadsheetEvaluationEnvironment.removeInstance((SpreadsheetBook)realm.getEngine());
        super.removeRealm(graph, id);
    }

    public static void removeSpreadsheetSession(WriteGraph graph, Variable runVariable) throws DatabaseException {
        String uri = runVariable.getParent((ReadGraph)graph).getURI((ReadGraph)graph);
        SpreadsheetSessionManager.getInstance().removeRealm(graph, uri);
    }

    public class ClassLoaderObjectInputStream
    extends ObjectInputStream {
        private ClassLoader classLoader;

        public ClassLoaderObjectInputStream(ClassLoader classLoader, InputStream in) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                String name = desc.getName();
                return Class.forName(name, false, this.classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.resolveClass(desc);
            }
        }
    }
}

