/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import it.unimi.dsi.fastutil.longs.AbstractLongList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.graph.CellFormulaFunction;
import org.simantics.spreadsheet.graph.SpreadsheetBook;
import org.simantics.spreadsheet.graph.SpreadsheetCell;
import org.simantics.spreadsheet.graph.SpreadsheetEngine;
import org.simantics.spreadsheet.graph.SpreadsheetGraphUtils;
import org.simantics.spreadsheet.graph.SpreadsheetLine;
import org.simantics.spreadsheet.graph.SpreadsheetMatrix;
import org.simantics.spreadsheet.graph.formula.FormulaError2;
import org.simantics.spreadsheet.graph.formula.SpreadsheetEvaluationEnvironment;
import org.simantics.spreadsheet.graph.parser.ast.AstApply;
import org.simantics.spreadsheet.graph.parser.ast.AstArgList;
import org.simantics.spreadsheet.graph.parser.ast.AstArithmeticExpression;
import org.simantics.spreadsheet.graph.parser.ast.AstArray;
import org.simantics.spreadsheet.graph.parser.ast.AstArrayFormulaReference;
import org.simantics.spreadsheet.graph.parser.ast.AstBoolean;
import org.simantics.spreadsheet.graph.parser.ast.AstDouble;
import org.simantics.spreadsheet.graph.parser.ast.AstFactor;
import org.simantics.spreadsheet.graph.parser.ast.AstIdentifier;
import org.simantics.spreadsheet.graph.parser.ast.AstInteger;
import org.simantics.spreadsheet.graph.parser.ast.AstNothing;
import org.simantics.spreadsheet.graph.parser.ast.AstNull;
import org.simantics.spreadsheet.graph.parser.ast.AstRange;
import org.simantics.spreadsheet.graph.parser.ast.AstRelation;
import org.simantics.spreadsheet.graph.parser.ast.AstString;
import org.simantics.spreadsheet.graph.parser.ast.AstTerm;
import org.simantics.spreadsheet.graph.parser.ast.AstValue;
import org.simantics.spreadsheet.graph.parser.ast.AstValueVisitor;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class CellValueVisitor
implements AstValueVisitor<Object> {
    public final SpreadsheetBook book;
    private final SpreadsheetEvaluationEnvironment env;
    private final SpreadsheetCell thisCell;
    private final LongArrayList references = new LongArrayList();

    public CellValueVisitor(SpreadsheetEvaluationEnvironment env, SpreadsheetCell thisCell) {
        this.book = env.getBook();
        this.env = env;
        this.thisCell = thisCell;
    }

    public void addReference(long ref) {
        this.references.add(ref);
    }

    public AbstractLongList getReferences() {
        return this.references;
    }

    @Override
    public Object visit(AstBoolean astBoolean) {
        return astBoolean.value;
    }

    @Override
    public Object visit(AstDouble astFloat) {
        return astFloat.value;
    }

    @Override
    public Object visit(AstInteger astInteger) {
        return astInteger.value;
    }

    @Override
    public Object visit(AstNull astNull) {
        throw new IllegalStateException();
    }

    @Override
    public Object visit(AstString astString) {
        return astString.value;
    }

    @Override
    public Object visit(AstRange astRange) {
        if (astRange.isRef()) {
            return FormulaError2.REF.getString();
        }
        if (astRange.isCell()) {
            String ref = astRange.first;
            Range r = SpreadsheetUtils.decodeCell((String)ref, (int)0, (int)0);
            String sheetName = astRange.sheetName != null ? astRange.sheetName : this.thisCell.getEngine().getName();
            SpreadsheetCell cell = this.thisCell.getBook().get(sheetName, r.startRow, r.startColumn);
            if (cell == null) {
                SpreadsheetEngine eng = this.thisCell.getBook().getEngine(sheetName);
                SpreadsheetLine line = eng.getLine(r.startRow);
                if (line == null) {
                    line = new SpreadsheetLine(eng.lines, r.startRow);
                    eng.lines.lines.put(-r.startRow, (Object)line);
                }
                cell = SpreadsheetCell.empty(line, r.startColumn);
            }
            return cell.evaluate(this.env, this);
        }
        Object cached = this.thisCell.getEngine().getCachedRange(astRange);
        if (cached != null) {
            Range r_ = SpreadsheetUtils.decodeRange((String)(String.valueOf(astRange.first) + ":" + astRange.second));
            String sheetName = astRange.sheetName != null ? astRange.sheetName : this.thisCell.getEngine().getName();
            SpreadsheetEngine eng = this.thisCell.getBook().getEngine(sheetName);
            Range r = eng.actualRange(r_);
            int row = 0;
            while (row < r.height()) {
                SpreadsheetLine line = eng.getLine(r.startRow + row);
                if (line != null) {
                    int column = 0;
                    while (column < r.width()) {
                        int col = r.startColumn + column;
                        if (line.cells.size() > col) {
                            SpreadsheetCell cell = (SpreadsheetCell)line.cells.get(r.startColumn + column);
                            this.addReference(cell.makeReferenceKey());
                        }
                        ++column;
                    }
                }
                ++row;
            }
            return cached;
        }
        Range r_ = SpreadsheetUtils.decodeRange((String)(String.valueOf(astRange.first) + ":" + astRange.second));
        String sheetName = astRange.sheetName != null ? astRange.sheetName : this.thisCell.getEngine().getName();
        SpreadsheetEngine eng = this.thisCell.getBook().getEngine(sheetName);
        Range r = eng.actualRange(r_);
        SpreadsheetMatrix result = new SpreadsheetMatrix(r.width(), r.height());
        int row = 0;
        while (row < r.height()) {
            SpreadsheetLine line = eng.getLine(r.startRow + row);
            if (line != null) {
                int column = 0;
                while (column < r.width()) {
                    int col = r.startColumn + column;
                    if (line.cells.size() > col) {
                        SpreadsheetCell cell = (SpreadsheetCell)line.cells.get(r.startColumn + column);
                        result.values[r.width() * row + column] = cell.evaluate(this.env, this);
                    }
                    ++column;
                }
            }
            ++row;
        }
        this.thisCell.getEngine().cacheRange(astRange, result);
        return result;
    }

    @Override
    public Object visit(AstArgList astArgList) {
        throw new IllegalStateException();
    }

    @Override
    public Object visit(AstApply astApply) {
        CellFormulaFunction<?> fn = this.env.getFunction(astApply.value);
        if (fn != null) {
            return fn.evaluate(this, astApply.args);
        }
        return FormulaError2.NAME.getString();
    }

    @Override
    public Object visit(AstRelation astRelation) {
        Object leftResult = astRelation.left.accept(this);
        Object rightResult = astRelation.right.accept(this);
        FormulaError2 err = FormulaError2.forObject(leftResult);
        if (err != null) {
            return err.getString();
        }
        FormulaError2 err2 = FormulaError2.forObject(rightResult);
        if (err2 != null) {
            return err2.getString();
        }
        if (leftResult instanceof Variant) {
            Object leftTemp = ((Variant)leftResult).getValue();
            Double leftVal = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(leftTemp);
            leftResult = leftVal == null ? leftTemp.toString() : leftVal;
        }
        if (rightResult instanceof Variant) {
            Object rightTemp = ((Variant)rightResult).getValue();
            Double rightVal = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(rightTemp);
            rightResult = rightVal == null ? rightTemp.toString() : rightVal;
        }
        if (leftResult instanceof String && rightResult instanceof String) {
            String leftString = leftResult.toString().toLowerCase();
            String rightString = rightResult.toString().toLowerCase();
            if ("<".equals(astRelation.op.trim())) {
                if (leftString.compareTo(rightString) < 0) {
                    return true;
                }
                return false;
            }
            if (">".equals(astRelation.op.trim())) {
                if (leftString.compareTo(rightString) > 0) {
                    return true;
                }
                return false;
            }
            if ("=".equals(astRelation.op.trim())) {
                if (leftString.compareTo(rightString) == 0) {
                    return true;
                }
                return false;
            }
            if ("<>".equals(astRelation.op.trim())) {
                if (leftString.compareTo(rightString) != 0) {
                    return true;
                }
                return false;
            }
            if ("<=".equals(astRelation.op.trim())) {
                if (leftString.compareTo(rightString) <= 0) {
                    return true;
                }
                return false;
            }
            if (">=".equals(astRelation.op.trim())) {
                if (leftString.compareTo(rightString) >= 0) {
                    return true;
                }
                return false;
            }
            throw new IllegalStateException();
        }
        Double leftNumber = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(leftResult);
        Double rightNumber = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(rightResult);
        if (leftNumber == null || rightNumber == null) {
            return false;
        }
        if ("<".equals(astRelation.op.trim())) {
            if (leftNumber < rightNumber) {
                return true;
            }
            return false;
        }
        if (">".equals(astRelation.op.trim())) {
            if (leftNumber > rightNumber) {
                return true;
            }
            return false;
        }
        if ("=".equals(astRelation.op.trim())) {
            if (((Number)leftNumber).doubleValue() == ((Number)rightNumber).doubleValue()) {
                return true;
            }
            return false;
        }
        if ("<>".equals(astRelation.op.trim())) {
            if (((Number)leftNumber).doubleValue() != ((Number)rightNumber).doubleValue()) {
                return true;
            }
            return false;
        }
        if ("<=".equals(astRelation.op.trim())) {
            if (leftNumber <= rightNumber) {
                return true;
            }
            return false;
        }
        if (">=".equals(astRelation.op.trim())) {
            if (leftNumber >= rightNumber) {
                return true;
            }
            return false;
        }
        throw new IllegalStateException();
    }

    Object leftValueWithPrefix(Object result, AstValue value, String prefix, boolean forceNumber) {
        if (result == null) {
            Object obj = value.accept(this);
            FormulaError2 err = FormulaError2.forObject(obj);
            if (err != null) {
                return err.getString();
            }
            if ("-".equals(prefix)) {
                result = SpreadsheetGraphUtils.asNumber(obj);
                return -((Number)result).doubleValue();
            }
            if (forceNumber) {
                return SpreadsheetGraphUtils.asNumber(obj);
            }
            return obj;
        }
        try {
            return Double.parseDouble(result.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return result;
        }
    }

    @Override
    public Object visit(AstArithmeticExpression exp) {
        Object result = null;
        Object other = null;
        AstValue value = null;
        Object acceptedValue = null;
        int i = 0;
        while (i < exp.rightCount()) {
            FormulaError2 err2;
            Double resNum;
            Object val;
            FormulaError2 err;
            String op = exp.rightOp(i);
            value = exp.rightValue(i);
            acceptedValue = value.accept(this);
            if ("+".equals(op)) {
                if (!((result = this.leftValueWithPrefix(result, exp.left, exp.prefix, false)) instanceof Number)) {
                    err = FormulaError2.forObject(result);
                    if (err != null) {
                        return err.getString();
                    }
                    if (result instanceof String && !((String)result).isEmpty()) {
                        return FormulaError2.VALUE.getString();
                    }
                    if (result instanceof Variant) {
                        val = ((Variant)result).getValue();
                        if (val instanceof String && val.toString().isEmpty()) {
                            result = 0.0;
                        } else {
                            resNum = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(val);
                            if (resNum == null) {
                                return FormulaError2.VALUE.getString();
                            }
                            result = resNum;
                        }
                    } else {
                        result = 0.0;
                    }
                }
                if ((err2 = FormulaError2.forObject(acceptedValue)) != null) {
                    return err2.getString();
                }
                other = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(acceptedValue);
                if (other == null) {
                    return FormulaError2.handleErrorCall(acceptedValue);
                }
                result = ((Number)result).doubleValue() + ((Number)other).doubleValue();
            } else if ("-".equals(op)) {
                if (!((result = this.leftValueWithPrefix(result, exp.left, exp.prefix, false)) instanceof Number)) {
                    err = FormulaError2.forObject(result);
                    if (err != null) {
                        return err.getString();
                    }
                    if (result instanceof String && !((String)result).isEmpty()) {
                        return FormulaError2.VALUE.getString();
                    }
                    if (result instanceof Variant) {
                        val = ((Variant)result).getValue();
                        if (val instanceof String && val.toString().isEmpty()) {
                            result = 0.0;
                        } else {
                            resNum = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(val);
                            if (resNum == null) {
                                return FormulaError2.VALUE.getString();
                            }
                            result = resNum;
                        }
                    } else {
                        result = 0.0;
                    }
                }
                if ((err2 = FormulaError2.forObject(acceptedValue)) != null) {
                    return err2.getString();
                }
                other = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(acceptedValue);
                if (other == null) {
                    return FormulaError2.handleErrorCall(acceptedValue);
                }
                result = ((Number)result).doubleValue() - ((Number)other).doubleValue();
            } else if ("&".equals(op)) {
                err = FormulaError2.forObject(result = this.leftValueWithPrefix(result, exp.left, exp.prefix, false));
                if (err != null) {
                    return err.getString();
                }
                FormulaError2 err22 = FormulaError2.forObject(acceptedValue);
                if (err22 != null) {
                    return err22.getString();
                }
                result = SpreadsheetGraphUtils.asString(result);
                other = SpreadsheetGraphUtils.asString(acceptedValue);
                result = String.valueOf(result) + (String)other;
            }
            ++i;
        }
        return this.leftValueWithPrefix(result, exp.left, exp.prefix, false);
    }

    @Override
    public Object visit(AstTerm exp) {
        Double result = null;
        int i = 0;
        while (i < exp.rightCount()) {
            Double other;
            String op = exp.rightOp(i);
            AstValue value = exp.rightValue(i);
            Object leftValue = exp.left.accept(this);
            Object rightValue = value.accept(this);
            if ("*".equals(op)) {
                if (result == null && (result = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(leftValue)) == null) {
                    return FormulaError2.handleErrorCall(leftValue);
                }
                other = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(rightValue);
                if (other == null) {
                    return FormulaError2.handleErrorCall(rightValue);
                }
                result = new Double(result * other);
            } else if ("/".equals(op)) {
                if (result == null && (result = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(leftValue)) == null) {
                    return FormulaError2.handleErrorCall(leftValue);
                }
                other = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(rightValue);
                if (other == null) {
                    return FormulaError2.handleErrorCall(rightValue);
                }
                if (other == 0.0) {
                    return FormulaError2.DIV0.getString();
                }
                result = new Double(result / other);
            }
            ++i;
        }
        if (result == null) {
            result = SpreadsheetGraphUtils.asNumber(exp.left.accept(this));
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object visit(AstFactor exp) {
        Object result = null;
        int i = 0;
        while (i < exp.rightCount()) {
            String op = exp.rightOp(i);
            AstValue value = exp.rightValue(i);
            if ("^".equals(op)) {
                Object otherValue;
                FormulaError2 err2;
                if (result == null) {
                    Object leftValue = exp.left.accept(this);
                    FormulaError2 err = FormulaError2.forObject(leftValue);
                    if (err != null) {
                        return err.getString();
                    }
                    if (leftValue instanceof Variant) {
                        Object leftTemp = ((Variant)leftValue).getValue();
                        Double leftV = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(leftTemp);
                        leftValue = leftV == null ? leftTemp.toString() : leftV;
                    }
                    if (leftValue instanceof String) {
                        if (!leftValue.toString().isEmpty()) return FormulaError2.VALUE.getString();
                        result = 0;
                    } else {
                        result = leftValue instanceof SpreadsheetMatrix ? leftValue : Double.valueOf(SpreadsheetGraphUtils.asNumber(leftValue));
                    }
                }
                if ((err2 = FormulaError2.forObject(otherValue = value.accept(this))) != null) {
                    return err2.getString();
                }
                if (otherValue instanceof Variant) {
                    Object otherTemp = ((Variant)otherValue).getValue();
                    Double otherV = SpreadsheetGraphUtils.asDoubleWhereEmptyStringIsZero(otherTemp);
                    otherValue = otherV == null ? otherTemp.toString() : otherV;
                }
                if (otherValue instanceof String) {
                    if (!otherValue.toString().isEmpty()) return FormulaError2.VALUE.getString();
                    otherValue = 0;
                }
                if (result instanceof SpreadsheetMatrix) {
                    result = ((SpreadsheetMatrix)result).pow(otherValue);
                } else {
                    if (otherValue instanceof SpreadsheetMatrix) {
                        throw new IllegalStateException();
                    }
                    Double base = ((Number)result).doubleValue();
                    Double exponent = SpreadsheetGraphUtils.asNumber(otherValue);
                    if (exponent == 0.0 && base == 0.0) {
                        return FormulaError2.NUM.getString();
                    }
                    if (exponent < 0.0 && base == 0.0) {
                        return FormulaError2.DIV0.getString();
                    }
                    result = Math.pow(base, exponent);
                    if (result instanceof Double && Double.isInfinite((Double)result)) {
                        return FormulaError2.NUM.getString();
                    }
                }
            }
            ++i;
        }
        if (result != null) return result;
        return SpreadsheetGraphUtils.asNumber(exp.left.accept(this));
    }

    @Override
    public Object visit(AstIdentifier id) {
        return FormulaError2.NAME.getString();
    }

    @Override
    public Object visit(AstArray array) {
        SpreadsheetMatrix m = new SpreadsheetMatrix(array.values.size(), 1);
        int i = 0;
        while (i < array.values.size()) {
            m.values[i] = array.values.get(i).accept(this);
            ++i;
        }
        return m;
    }

    @Override
    public Object visit(AstNothing array) {
        return AstNothing.NOTHING;
    }

    @Override
    public Object visit(AstArrayFormulaReference ref) {
        Range thisRange = SpreadsheetUtils.decodeRange((String)this.thisCell.getName());
        Range arrayRange = SpreadsheetUtils.decodeRange((String)ref.range);
        int x = thisRange.startColumn - arrayRange.startColumn;
        int y = thisRange.startRow - arrayRange.startRow;
        SpreadsheetMatrix m = (SpreadsheetMatrix)ref.value.accept(this);
        return m.get(y, x);
    }
}

