/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.utils.datastructures.ArrayMap;

public final class NodeContextBuilder {
    private static Set<NodeContext.ConstantKey<?>> SINGLE_INPUT_KEYS = Collections.singleton(BuiltinKeys.INPUT);
    MapNodeContext context = new MapNodeContext();

    public <T> NodeContextBuilder define(NodeContext.ConstantKey<T> key, T value) {
        if (this.context.data == null) {
            this.context.data = new HashMap();
        }
        this.context.data.put(key, value);
        return this;
    }

    public NodeContext createContext() {
        this.context.makeHash();
        return this.context;
    }

    public static <T> NodeContext buildWithSingleData(NodeContext.ConstantKey<T> key, T value) {
        MapNodeContext context = new MapNodeContext();
        context.data = Collections.singletonMap(key, value);
        context.makeHash();
        return context;
    }

    public static <T> NodeContext buildWithData(Object ... keyValuePairs) {
        assert (keyValuePairs.length % 2 == 0);
        MapNodeContext context = new MapNodeContext();
        int size = keyValuePairs.length;
        HashMap<NodeContext.ConstantKey, Object> map = new HashMap<NodeContext.ConstantKey, Object>(size);
        int i = 0;
        while (i < keyValuePairs.length) {
            map.put((NodeContext.ConstantKey)keyValuePairs[i], keyValuePairs[i + 1]);
            i += 2;
        }
        context.data = map;
        context.makeHash();
        return context;
    }

    public static <T> NodeContext buildWithData(NodeContext.ConstantKey<?>[] keys, Object[] values) {
        assert (keys.length == values.length);
        MapNodeContext context = new MapNodeContext();
        ArrayMap map = new ArrayMap((Object[])keys, values);
        context.data = (Map)map;
        context.makeHash();
        return context;
    }

    public static NodeContext buildWithInput(Object input) {
        return new InputNodeContext(input);
    }

    private static class InputNodeContext
    implements NodeContext {
        final Object input;

        private InputNodeContext(Object input) {
            this.input = input;
        }

        public Object getAdapter(Class adapter) {
            if (NodeContext.class.equals((Object)adapter)) {
                return this;
            }
            if (this.input != null) {
                if (adapter.isAssignableFrom(this.input.getClass())) {
                    return this.input;
                }
                if (this.input instanceof IAdaptable) {
                    return ((IAdaptable)this.input).getAdapter(adapter);
                }
            }
            return null;
        }

        public <T> T getConstant(NodeContext.ConstantKey<T> key) {
            return (T)(key == BuiltinKeys.INPUT ? this.input : null);
        }

        public Set<NodeContext.ConstantKey<?>> getKeys() {
            return SINGLE_INPUT_KEYS;
        }

        public int hashCode() {
            return this.input == null ? 0 : this.input.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InputNodeContext other = (InputNodeContext)obj;
            return !(this.input == null ? other.input != null : !this.input.equals(other.input));
        }

        public String toString() {
            return "InputNodeContext(" + this.hashCode() + ") [" + this.input + "]";
        }
    }

    public static class MapNodeContext
    implements NodeContext {
        private Map<NodeContext.ConstantKey<?>, Object> data;
        private int hash;

        private MapNodeContext() {
        }

        void makeHash() {
            this.hash = this.data == null ? 0 : this.data.hashCode();
        }

        public Object getAdapter(Class adapter) {
            if (NodeContext.class.equals((Object)adapter)) {
                return this;
            }
            Object input = this.data.get(BuiltinKeys.INPUT);
            if (input != null) {
                if (adapter.isAssignableFrom(input.getClass())) {
                    return input;
                }
                if (input instanceof IAdaptable) {
                    return ((IAdaptable)input).getAdapter(adapter);
                }
            }
            return null;
        }

        public <T> T getConstant(NodeContext.ConstantKey<T> key) {
            return (T)(this.data != null ? this.data.get(key) : null);
        }

        public Set<NodeContext.ConstantKey<?>> getKeys() {
            return this.data.keySet();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MapNodeContext other = (MapNodeContext)obj;
            return !(this.data == null ? other.data != null : !this.data.equals(other.data));
        }

        public String toString() {
            return "MapNodeContext(" + this.hashCode() + ") [" + (this.data != null ? this.data : "") + "]";
        }
    }
}

