/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Supplier;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.adapter.DefaultConnectionClassFactory;
import org.simantics.diagram.adapter.FlagClassFactory;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.adapter.IDiagramLoader;
import org.simantics.diagram.handler.ConnectionCommandHandler;
import org.simantics.diagram.handler.CopyPasteHandler;
import org.simantics.diagram.handler.DeleteHandler;
import org.simantics.diagram.handler.ExpandSelectionHandler;
import org.simantics.diagram.handler.SimpleElementTransformHandler;
import org.simantics.diagram.layer.ILayersViewPage;
import org.simantics.diagram.participant.ContextUtil;
import org.simantics.diagram.participant.SGFocusParticipant;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.ui.SWTPopupMenuParticipant;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.chassis.SWTChassis;
import org.simantics.g2d.diagram.DiagramClass;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.impl.Diagram;
import org.simantics.g2d.diagram.participant.DiagramParticipant;
import org.simantics.g2d.diagram.participant.ElementInteractor;
import org.simantics.g2d.diagram.participant.ElementPainter;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.TerminalPainter;
import org.simantics.g2d.diagram.participant.ZOrderHandler;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.element.ElementClassProviders;
import org.simantics.g2d.element.ElementClasses;
import org.simantics.g2d.element.IElementClassProvider;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.participant.CanvasBoundsParticipant;
import org.simantics.g2d.participant.CanvasGrab;
import org.simantics.g2d.participant.KeyUtil;
import org.simantics.g2d.participant.MouseUtil;
import org.simantics.g2d.participant.MultitouchPanZoomRotateInteractor;
import org.simantics.g2d.participant.Notifications;
import org.simantics.g2d.participant.PageBorderParticipant;
import org.simantics.g2d.participant.PanZoomRotateHandler;
import org.simantics.g2d.participant.PointerPainter;
import org.simantics.g2d.participant.RulerPainter;
import org.simantics.g2d.participant.SymbolUtil;
import org.simantics.g2d.participant.TimeParticipant;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.participant.ZoomToAreaHandler;
import org.simantics.layer0.utils.triggers.IActivation;
import org.simantics.layer0.utils.triggers.IActivationManager;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.mapping.ModelingSynchronizationHints;
import org.simantics.modeling.ui.diagramEditor.DiagramLayersPage;
import org.simantics.modeling.ui.diagramEditor.DiagramOutlinePage;
import org.simantics.modeling.ui.diagramEditor.PopulateElementDropParticipant;
import org.simantics.modeling.ui.diagramEditor.PopulateElementMonitorDropParticipant;
import org.simantics.modeling.ui.diagramEditor.handlers.WorkbenchStructuralSelectionProvider;
import org.simantics.modeling.ui.preferences.DiagramPreferenceUtil;
import org.simantics.modeling.ui.preferences.DiagramPreferences;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.snap.GridSnapAdvisor;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.selectionview.StandardPropertyPage;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.workbench.IPropertyPage;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.IResourceEditorInput2;
import org.simantics.ui.workbench.IResourceEditorPart2;
import org.simantics.ui.workbench.ResourceEditorSupport;
import org.simantics.ui.workbench.TitleRequest;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.ui.workbench.ToolTipRequest;
import org.simantics.utils.DataContainer;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.ErrorLogger;

public class SheetViewer
extends EditorPart
implements IResourceEditorPart2 {
    private static final boolean PROFILE = false;
    protected boolean disposed = false;
    protected IThreadWorkQueue swt;
    protected IStatusLineManager statusLineManager;
    protected SWTChassis c;
    protected IDiagram sourceDiagram;
    protected ICanvasContext canvasContext;
    protected ResourceEditorSupport support;
    protected ISessionContextProvider sessionContextProvider;
    protected ISessionContext sessionContext;
    protected Resource diagramResource;
    protected GraphToDiagramSynchronizer synchronizer;
    protected IActivation activation;
    protected ContextUtil contextUtil;
    protected DiagramPreferences diagramPreferences;
    protected GridSnapAdvisor snapAdvisor;
    public ResourceArray structuralPath;
    IEclipsePreferences.IPreferenceChangeListener preferenceListener = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            String value = (String)event.getNewValue();
            if ("grid.size".equals(event.getKey())) {
                double grid = DiagramPreferences.DEFAULT_SNAP_GRID_SIZE;
                if (value != null) {
                    grid = Double.parseDouble(value);
                }
                SheetViewer.this.snapAdvisor.setResolution(grid);
            } else if ("page.default.size".equals(event.getKey())) {
                PageDesc pageDesc = PageDesc.deserialize((String)value, (PageDesc)DiagramPreferences.DEFAULT_PAGE_SIZE);
                SheetViewer.this.canvasContext.getDefaultHintContext().setHint(Hints.KEY_PAGE_DESC, (Object)pageDesc);
            } else if ("page.display.size".equals(event.getKey())) {
                Boolean display = value != null ? Boolean.parseBoolean(value) : DiagramPreferences.DEFAULT_DISPLAY_PAGE_SIZE;
                SheetViewer.this.canvasContext.getDefaultHintContext().setHint(Hints.KEY_DISPLAY_PAGE, (Object)display);
            } else if ("page.display.margins".equals(event.getKey())) {
                Boolean display = value != null ? Boolean.parseBoolean(value) : DiagramPreferences.DEFAULT_DISPLAY_MARGINS;
                SheetViewer.this.canvasContext.getDefaultHintContext().setHint(Hints.KEY_DISPLAY_MARGINS, (Object)display);
            }
        }
    };
    private boolean firstFocus = true;

    protected void addDropParticipants(ICanvasContext ctx) {
        ctx.add((Object)new PopulateElementDropParticipant(this.synchronizer));
        ctx.add((Object)new PopulateElementMonitorDropParticipant(this.synchronizer, 0.5, 0.5));
    }

    protected void addKeyBindingParticipants(CanvasContext ctx) {
        ctx.add((Object)new DeleteHandler(this.statusLineManager));
        ctx.add((Object)new CopyPasteHandler(this.statusLineManager));
        ctx.add((Object)new ConnectionCommandHandler());
    }

    protected void addPopupmenu(ICanvasContext ctx) {
        ctx.add((Object)new SWTPopupMenuParticipant(this.getSite(), (Control)this.c, this.getPopupId()));
    }

    protected void addStructureParticipants(ICanvasContext ctx) {
        this.structuralPath = this.getResourceInput().getResourceArray().removeFromBeginning(1);
        ctx.add((Object)new WorkbenchStructuralSelectionProvider(this.swt, this.getSite(), this.structuralPath));
    }

    protected String getPopupId() {
        return "#ModelingDiagramPopup";
    }

    protected void getPreferences() {
        this.diagramPreferences = DiagramPreferenceUtil.getPreferences();
    }

    protected void initSession() {
        this.sessionContextProvider = SimanticsUI.getSessionContextProvider();
        this.sessionContext = this.sessionContextProvider.getSessionContext();
    }

    protected void readNames() {
        String name = this.getEditorInput().getName();
        this.setPartName(name);
        this.setTitleToolTip(name);
    }

    protected void createChassis(Composite parent) {
        this.c = new SWTChassis(parent, 0);
        this.c.syncPopulate();
    }

    protected void setCanvasContext(ICanvasContext context) {
        this.c.setCanvasContext(this.canvasContext);
    }

    public void createPartControl(Composite parent) {
        this.swt = SWTThread.getThreadAccess((Display)parent.getDisplay());
        this.statusLineManager = this.getEditorSite().getActionBars().getStatusLineManager();
        Object task = SheetViewer.BEGIN("DV.initSession");
        this.initSession();
        SheetViewer.END(task);
        this.diagramResource = this.getInputResource();
        this.readNames();
        this.getPreferences();
        task = SheetViewer.BEGIN("DV.createChassis");
        this.createChassis(parent);
        SheetViewer.END(task);
        this.initializeCanvas();
        this.diagramPreferences.preferences.addPreferenceChangeListener(this.preferenceListener);
    }

    protected void initializeCanvas() {
        Object canvasInit = SheetViewer.BEGIN("DV.canvasInitialization");
        Object task = SheetViewer.BEGIN("DV.createViewerCanvas");
        this.canvasContext = this.createViewerCanvas();
        SheetViewer.END(task);
        task = SheetViewer.BEGIN("DV.setCanvasContext");
        this.setCanvasContext(this.canvasContext);
        SheetViewer.END(task);
        try {
            task = SheetViewer.BEGIN("DV.loadDiagram");
            this.sourceDiagram = this.loadDiagram(this.diagramResource);
            SheetViewer.END(task);
            task = SheetViewer.BEGIN("DV.scheduleZoomToFit");
            this.scheduleZoomToFit();
            SheetViewer.END(task);
            task = SheetViewer.BEGIN("DV.performActivation");
            this.performActivation();
            SheetViewer.END(task);
            task = SheetViewer.BEGIN("DV.activate context");
            this.contextUtil.activate("org.simantics.modeling.ui.diagramming");
            SheetViewer.END(task);
            task = SheetViewer.BEGIN("DV.onCreated");
            this.onCreated();
            SheetViewer.END(task);
        }
        catch (DatabaseException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            this.canvasContext.getDefaultHintContext().setHint(DiagramHints.KEY_DIAGRAM, (Object)Diagram.spawnNew((DiagramClass)DiagramClass.DEFAULT));
        }
        SheetViewer.END(canvasInit);
    }

    protected void performActivation() {
        IActivationManager activationManager = (IActivationManager)this.sessionContext.getSession().peekService(IActivationManager.class);
        if (activationManager != null) {
            this.activation = activationManager.activate(this.diagramResource);
        }
    }

    protected void scheduleZoomToFit() {
        if (this.sourceDiagram == null) {
            throw new IllegalStateException("source diagram is null");
        }
        this.sourceDiagram.setHint(Hints.KEY_DISABLE_PAINTING, (Object)Boolean.TRUE);
        this.sourceDiagram.setHint(DiagramHints.KEY_INITIAL_ZOOM_TO_FIT, (Object)Boolean.TRUE);
        ThreadUtils.asyncExec((IThreadWorkQueue)this.swt, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (SheetViewer.this.disposed) {
                    return;
                }
                ThreadUtils.asyncExec((IThreadWorkQueue)SheetViewer.this.canvasContext.getThreadAccess(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if ((this).SheetViewer.this.disposed) {
                            return;
                        }
                        (this).SheetViewer.this.sourceDiagram.removeHint(Hints.KEY_DISABLE_PAINTING);
                        (this).SheetViewer.this.sourceDiagram.removeHint(DiagramHints.KEY_INITIAL_ZOOM_TO_FIT);
                        (this).SheetViewer.this.canvasContext.getDefaultHintContext().removeHint(Hints.KEY_DISABLE_PAINTING);
                        (this).SheetViewer.this.canvasContext.getContentContext().setDirty();
                    }
                });
            }
        });
    }

    protected IDiagram loadDiagram(final Resource r) throws DatabaseException {
        final DataContainer dc = new DataContainer();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Loading Diagram", (int)100);
                    try {
                        try {
                            dc.set((Object)SheetViewer.this.loadDiagram((IProgressMonitor)mon.newChild(100), r));
                        }
                        catch (DatabaseException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException(t);
        }
        catch (InterruptedException e) {
            throw new DatabaseException((Throwable)e);
        }
        return (IDiagram)dc.get();
    }

    protected IDiagram loadDiagram(IProgressMonitor monitor, Resource r) throws DatabaseException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)"Loading Diagram", (int)100);
        Object task = SheetViewer.BEGIN("DV.DiagramLoadQuery");
        IDiagram d = (IDiagram)this.sessionContext.getSession().syncRequest(DiagramRequests.loadDiagram((IProgressMonitor)mon.newChild(100), (Resource)this.getResourceInput2().getModel(null), (Resource)r, null, (ResourceArray)this.structuralPath, (IDiagramLoader)this.synchronizer, null));
        SheetViewer.END(task);
        task = SheetViewer.BEGIN("DV.setDiagramHint");
        this.canvasContext.getDefaultHintContext().setHint(DiagramHints.KEY_DIAGRAM, (Object)d);
        SheetViewer.END(task);
        task = SheetViewer.BEGIN("DV.set other hints");
        d.setHint(DiagramHints.KEY_USE_CONNECTION_FLAGS, (Object)Boolean.FALSE);
        d.setHint(DiagramHints.KEY_ALLOW_CONNECTION_BRANCHING, (Object)Boolean.FALSE);
        d.setHint(DiagramHints.KEY_ALLOW_ROUTE_POINTS, (Object)Boolean.FALSE);
        SheetViewer.END(task);
        return d;
    }

    protected GraphToDiagramSynchronizer createSynchronizer(final ICanvasContext ctx, ISessionContext sessionContext) {
        try {
            return (GraphToDiagramSynchronizer)sessionContext.getSession().syncRequest((Read)new Read<GraphToDiagramSynchronizer>(){

                public GraphToDiagramSynchronizer perform(ReadGraph graph) throws DatabaseException {
                    GraphToDiagramSynchronizer sync = new GraphToDiagramSynchronizer((RequestProcessor)graph, ctx, SheetViewer.this.createElementClassProvider(graph));
                    SheetViewer.this.initializeSynchronizationContext(graph, (IModifiableSynchronizationContext)sync);
                    return sync;
                }
            });
        }
        catch (DatabaseException e) {
            throw new UnsupportedOperationException("Failed to initialize data model synchronizer", e);
        }
    }

    protected void initializeSynchronizationContext(ReadGraph graph, IModifiableSynchronizationContext context) {
        context.set(ModelingSynchronizationHints.MODELING_RESOURCE, (Object)ModelingResources.getInstance((ReadGraph)graph));
    }

    protected IElementClassProvider createElementClassProvider(ReadGraph graph) {
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        return ElementClassProviders.mappedProvider((Object[])new Object[]{ElementClasses.CONNECTION, DefaultConnectionClassFactory.CLASS.newClassWith(new ElementHandler[]{new StaticObjectAdapter((Object)dr.Connection)}), ElementClasses.FLAG, FlagClassFactory.createFlagClass((Resource)dr.Flag, (Resource)dr.Flag_Terminal)});
    }

    public ICanvasContext createViewerCanvas() {
        IThreadWorkQueue thread = AWTThread.getThreadAccess();
        CanvasContext ctx = new CanvasContext(thread);
        IHintContext h = ctx.getDefaultHintContext();
        Object task = SheetViewer.BEGIN("createSynchronizer");
        this.synchronizer = this.createSynchronizer((ICanvasContext)ctx, this.sessionContext);
        SheetViewer.END(task);
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        this.contextUtil = new ContextUtil(contextService, this.swt);
        ctx.add((Object)new PanZoomRotateHandler());
        ctx.add((Object)new TransformUtil());
        ctx.add((Object)new MouseUtil());
        ctx.add((Object)new KeyUtil());
        ctx.add((Object)this.contextUtil);
        ctx.add((Object)new CanvasGrab());
        ctx.add((Object)new SymbolUtil());
        ctx.add((Object)new TimeParticipant());
        ctx.add((Object)new CanvasBoundsParticipant());
        ctx.add((Object)new Notifications());
        ctx.add((Object)new SGFocusParticipant(this.c, "org.simantics.modeling.ui.diagramming"));
        h.setHint(PointerPainter.KEY_PAINT_POINTER, (Object)true);
        ctx.add((Object)new MultitouchPanZoomRotateInteractor());
        ctx.add((Object)new ZoomToAreaHandler());
        ctx.add((Object)new SimpleElementTransformHandler(true, true, true));
        ctx.add((Object)new ExpandSelectionHandler(this.getEditorSite().getActionBars().getStatusLineManager()));
        this.addKeyBindingParticipants(ctx);
        h.setHint(PanZoomRotateHandler.KEY_ADAPT_VIEWPORT_TO_RESIZED_CONTROL, (Object)Boolean.FALSE);
        h.setHint(Hints.KEY_DISPLAY_PAGE, this.diagramPreferences.get("page.display.size"));
        h.setHint(Hints.KEY_DISPLAY_MARGINS, this.diagramPreferences.get("page.display.margins"));
        ctx.add((Object)new PageBorderParticipant());
        h.setHint(Hints.KEY_GRID_COLOR, (Object)new Color(0.95f, 0.95f, 0.95f));
        h.setHint(Hints.KEY_BACKGROUND_COLOR, (Object)Color.WHITE);
        h.setHint(RulerPainter.KEY_RULER_BACKGROUND_COLOR, (Object)new Color(0.9f, 0.9f, 0.9f, 0.75f));
        h.setHint(RulerPainter.KEY_RULER_TEXT_COLOR, (Object)Color.BLACK);
        ctx.add((Object)new ZOrderHandler());
        ctx.add((Object)new PointerInteractor(true, true, true, false, true, false, this.synchronizer.getElementClassProvider(), null));
        ctx.add((Object)new ElementInteractor());
        ctx.add((Object)new Selection());
        ctx.add((Object)new DiagramParticipant());
        ctx.add((Object)new ElementPainter());
        ctx.add((Object)new TerminalPainter(true, true, false, true));
        this.addDropParticipants((ICanvasContext)ctx);
        h.setHint(ElementPainter.KEY_SELECTION_FRAME_COLOR, (Object)Color.MAGENTA);
        h.setHint(Hints.KEY_TOOL, (Object)Hints.POINTERTOOL);
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_IN_LIMIT, (Object)100000.0);
        h.setHint(PanZoomRotateHandler.KEY_ZOOM_OUT_LIMIT, (Object)10.0);
        Double snapResolution = (Double)this.diagramPreferences.get("grid.size");
        this.snapAdvisor = new GridSnapAdvisor(snapResolution.doubleValue());
        h.setHint(DiagramHints.SNAP_ADVISOR, (Object)this.snapAdvisor);
        this.addStructureParticipants((ICanvasContext)ctx);
        this.addPopupmenu((ICanvasContext)ctx);
        this.loadPageSettings((ICanvasContext)ctx);
        h.setHint(Hints.KEY_DISABLE_PAINTING, (Object)Boolean.TRUE);
        ctx.assertParticipantDependencies();
        return ctx;
    }

    protected void loadPageSettings(ICanvasContext ctx) {
        PageDesc pageDesc = null;
        if (this.diagramResource != null) {
            try {
                pageDesc = (PageDesc)this.sessionContext.getSession().syncRequest((Read)new Read<PageDesc>(){

                    public PageDesc perform(ReadGraph graph) throws DatabaseException {
                        return DiagramGraphUtil.getPageDesc((ReadGraph)graph, (Resource)SheetViewer.this.diagramResource, null);
                    }
                });
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
        }
        if (pageDesc == null) {
            PageDesc pd;
            pageDesc = pd = this.diagramPreferences.getCompletePageDesc();
        }
        ctx.getDefaultHintContext().setHint(Hints.KEY_PAGE_DESC, pageDesc);
    }

    public void setFocus() {
        this.c.setFocus();
        if (this.firstFocus) {
            this.firstFocus = false;
            this.firstTimeSetFocus();
        }
    }

    protected void firstTimeSetFocus() {
    }

    public void dispose() {
        this.diagramPreferences.preferences.removePreferenceChangeListener(this.preferenceListener);
        this.contextUtil.deactivateAll();
        this.disposed = true;
        if (this.activation != null) {
            this.activation.deactivate();
            this.activation = null;
        }
        this.synchronizer.dispose();
        ThreadUtils.asyncExec((IThreadWorkQueue)this.c.getCanvasContext().getThreadAccess(), (Runnable)new Runnable(){

            @Override
            public void run() {
                SheetViewer.this.c.getCanvasContext().dispose();
            }
        });
        this.sourceDiagram.dispose();
        this.support.dispose();
        super.dispose();
    }

    protected Resource getInputResource() {
        return this.getResourceInput().getResource();
    }

    public IResourceEditorInput2 getResourceInput2() {
        return (IResourceEditorInput2)this.getEditorInput();
    }

    public IResourceEditorInput getResourceInput() {
        return (IResourceEditorInput)this.getEditorInput();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IResourceEditorInput)) {
            throw new PartInitException("Invalid input: must be IResourceEditorInput");
        }
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.support = new ResourceEditorSupport((IEditorPart)this);
        this.setPartName(this.getEditorInput().getName());
        Session session = SimanticsUI.peekSession();
        if (session != null) {
            Supplier<Boolean> disposedCallback = () -> this.disposed;
            session.asyncRequest((Read)new TitleRequest(site.getId(), (IResourceEditorInput)this.getResourceInput2()), (Listener)new TitleUpdater(site.getShell().getDisplay(), arg_0 -> ((SheetViewer)this).setPartName(arg_0), disposedCallback));
            session.asyncRequest((Read)new ToolTipRequest(site.getId(), (IResourceEditorInput)this.getResourceInput2()), (Listener)new TitleUpdater(site.getShell().getDisplay(), arg_0 -> ((SheetViewer)this).setTitleToolTip(arg_0), disposedCallback));
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == IPropertyPage.class) {
            return (T)new StandardPropertyPage(this.getSite());
        }
        if (adapter == IContentOutlinePage.class) {
            return (T)((Object)new DiagramOutlinePage(this.sessionContextProvider, this.getResourceInput2()));
        }
        if (adapter == ILayersViewPage.class) {
            return (T)((Object)new DiagramLayersPage(this.sourceDiagram, this.canvasContext));
        }
        if (adapter == ICanvasContext.class) {
            return (T)this.canvasContext;
        }
        if (adapter == INode.class) {
            G2DParentNode node;
            if (this.canvasContext != null && (node = this.canvasContext.getCanvasNode()) != null) {
                return (T)NodeUtil.getRootNode((INode)node);
            }
            return null;
        }
        if (adapter == IDiagram.class) {
            return (T)this.sourceDiagram;
        }
        if (adapter == Session.class) {
            return (T)this.sessionContext.getSession();
        }
        return (T)super.getAdapter(adapter);
    }

    protected void onCreated() {
    }

    private static Object BEGIN(String name) {
        return null;
    }

    private static void END(Object task) {
    }
}

