/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.datatypes.utils;

import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.util.Bean;
import org.simantics.datatypes.DatatypeResource;
import org.simantics.datatypes.utils.BTreeContentBinding;
import org.simantics.datatypes.utils.PossibleResource;
import org.simantics.datatypes.utils.PossibleVariant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.XSupport;

public final class BTreeContentBean
extends Bean {
    public static int counter = 0;
    public boolean leaf;
    public int n;
    public PossibleVariant[] key;
    public PossibleResource[] value;
    public PossibleResource[] c;

    public static BTreeContentBean create(int t) {
        BTreeContentBean result = new BTreeContentBean();
        result.leaf = true;
        result.n = 0;
        result.key = new PossibleVariant[2 * t - 1];
        result.value = new PossibleResource[2 * t - 1];
        int i = 0;
        while (i < 2 * t - 1) {
            result.key[i] = new PossibleVariant();
            result.value[i] = new PossibleResource();
            ++i;
        }
        result.c = new PossibleResource[2 * t];
        i = 0;
        while (i < 2 * t) {
            result.c[i] = new PossibleResource();
            ++i;
        }
        return result;
    }

    public void reduceSize() {
        assert (this.n > 0);
        this.key[this.n - 1] = new PossibleVariant();
        this.value[this.n - 1] = new PossibleResource();
        this.c[this.n] = new PossibleResource();
        --this.n;
    }

    public Variant getKey(int index) {
        return this.key[index].v;
    }

    public Resource getValue(int index) {
        return this.value[index].r;
    }

    public Resource getChild(int index) {
        return this.c[index].r;
    }

    public static BTreeContentBean readPossible(ReadGraph graph, Resource r) throws DatabaseException {
        DatatypeResource DATA = DatatypeResource.getInstance((ReadGraph)graph);
        SerialisationSupport ss = (SerialisationSupport)graph.getService(SerialisationSupport.class);
        XSupport xs = (XSupport)graph.getService(XSupport.class);
        BTreeContentBinding CONTENT_BEAN_BINDING = new BTreeContentBinding(ss, xs);
        return (BTreeContentBean)((Object)graph.syncRequest((Read)new PossibleRelatedValue(r, DATA.BTreeNode_content, (Binding)CONTENT_BEAN_BINDING), (Listener)TransientCacheListener.instance()));
    }
}

