/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization.base;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import java.util.ArrayList;
import java.util.Collections;
import org.simantics.databoard.util.URIStringUtils;
import org.simantics.structural.synchronization.base.ComponentBase;
import org.simantics.structural.synchronization.base.ModuleCallback;
import org.simantics.structural.synchronization.base.Solver;
import org.simantics.structural.synchronization.protocol.SynchronizationEventHandler;
import org.slf4j.Logger;

public abstract class ReferenceResolverBase<T extends ComponentBase<T>> {
    protected SynchronizationEventHandler eventHandler;
    protected Solver solver;
    protected THashMap<T, ArrayList<PendingResolve<T>>> pendingResolves = new THashMap();

    public ReferenceResolverBase(Solver solver) {
        this.solver = solver;
    }

    public void setEventHandler(SynchronizationEventHandler eventHandler) {
        this.eventHandler = eventHandler;
    }

    public void markPending(T component) {
        this.pendingResolves.put(component, new ArrayList(2));
    }

    public void unmarkPending(T component) {
        ArrayList resolves = (ArrayList)this.pendingResolves.remove(component);
        if (resolves != null) {
            for (PendingResolve resolve : resolves) {
                this.resolveReference((ComponentBase)resolve.component, resolve.connectionPoint, resolve.moduleCallback);
            }
        }
    }

    public void resolveReference(T component, String connectionPoint, ModuleCallback moduleCallback) {
        int pos = 0;
        block5: while (true) {
            char c = connectionPoint.charAt(pos++);
            switch (c) {
                case '.': {
                    component = ((ComponentBase)component).getParent();
                    continue block5;
                }
                case '/': {
                    int endPos = pos;
                    while ((c = connectionPoint.charAt(endPos)) != '/' && c != '#') {
                        ++endPos;
                    }
                    String segment = URIStringUtils.unescape((String)connectionPoint.substring(pos, endPos));
                    pos = endPos;
                    if ((component = ((ComponentBase)component).getChild(segment)) == null) {
                        String message = "Couldn't resolve " + connectionPoint + ", because child " + segment + " does not exist.";
                        if (this.eventHandler == null) {
                            this.getLogger().warn(message);
                        } else {
                            this.eventHandler.reportProblem(message);
                        }
                        return;
                    }
                    ArrayList pendingList = (ArrayList)this.pendingResolves.get(component);
                    if (pendingList == null) continue block5;
                    pendingList.add(new PendingResolve<T>(component, connectionPoint.substring(pos), moduleCallback));
                    return;
                }
                case '#': {
                    String segment = connectionPoint.substring(pos);
                    moduleCallback.execute(this.resolveConnectionPoint(((ComponentBase)component).componentId, segment));
                    return;
                }
            }
        }
    }

    public abstract int resolveConnectionPoint(int var1, String var2);

    private static void fullPathOfComponent(StringBuilder b, ComponentBase<?> component) {
        if (component != null) {
            ReferenceResolverBase.fullPathOfComponent(b, component.parent);
            b.append("/").append(component.solverComponentName);
        }
    }

    private static String fullPathOfComponent(ComponentBase<?> component) {
        StringBuilder b = new StringBuilder();
        ReferenceResolverBase.fullPathOfComponent(b, component);
        return b.toString();
    }

    public void printPending() {
        if (!this.pendingResolves.isEmpty()) {
            final ArrayList pending = new ArrayList();
            this.pendingResolves.forEachEntry(new TObjectObjectProcedure<T, ArrayList<PendingResolve<T>>>(){

                public boolean execute(T a, ArrayList<PendingResolve<T>> b) {
                    pending.add(String.valueOf(ReferenceResolverBase.fullPathOfComponent(a)) + " " + b);
                    return true;
                }
            });
            Collections.sort(pending);
            this.getLogger().info("Still pending:");
            for (String p : pending) {
                this.getLogger().info("    " + p);
            }
        }
    }

    public void resolvePendingSelfReferences() {
    }

    public abstract Logger getLogger();

    protected static class PendingResolve<T> {
        public final T component;
        public final String connectionPoint;
        public final ModuleCallback moduleCallback;

        public PendingResolve(T component, String connectionPoint, ModuleCallback moduleCallback) {
            this.component = component;
            this.connectionPoint = connectionPoint;
            this.moduleCallback = moduleCallback;
        }

        public String toString() {
            return String.valueOf(this.connectionPoint) + "->" + this.moduleCallback;
        }
    }
}

