/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.participant;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.diagram.participant.pointertool.AbstractMode;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.diagram.participant.pointertool.TranslateMode;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.Children;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.g2d.participant.WorkbenchStatusLine;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.ui.ErrorLogger;

public class ConnectionEditingSupport
extends AbstractDiagramParticipant {
    private static final boolean DEBUG = false;
    private static final int TOOL_PRIORITY = 100;
    @DependencyReflection.Dependency
    PointerInteractor pi;
    @DependencyReflection.Dependency
    PickContext pickContext;
    @DependencyReflection.Dependency
    Selection selection;
    @DependencyReflection.Dependency
    WorkbenchStatusLine statusLine;
    private static final PickRequest.PickSorter NODES_LAST = new PickRequest.PickSorter(){

        public void sort(List<IElement> elements) {
            Collections.sort(elements, new Comparator<IElement>(){

                @Override
                public int compare(IElement e1, IElement e2) {
                    boolean is1 = PickRequest.PickFilter.FILTER_NODES.accept(e1);
                    boolean is2 = PickRequest.PickFilter.FILTER_NODES.accept(e2);
                    if (!is1 && is2) {
                        return -1;
                    }
                    if (is1 && !is2) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    };

    private boolean routePointsEnabled() {
        return Boolean.TRUE.equals(this.diagram.getHint(DiagramHints.KEY_ALLOW_ROUTE_POINTS));
    }

    @EventHandlerReflection.EventHandler(priority=100)
    public boolean handleMouse(MouseEvent e) {
        if (!this.routePointsEnabled()) {
            return false;
        }
        if (e instanceof MouseEvent.MouseButtonPressedEvent) {
            return this.handlePress((MouseEvent.MouseButtonPressedEvent)e);
        }
        return false;
    }

    private boolean handlePress(MouseEvent.MouseButtonPressedEvent me) {
        if (me.button != 1 || me.hasAnyModifier(8896)) {
            return false;
        }
        Shape shape = this.pi.getCanvasPickShape(me.controlPosition);
        if (shape == null) {
            return false;
        }
        PickRequest req = new PickRequest(shape);
        req.pickPolicy = PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
        req.pickFilter = null;
        req.pickSorter = NODES_LAST;
        ArrayList<IElement> pick = new ArrayList<IElement>();
        this.pickContext.pick(this.diagram, req, pick);
        if (pick.isEmpty()) {
            return false;
        }
        Set sel = this.selection.getSelection(me.mouseId);
        if (!Collections.disjoint(pick, sel)) {
            IElement edge;
            IElement e;
            if (sel.size() == 1 && (PickRequest.PickFilter.FILTER_CONNECTIONS.accept(e = (IElement)sel.iterator().next()) || PickRequest.PickFilter.FILTER_CONNECTION_EDGES.accept(e)) && (edge = this.findSingleConnectionEdge(pick, e)) != null) {
                this.getContext().add((Object)new ConnectionRoutingMode(me.mouseId, edge));
                return true;
            }
            return false;
        }
        IElement edge = this.findSingleConnectionEdge(pick, null);
        if (edge != null) {
            this.getContext().add((Object)new ConnectionRoutingMode(me.mouseId, edge));
            return true;
        }
        return false;
    }

    private IElement findSingleConnectionEdge(List<IElement> pick, IElement selected) {
        boolean pickedSelected;
        IElement p;
        int i = pick.size() - 1;
        while (i >= 0) {
            p = pick.get(i);
            boolean bl = selected == null ? true : (pickedSelected = p == selected);
            if (PickRequest.PickFilter.FILTER_NODES.accept(p)) {
                return null;
            }
            if (pickedSelected && PickRequest.PickFilter.FILTER_CONNECTION_EDGES.accept(p)) {
                return p;
            }
            --i;
        }
        i = pick.size() - 1;
        while (i >= 0) {
            p = pick.get(i);
            boolean bl = selected == null ? true : (pickedSelected = p == selected);
            if (PickRequest.PickFilter.FILTER_CONNECTIONS.accept(p)) {
                Children ch = (Children)p.getElementClass().getAtMostOneItemOfClass(Children.class);
                if (ch == null) {
                    return null;
                }
                Collection children = ch.getChildren(p, null);
                int childCount = children.size();
                if (childCount == 1) {
                    for (IElement child : children) {
                        if (!pickedSelected || !PickRequest.PickFilter.FILTER_CONNECTION_EDGES.accept(child)) continue;
                        return child;
                    }
                } else if (childCount > 1) {
                    for (IElement child : children) {
                        if (!pickedSelected || !PickRequest.PickFilter.FILTER_CONNECTION_EDGES.accept(child) || !pick.contains(child)) continue;
                        return child;
                    }
                }
            }
            --i;
        }
        return null;
    }

    static class ConnectionRoutingMode
    extends AbstractMode {
        @DependencyReflection.Dependency
        TransformUtil tr;
        @DependencyReflection.Dependency
        Selection sel;
        private boolean dragging;
        private final IElement edge;
        private final AtomicReference<DragData> dragData = new AtomicReference();
        IHintListener diagramHintListener = new HintListenerAdapter(){

            public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                DragData data;
                if (this.isRemoved()) {
                    return;
                }
                if (key == DiagramModelHints.KEY_DIAGRAM_CONTENTS_UPDATED && (data = (DragData)dragData.getAndSet(null)) != null) {
                    this.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (this.isRemoved()) {
                                return;
                            }
                            this.setDiagramSelectionToData(data);
                        }
                    });
                }
            }

            private void setDiagramSelectionToData(DragData data) {
                DataElementMap dem = (DataElementMap)diagram.getDiagramClass().getAtMostOneItemOfClass(DataElementMap.class);
                if (dem != null) {
                    ArrayList<IElement> newSelection = new ArrayList<IElement>(data.data.size());
                    for (Object datum : data.data) {
                        IElement element = dem.getElement(diagram, datum);
                        if (element == null) continue;
                        newSelection.add(element);
                    }
                    if (!newSelection.isEmpty()) {
                        sel.setSelection(0, newSelection);
                        this.getContext().add((Object)new TranslateMode(data.startingPoint, data.currentPoint, this.getMouseId(), newSelection));
                        this.remove();
                    }
                }
            }
        };

        public ConnectionRoutingMode(int mouseId, IElement edge) {
            super(mouseId);
            this.edge = edge;
        }

        public void addedToContext(ICanvasContext ctx) {
            super.addedToContext(ctx);
        }

        public void removedFromContext(ICanvasContext ctx) {
            super.removedFromContext(ctx);
        }

        protected void onDiagramSet(IDiagram newDiagram, IDiagram oldDiagram) {
            if (oldDiagram != null) {
                oldDiagram.removeKeyHintListener(DiagramModelHints.KEY_DIAGRAM_CONTENTS_UPDATED, this.diagramHintListener);
            }
            if (newDiagram != null) {
                newDiagram.addKeyHintListener(DiagramModelHints.KEY_DIAGRAM_CONTENTS_UPDATED, this.diagramHintListener);
            }
        }

        @EventHandlerReflection.EventHandler(priority=110)
        public boolean handleMouse(MouseEvent e) {
            if (!this.isModeMouse(e)) {
                return false;
            }
            if (e instanceof MouseEvent.MouseMovedEvent) {
                return this.handleMove((MouseEvent.MouseMovedEvent)e);
            }
            if (e instanceof MouseEvent.MouseDragBegin) {
                return this.handleDrag((MouseEvent.MouseDragBegin)e);
            }
            if (e instanceof MouseEvent.MouseButtonReleasedEvent) {
                return this.handleRelease((MouseEvent.MouseButtonReleasedEvent)e);
            }
            return true;
        }

        private boolean handleDrag(MouseEvent.MouseDragBegin e) {
            this.dragging = true;
            this.splitConnection(e.startCanvasPos, this.tr.controlToCanvas(e.controlPosition, null));
            return true;
        }

        private boolean handleMove(MouseEvent.MouseMovedEvent e) {
            return !this.dragging;
        }

        private boolean handleRelease(MouseEvent.MouseButtonReleasedEvent e) {
            this.remove();
            return false;
        }

        boolean splitConnection(final Point2D startingPos, Point2D currentPos) {
            IDiagram diagram = ElementUtils.peekDiagram((IElement)this.edge);
            if (diagram == null) {
                return false;
            }
            final EdgeResource segment = (EdgeResource)ElementUtils.getObject((IElement)this.edge);
            if (segment == null) {
                return false;
            }
            Point2D.Double snapPos = new Point2D.Double(startingPos.getX(), startingPos.getY());
            ISnapAdvisor snap = (ISnapAdvisor)this.getHint(DiagramHints.SNAP_ADVISOR);
            if (snap != null) {
                snap.snap((Point2D)snapPos);
            }
            final AffineTransform splitPos = AffineTransform.getTranslateInstance(((Point2D)snapPos).getX(), ((Point2D)snapPos).getY());
            final AtomicReference newBp = new AtomicReference();
            try {
                SimanticsUI.getSession().syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
                        ConnectionUtil cu = new ConnectionUtil(graph);
                        Resource bp = cu.split(segment, splitPos);
                        Line2D nearestLine = ConnectionUtil.resolveNearestEdgeLineSegment(startingPos, edge);
                        if (nearestLine != null) {
                            double angle = Math.atan2(Math.abs(nearestLine.getY2() - nearestLine.getY1()), Math.abs(nearestLine.getX2() - nearestLine.getX1()));
                            if (angle >= 0.0 && angle < 0.7853981633974483) {
                                graph.claim(bp, DIA.Horizontal, bp);
                            } else if (angle > 0.7853981633974483 && angle <= 1.5707963267948966) {
                                graph.claim(bp, DIA.Vertical, bp);
                            }
                        }
                        newBp.set(bp);
                    }
                });
                this.dragData.set(new DragData(Collections.singleton((Resource)newBp.get()), startingPos, currentPos));
            }
            catch (DatabaseException e) {
                ErrorLogger.defaultLogError((Throwable)e);
            }
            return false;
        }

        static class DragData {
            Set<?> data;
            Point2D startingPoint;
            Point2D currentPoint;

            public DragData(Set<?> data, Point2D startingPoint, Point2D currentPoint) {
                this.data = data;
                this.startingPoint = startingPoint;
                this.currentPoint = currentPoint;
            }
        }
    }
}

