/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.rendering.IRouteGraphRenderer;
import org.simantics.g2d.connection.ConnectionEntity;
import org.simantics.g2d.connection.handler.ConnectionHandler;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.SelectionOutline;
import org.simantics.g2d.element.handler.impl.ConfigurableEdgeVisuals;
import org.simantics.g2d.element.handler.impl.ConnectionSelectionOutline;
import org.simantics.g2d.element.handler.impl.FillColorImpl;
import org.simantics.g2d.element.handler.impl.TextImpl;
import org.simantics.g2d.elementclass.connection.EdgeClass;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.connection.IRouteGraphListener;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class RouteGraphConnectionClass {
    public static final IHintContext.Key KEY_ROUTEGRAPH = new IHintContext.KeyOf(RouteGraph.class, "ROUTE_GRAPH");
    public static final IHintContext.Key KEY_RENDERER = new IHintContext.KeyOf(IRouteGraphRenderer.class, "ROUTE_GRAPH_RENDERER");
    public static final IHintContext.Key KEY_PICK_TOLERANCE = new IHintContext.KeyOf(Double.class, "PICK_TOLERANCE");
    public static final IHintContext.Key KEY_USE_TOLERANCE_IN_SELECTION = new IHintContext.KeyOf(Boolean.class, "PICK_TOLERANCE_SELECTION");
    public static final IHintContext.Key KEY_RG_LISTENER = new IHintContext.KeyOf(IRouteGraphListener.class, "ROUTE_GRAPH_LISTENER");
    public static final IHintContext.Key KEY_RG_NODE = new SceneGraphNodeKey(RouteGraphNode.class, "ROUTE_GRAPH_NODE");
    public static final double BOUND_TOLERANCE = 0.9;
    public static final ElementClass CLASS = ElementClass.compile((ElementHandler[])new ElementHandler[]{TextImpl.INSTANCE, EdgeClass.FixedTransform.INSTANCE, ConnectionBoundsAndPick.INSTANCE, ConnectionSelectionOutline.INSTANCE, ConnectionHandlerImpl.INSTANCE, ConnectionSceneGraph.INSTANCE, ConfigurableEdgeVisuals.DEFAULT, FillColorImpl.BLACK}).setId(RouteGraphConnectionClass.class.getSimpleName());

    public static int shortestDirectionOutOfBounds(double x, double y, Rectangle2D bounds) {
        double value;
        double mx = bounds.getMinX();
        double Mx = bounds.getMaxX();
        double my = bounds.getMinY();
        double My = bounds.getMaxY();
        double up = y - my;
        double down = My - y;
        double left = x - mx;
        double right = Mx - x;
        double[] dists = new double[]{right, down, left, up};
        byte[] masks = new byte[]{1, 2, 4, 8};
        int i = 1;
        while (i < 4) {
            value = dists[i];
            byte mask = masks[i];
            int j = i - 1;
            while (j >= 0 && dists[j] > value) {
                dists[j + 1] = dists[j];
                masks[j + 1] = masks[j];
                --j;
            }
            dists[j + 1] = value;
            masks[j + 1] = mask;
            ++i;
        }
        int mask = masks[0];
        value = dists[0] / 0.9;
        int i2 = 1;
        while (i2 < 4) {
            if (dists[i2] > value) break;
            mask |= masks[i2];
            ++i2;
        }
        return mask;
    }

    static final class ConnectionBoundsAndPick
    implements InternalSize,
    Outline,
    Pick {
        private static final long serialVersionUID = 4232871859964883266L;
        public static final ConnectionBoundsAndPick INSTANCE = new ConnectionBoundsAndPick();
        Rectangle2D temp = new Rectangle2D.Double();

        ConnectionBoundsAndPick() {
        }

        private Shape getSelectionShape(IElement e) {
            for (SelectionOutline so : e.getElementClass().getItemsByClass(SelectionOutline.class)) {
                Shape shape = so.getSelectionShape(e);
                if (shape == null) continue;
                return shape;
            }
            Shape shape = ElementUtils.getElementShapeOrBoundsOnDiagram((IElement)e);
            return shape;
        }

        public boolean pickTest(IElement e, Shape s, PickRequest.PickPolicy policy) {
            RouteGraph rg = this.getRouteGraph(e);
            if (rg == null) {
                return false;
            }
            Rectangle2D bounds = this.getBounds(s);
            switch (policy) {
                case PICK_CONTAINED_OBJECTS: {
                    Shape selectionShape = this.getSelectionShape(e);
                    return bounds.contains(selectionShape.getBounds2D());
                }
                case PICK_INTERSECTING_OBJECTS: {
                    double tolerance = 0.0;
                    tolerance = e.containsHint(KEY_USE_TOLERANCE_IN_SELECTION) ? this.getTolerance(e) : (bounds.getHeight() + bounds.getHeight()) * 0.25;
                    RouteLine node = rg.pickLine(bounds.getCenterX(), bounds.getCenterY(), tolerance);
                    return node != null;
                }
            }
            return false;
        }

        public Rectangle2D getBounds(IElement e, Rectangle2D size) {
            RouteGraph rg = this.getRouteGraph(e);
            if (rg != null) {
                if (size == null) {
                    size = new Rectangle2D.Double();
                }
                rg.getBounds(size);
            }
            return size;
        }

        public Shape getElementShape(IElement e) {
            RouteGraph rg = this.getRouteGraph(e);
            return rg == null ? null : rg.getPath2D();
        }

        private Rectangle2D getBounds(Shape shape) {
            if (shape instanceof Rectangle2D) {
                return (Rectangle2D)shape;
            }
            return shape.getBounds2D();
        }

        private RouteGraph getRouteGraph(IElement e) {
            RouteGraphNode rgn = (RouteGraphNode)e.getHint(KEY_RG_NODE);
            return rgn == null ? null : rgn.getRouteGraph();
        }

        private double getTolerance(IElement e) {
            RouteGraphNode rgn = (RouteGraphNode)e.getHint(KEY_RG_NODE);
            return rgn.getPickTolerance();
        }
    }

    static class ConnectionHandlerImpl
    implements ConnectionHandler {
        public static final ConnectionHandlerImpl INSTANCE = new ConnectionHandlerImpl();
        private static final long serialVersionUID = 3267139233182458330L;

        ConnectionHandlerImpl() {
        }

        public Collection<IElement> getBranchPoints(IElement connection, Collection<IElement> result) {
            return Collections.emptySet();
        }

        public Collection<IElement> getChildren(IElement connection, Collection<IElement> result) {
            return Collections.emptySet();
        }

        public Collection<IElement> getSegments(IElement connection, Collection<IElement> result) {
            return Collections.emptySet();
        }

        public Collection<Topology.Connection> getTerminalConnections(IElement connection, Collection<Topology.Connection> result) {
            ConnectionEntity ce = (ConnectionEntity)connection.getHint(ElementHints.KEY_CONNECTION_ENTITY);
            if (ce == null) {
                return Collections.emptySet();
            }
            return ce.getTerminalConnections(result);
        }
    }

    static final class ConnectionSceneGraph
    implements SceneGraph {
        public static final ConnectionSceneGraph INSTANCE = new ConnectionSceneGraph();
        private static final long serialVersionUID = 4232871859964883266L;

        ConnectionSceneGraph() {
        }

        public void init(IElement connection, G2DParentNode parent) {
            RouteGraph rg = (RouteGraph)connection.getHint(KEY_ROUTEGRAPH);
            IRouteGraphRenderer renderer = (IRouteGraphRenderer)connection.getHint(KEY_RENDERER);
            if (rg == null || renderer == null) {
                this.cleanup(connection);
            } else {
                RouteGraphNode rgn = (RouteGraphNode)connection.getHint(KEY_RG_NODE);
                if (rgn == null) {
                    rgn = (RouteGraphNode)parent.addNode(ElementUtils.generateNodeId((IElement)connection), RouteGraphNode.class);
                    connection.setHint(KEY_RG_NODE, (Object)rgn);
                }
                rgn.setRouteGraph(rg);
                rgn.setRenderer(renderer);
                IRouteGraphListener listener = (IRouteGraphListener)connection.getHint(KEY_RG_LISTENER);
                rgn.setRouteGraphListener(listener);
                Double tolerance = (Double)connection.getHint(KEY_PICK_TOLERANCE);
                if (tolerance != null) {
                    rgn.setPickTolerance(tolerance.doubleValue());
                }
            }
        }

        public void cleanup(IElement connection) {
            ElementUtils.removePossibleNode((IElement)connection, (IHintContext.Key)KEY_RG_NODE);
            connection.removeHint(KEY_RG_NODE);
        }
    }
}

