/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.query;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.simantics.db.impl.query.BinaryQuery;
import org.simantics.db.impl.query.CacheCollectionResult;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.DoubleKeyQueryHash;
import org.simantics.db.impl.query.DoubleKeyValueMap;

public class DoubleKeyQueryHashMap<Procedure>
extends DoubleKeyQueryHash<Procedure> {
    private int sizeInternal = 0;
    public static final ArrayList<BinaryQuery> NO_VALUES = new ArrayList();

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        return capacity;
    }

    public DoubleKeyValueMap put(int id, DoubleKeyValueMap value) {
        DoubleKeyValueMap previous = null;
        int index = this.insertionIndex(id);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = this._set[index];
            isNewMapping = false;
        }
        DoubleKeyValueMap oldKey = this._set[index];
        this._set[index] = value;
        if (isNewMapping) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    public CacheEntry put(long id, BinaryQuery value) {
        BinaryQuery old;
        int r1 = this.r1(id);
        DoubleKeyValueMap<Procedure> map = this.get(r1);
        if (map == null) {
            map = new DoubleKeyValueMap(r1);
            this.put(r1, map);
        }
        if ((old = map.put(id, value)) == null) {
            ++this.sizeInternal;
        }
        return old;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        DoubleKeyValueMap[] oldKeys = this._set;
        DoubleKeyValueMap[] newKeys = (DoubleKeyValueMap[])Array.newInstance(DoubleKeyValueMap.class, newCapacity);
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == null || oldKeys[i] == this.REMOVED) continue;
            DoubleKeyValueMap o = oldKeys[i];
            int index = this.insertionIndex2(o.id, newKeys);
            if (index < 0) {
                this.throwObjectContractViolation((Object)newKeys[-index - 1], (Object)o);
            }
            newKeys[index] = o;
        }
        this._set = newKeys;
    }

    public final DoubleKeyValueMap<Procedure> get(int id) {
        return this.index2(id);
    }

    protected static final long id(long r1, long r2) {
        long result = r1 << 32 | r2 & 0xFFFFFFFFL;
        return result;
    }

    public final int r1(long id) {
        return (int)(id >>> 32);
    }

    public final int r2(long id) {
        return (int)id;
    }

    public final BinaryQuery get(int r1, int r2) {
        DoubleKeyValueMap<Procedure> map = this.get(r1);
        if (map == null) {
            return null;
        }
        return map.get(DoubleKeyQueryHashMap.id(r1, r2));
    }

    public final BinaryQuery get(long id) {
        DoubleKeyValueMap<Procedure> map = this.get(this.r1(id));
        if (map == null) {
            return null;
        }
        return map.get(id);
    }

    public Object remove(int id) {
        DoubleKeyValueMap prev = null;
        int index = this.index(id);
        if (index >= 0) {
            prev = this._set[index];
            this.removeAt(index);
            this.sizeInternal -= prev.size();
        }
        return prev;
    }

    public Object remove(long id) {
        int r1 = this.r1(id);
        DoubleKeyValueMap<Procedure> map = this.get(r1);
        if (map == null) {
            return null;
        }
        Object removed = map.remove(id);
        if (removed != null) {
            --this.sizeInternal;
        }
        if (map.isEmpty()) {
            this.remove(r1);
        }
        return removed;
    }

    public final void values(int level, CacheCollectionResult result) {
        int i = this._set.length;
        while (i-- > 0) {
            if (this._set[i] == null || this._set[i] == this.REMOVED) continue;
            DoubleKeyValueMap map = this._set[i];
            map.values(level, result);
        }
    }

    public final ArrayList<CacheEntry> values() {
        ArrayList<CacheEntry> result = new ArrayList<CacheEntry>();
        int i = this._set.length;
        while (i-- > 0) {
            if (this._set[i] == null || this._set[i] == this.REMOVED) continue;
            DoubleKeyValueMap map = this._set[i];
            result.addAll(map.values());
        }
        return result;
    }

    public int size() {
        return this.sizeInternal;
    }

    public final <T extends BinaryQuery> ArrayList<T> values(int r1) {
        DoubleKeyValueMap<Procedure> map = this.get(r1);
        if (map == null) {
            return NO_VALUES;
        }
        return map.values();
    }
}

