/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.connection.tests;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.junit.Assert;
import org.junit.Test;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteLink;
import org.simantics.diagram.connection.RoutePoint;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.delta.RouteGraphDelta;
import org.simantics.diagram.connection.rendering.ExampleConnectionStyle;
import org.simantics.diagram.connection.rendering.StyledRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.arrows.ArrowExampleLineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.PlainExampleLineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.PlainLineEndStyle;

public class ConnectionRoutingTests {
    public static final double TOLERANCE = 1.0E-4;
    private static final boolean DEBUG_ROUTING_CONSISTENCY = false;

    public RouteTerminal addTerminal(RouteGraph rg, double x, double y, int ad) {
        return rg.addTerminal(x, y, x - 1.0, y - 1.0, x + 1.0, y + 1.0, ad);
    }

    public RouteTerminal addTerminal(RouteGraph rg, double x, double y, int ad, ILineEndStyle style) {
        return rg.addTerminal(x, y, x - 1.0, y - 1.0, x + 1.0, y + 1.0, ad, style);
    }

    private double[] routeSimpleConnection(double x, double y, int ad1, int ad2) {
        RouteGraph rg = new RouteGraph();
        RouteTerminal a = this.addTerminal(rg, 0.0, 0.0, ad1);
        RouteTerminal b = this.addTerminal(rg, x, y, ad2);
        rg.link(a, b);
        return rg.getLineLengths(a);
    }

    public void testRoute(double x, double y, int ad, double[] expected) {
        Assert.assertArrayEquals((double[])expected, (double[])this.routeSimpleConnection(x, y, 1, ad), (double)1.0E-4);
    }

    @Test
    public void testRoutingConsistency() {
        double x = -2.5;
        while (x <= 2.5) {
            double y = -2.5;
            while (y <= 2.5) {
                if (Math.abs(x) > 2.0 || Math.abs(y) > 2.0) {
                    int dir = 0;
                    while (dir < 4) {
                        if (dir != 2 || x != -2.5 || Math.abs(y) > 1.5) {
                            this.testRoutingConsistency(x, y, dir);
                        }
                        ++dir;
                    }
                }
                y += 1.0;
            }
            x += 1.0;
        }
    }

    private void testRoutingConsistency(double origX, double origY, int origDir) {
        double[] expected = this.routeSimpleConnection(origX, origY, 1, 1 << origDir);
        int rotation = 0;
        while (rotation < 4) {
            int mirror = 0;
            while (mirror < 2) {
                double x = origX;
                double y = mirror == 1 ? -origY : origY;
                int dir = origDir;
                if (mirror == 1) {
                    if (dir == 1) {
                        dir = 3;
                    } else if (dir == 3) {
                        dir = 1;
                    }
                }
                int i = 0;
                while (i < rotation) {
                    double temp = x;
                    x = -y;
                    y = temp;
                    ++i;
                }
                double[] actual = this.routeSimpleConnection(x, y, 1 << rotation, 1 << (dir + rotation) % 4);
                Assert.assertArrayEquals((double[])expected, (double[])actual, (double)1.0E-4);
                ++mirror;
            }
            ++rotation;
        }
    }

    @Test
    public void testSimpleConnection1() {
        this.testRoute(-0.5, -2.5, 1, new double[]{1.0, 2.5, 1.5});
        this.testRoute(-0.5, -2.5, 2, new double[]{1.0, 1.25, 1.5, 1.25});
        this.testRoute(-0.5, -2.5, 4, new double[]{1.0, 1.25, 2.5, 1.25, 1.0});
        this.testRoute(-0.5, -2.5, 8, new double[]{1.0, 3.5, 1.5, 1.0});
    }

    @Test
    public void testSimpleConnection2() {
        this.testRoute(0.5, -4.0, 1, new double[]{1.5, 4.0, 1.0});
        this.testRoute(0.5, -4.0, 2, new double[]{1.0, 2.0, 0.5, 2.0});
        this.testRoute(0.5, -4.0, 4, new double[]{1.0, 2.0, 1.5, 2.0, 1.0});
        this.testRoute(0.5, -4.0, 8, new double[]{1.5, 5.0, 1.0, 1.0});
    }

    @Test
    public void testSimpleConnection3() {
        this.testRoute(-3.0, 0.0, 1, new double[]{1.0, 1.0, 2.5, 1.0, 1.5});
        this.testRoute(-3.0, 0.0, 2, new double[]{1.0, 1.0, 4.0, 1.0});
        this.testRoute(-3.0, 0.0, 4, new double[]{1.0, 1.0, 5.0, 1.0, 1.0});
        this.testRoute(-3.0, 0.0, 8, new double[]{1.0, 1.0, 4.0, 1.0});
    }

    @Test
    public void testSimpleConnection4() {
        this.testRoute(3.0, 0.0, 1, new double[]{1.5, 1.0, 2.5, 1.0, 1.0});
        this.testRoute(3.0, 0.0, 2, new double[]{1.5, 1.0, 1.5, 1.0});
        this.testRoute(3.0, 0.0, 4, new double[]{3.0});
        this.testRoute(3.0, 0.0, 8, new double[]{1.5, 1.0, 1.5, 1.0});
    }

    @Test
    public void testSimpleConnection5() {
        this.testRoute(-4.0, 0.5, 1, new double[]{1.0, 1.0, 3.0, 0.5, 2.0});
        this.testRoute(-4.0, 0.5, 2, new double[]{1.0, 1.5, 5.0, 1.0});
        this.testRoute(-4.0, 0.5, 8, new double[]{1.0, 1.0, 5.0, 1.5});
    }

    @Test
    public void testSimpleConnection6() {
        this.testRoute(4.0, 3.0, 1, new double[]{5.0, 3.0, 1.0});
        this.testRoute(4.0, 3.0, 2, new double[]{2.0, 4.0, 2.0, 1.0});
        this.testRoute(4.0, 3.0, 4, new double[]{2.0, 3.0, 2.0});
        this.testRoute(4.0, 3.0, 8, new double[]{4.0, 3.0});
    }

    @Test
    public void testSimpleConnection7() {
        this.testRoute(-4.0, 3.0, 1, new double[]{1.0, 3.0, 5.0});
        this.testRoute(-4.0, 3.0, 2, new double[]{1.0, 4.0, 5.0, 1.0});
        this.testRoute(-4.0, 3.0, 4, new double[]{1.0, 1.5, 6.0, 1.5, 1.0});
        this.testRoute(-4.0, 3.0, 8, new double[]{1.0, 1.5, 5.0, 1.5});
    }

    public static THashSet<Line> lineDiff(RouteGraph rg1, RouteGraph rg2) {
        THashSet lines = new THashSet();
        for (RouteLine line : rg1.getAllLines()) {
            lines.add((Object)new Line(line));
        }
        for (RouteLine line : rg2.getAllLines()) {
            lines.remove((Object)new Line(line));
        }
        return lines;
    }

    private void genericSplitTest(RouteGraph rg, RouteLine lineToSplit) {
        THashMap map = new THashMap();
        RouteGraph rgCopy = rg.copy((THashMap<Object, Object>)map);
        RouteLine lineToSplitCopy = (RouteLine)map.get((Object)lineToSplit);
        double x1 = lineToSplit.getBegin().getX();
        double y1 = lineToSplit.getBegin().getY();
        double x2 = lineToSplit.getEnd().getX();
        double y2 = lineToSplit.getEnd().getY();
        double mx = 0.5 * (x1 + x2);
        double my = 0.5 * (y1 + y2);
        rgCopy.split(lineToSplitCopy, lineToSplit.isHorizontal() ? mx : my);
        THashSet<Line> diff1 = ConnectionRoutingTests.lineDiff(rg, rgCopy);
        THashSet<Line> diff2 = ConnectionRoutingTests.lineDiff(rgCopy, rg);
        Assert.assertArrayEquals((Object[])new Object[]{new Line(lineToSplit)}, (Object[])diff1.toArray());
        Assert.assertEquals((long)diff2.size(), (long)3L);
        Assert.assertTrue((boolean)diff2.contains((Object)new Line(x1, y1, mx, my)));
        Assert.assertTrue((boolean)diff2.contains((Object)new Line(mx, my, mx, my)));
        Assert.assertTrue((boolean)diff2.contains((Object)new Line(mx, my, x2, y2)));
        Assert.assertTrue((boolean)rgCopy.isTree());
    }

    private void genericSplitTest(RouteGraph rg) {
        Assert.assertTrue((boolean)rg.isTree());
        for (RouteLine line : rg.getAllLines()) {
            this.genericSplitTest(rg, line);
        }
    }

    @Test
    public void testSplit1() {
        RouteGraph rg = new RouteGraph();
        rg.link(this.addTerminal(rg, -10.0, 0.0, 1), this.addTerminal(rg, 10.0, 0.0, 4));
        this.genericSplitTest(rg);
    }

    @Test
    public void testSplit2() {
        RouteGraph rg = new RouteGraph();
        rg.link(this.addTerminal(rg, -20.0, -20.0, 1), this.addTerminal(rg, 20.0, 20.0, 4));
        this.genericSplitTest(rg);
    }

    @Test
    public void testSplit3() {
        RouteGraph rg = new RouteGraph();
        rg.link(this.addTerminal(rg, -20.0, -20.0, 1), this.addTerminal(rg, 20.0, 20.0, 8));
        this.genericSplitTest(rg);
    }

    @Test
    public void testSplit4() {
        RouteGraph rg = new RouteGraph();
        rg.link(this.addTerminal(rg, -20.0, -20.0, 1), rg.addLine(false, 0.0), this.addTerminal(rg, 20.0, 20.0, 4));
        this.genericSplitTest(rg);
    }

    @Test
    public void testSplit5() {
        RouteGraph rg = new RouteGraph();
        RouteLine v = rg.addLine(false, 0.0);
        rg.link(this.addTerminal(rg, -20.0, -20.0, 1), v);
        rg.link(this.addTerminal(rg, 20.0, 20.0, 4), v);
        rg.link(this.addTerminal(rg, -20.0, 0.0, 1), v);
        this.genericSplitTest(rg);
    }

    @Test
    public void testMerge1() {
        RouteGraph rg = new RouteGraph();
        RouteTerminal a = this.addTerminal(rg, -20.0, -20.0, 1);
        RouteLine l1 = rg.addLine(false, -10.0);
        RouteLine l2 = rg.addLine(true, 0.0);
        RouteLine l3 = rg.addLine(false, 10.0);
        RouteTerminal b = this.addTerminal(rg, 20.0, 20.0, 4);
        rg.link(a, l1, l2, l3, b);
        rg.merge(l2, 0.0);
        Assert.assertArrayEquals((double[])new double[]{20.0, 40.0, 20.0}, (double[])rg.getLineLengths(a), (double)1.0E-4);
    }

    @Test
    public void testMerge2() {
        RouteGraph rg = new RouteGraph();
        RouteTerminal a = this.addTerminal(rg, -20.0, -20.0, 1);
        RouteLine l = rg.addLine(false, -10.0);
        RouteTerminal b = this.addTerminal(rg, 20.0, 20.0, 4);
        rg.link(a, l, b);
        rg.merge(l, 0.0);
        Assert.assertArrayEquals((double[])new double[]{20.0, 40.0, 20.0}, (double[])rg.getLineLengths(a), (double)1.0E-4);
    }

    @Test
    public void testMerge3() {
        RouteGraph rg = new RouteGraph();
        RouteTerminal a = this.addTerminal(rg, -20.0, -20.0, 1);
        RouteTerminal b = this.addTerminal(rg, 20.0, 20.0, 4);
        rg.link(a, b);
        rg.merge((RouteLine)rg.pick(0.0, 0.0), 0.0);
        Assert.assertArrayEquals((double[])new double[]{20.0, 40.0, 20.0}, (double[])rg.getLineLengths(a), (double)1.0E-4);
    }

    @Test
    public void testDeleteCorner1() {
        RouteGraph rg = new RouteGraph();
        RouteTerminal a = this.addTerminal(rg, -20.0, 0.0, 1);
        RouteLine l1 = rg.addLine(false, -10.0);
        RouteLine l2 = rg.addLine(true, 10.0);
        RouteLine l3 = rg.addLine(false, 10.0);
        RouteTerminal b = this.addTerminal(rg, 20.0, 0.0, 4);
        rg.link(a, l1, l2, l3, b);
        rg.deleteCorner((RouteLink)rg.pick(10.0, 10.0));
        Assert.assertArrayEquals((double[])new double[]{10.0, 0.0, 30.0}, (double[])rg.getLineLengths(a), (double)1.0E-4);
    }

    @Test
    public void testRendering1() {
        RouteGraph rg = new RouteGraph();
        RouteLine l = rg.addLine(false, 0.0);
        rg.link(this.addTerminal(rg, -20.0, -20.0, 1, ArrowExampleLineEndStyle.INSTANCE), l);
        rg.link(this.addTerminal(rg, 20.0, 20.0, 4, PlainExampleLineEndStyle.INSTANCE), l);
        rg.link(this.addTerminal(rg, -40.0, 0.0, 2, PlainLineEndStyle.INSTANCE), l);
        BufferedImage image = new BufferedImage(200, 200, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.BLACK);
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, 200, 200);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(100, 100);
        new StyledRouteGraphRenderer(new ExampleConnectionStyle()).render(g, rg);
    }

    @Test
    public void testRendering2() {
        RouteGraph rg = new RouteGraph();
        rg.link(this.addTerminal(rg, -20.0, 0.0, 1), this.addTerminal(rg, 20.0, 1.0, 4));
        BufferedImage image = new BufferedImage(200, 200, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.BLACK);
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, 200, 200);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(100, 100);
        new StyledRouteGraphRenderer(new ExampleConnectionStyle()).render(g, rg);
    }

    @Test
    public void testRendering3() {
        RouteGraph rg = new RouteGraph();
        rg.link(this.addTerminal(rg, 0.0, -20.0, 2), this.addTerminal(rg, 1.0, 20.0, 8));
        BufferedImage image = new BufferedImage(200, 200, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(Color.BLACK);
        g.setBackground(Color.WHITE);
        g.clearRect(0, 0, 200, 200);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.translate(100, 100);
        new StyledRouteGraphRenderer(new ExampleConnectionStyle()).render(g, rg);
    }

    @Test
    public void testPickingLineHalves() {
        RouteGraph rg = new RouteGraph();
        RouteLine l = rg.addLine(false, 0.0);
        RouteTerminal t1 = this.addTerminal(rg, -20.0, -20.0, 1);
        rg.link(t1, l);
        rg.link(this.addTerminal(rg, 20.0, 20.0, 1), l);
        rg.link(this.addTerminal(rg, -40.0, 0.0, 1), l);
        Assert.assertEquals((Object)t1, (Object)rg.pickLineHalf(-1.0, -20.0, 0.0).getLine().getTerminal());
        Assert.assertEquals(null, (Object)rg.pickLineHalf(-18.0, -20.0, 0.0));
        Assert.assertEquals(null, (Object)rg.pickLineHalf(0.0, -18.0, 0.0));
    }

    @Test
    public void testCopy() {
        RouteGraph rg = new RouteGraph();
        RouteLine l = rg.addLine(false, 0.0);
        RouteTerminal a = this.addTerminal(rg, -20.0, -20.0, 1);
        RouteTerminal b = this.addTerminal(rg, 20.0, 20.0, 4);
        rg.link(a, l, b);
        RouteGraph rgc = rg.copy();
        rgc.split((RouteLine)rgc.pick(-10.0, -20.0), -10.0);
        Assert.assertArrayEquals((double[])new double[]{20.0, 40.0, 20.0}, (double[])rg.getLineLengths(a), (double)1.0E-4);
    }

    @Test
    public void testConnecting1() {
        RouteGraph rg = new RouteGraph();
        RouteTerminal a = this.addTerminal(rg, -10.0, 0.0, 1);
        RouteTerminal b = this.addTerminal(rg, 10.0, 0.0, 4);
        rg.link(a, b);
        rg.connectTerminal(this.addTerminal(rg, -10.0, 10.0, 1), 0.0, 0.0, 0.1);
        Assert.assertTrue((boolean)rg.isTree());
    }

    @Test
    public void testConnecting2() {
        RouteGraph rg = new RouteGraph();
        RouteTerminal a = this.addTerminal(rg, -10.0, -10.0, 1);
        RouteTerminal b = this.addTerminal(rg, 10.0, 10.0, 4);
        rg.link(a, b);
        rg.connectTerminal(this.addTerminal(rg, -10.0, 0.0, 1), 0.0, 0.0, 0.1);
        Assert.assertTrue((boolean)rg.isTree());
    }

    @Test
    public void testDiff1() {
        RouteGraph rg = new RouteGraph();
        RouteTerminal a = this.addTerminal(rg, -10.0, -10.0, 1);
        a.setData(1);
        RouteLine l = rg.addLine(false, 0.0);
        l.setData(2);
        RouteTerminal b = this.addTerminal(rg, 10.0, 10.0, 4);
        b.setData(3);
        rg.link(a, l, b);
        RouteGraph rgc = rg.copy();
        rgc.split(rgc.getLines().iterator().next(), 0.0);
        new RouteGraphDelta(rg, rgc).print();
    }

    @Test
    public void testSerialize1() throws IOException, ClassNotFoundException {
        RouteGraph rg = new RouteGraph();
        RouteTerminal a = this.addTerminal(rg, -10.0, -10.0, 1);
        a.setData(1);
        RouteLine l = rg.addLine(false, 0.0);
        l.setData(2);
        RouteTerminal b = this.addTerminal(rg, 10.0, 10.0, 4);
        b.setData(3);
        rg.link(a, l, b);
        StyledRouteGraphRenderer renderer = new StyledRouteGraphRenderer(new ExampleConnectionStyle());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(rg);
        oos.writeObject(renderer);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        RouteGraph rgc = (RouteGraph)ois.readObject();
        new RouteGraphDelta(rg, rgc).print();
    }

    static class Line {
        double x1;
        double y1;
        double x2;
        double y2;

        public Line(double x1, double y1, double x2, double y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public Line(RoutePoint a, RoutePoint b) {
            this.x1 = a.getX();
            this.y1 = a.getY();
            this.x2 = b.getX();
            this.y2 = b.getY();
        }

        public Line(RouteLine line) {
            this(line.getBegin(), line.getEnd());
        }

        public int hashCode() {
            int result = 1;
            long temp = Double.doubleToLongBits(this.x1);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.x2);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.y1);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            temp = Double.doubleToLongBits(this.y2);
            result = 31 * result + (int)(temp ^ temp >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Line other = (Line)obj;
            if (Double.doubleToLongBits(this.x1) != Double.doubleToLongBits(other.x1)) {
                return false;
            }
            if (Double.doubleToLongBits(this.x2) != Double.doubleToLongBits(other.x2)) {
                return false;
            }
            if (Double.doubleToLongBits(this.y1) != Double.doubleToLongBits(other.y1)) {
                return false;
            }
            return Double.doubleToLongBits(this.y2) == Double.doubleToLongBits(other.y2);
        }
    }
}

