/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.image.ui;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.image.ui.ImageSource;
import org.simantics.image2.ontology.ImageResource;
import org.simantics.layer0.Layer0;

public class CreateImage
extends WriteRequest {
    private Resource container;
    private ImageSource source;

    public CreateImage(Resource container, ImageSource source) {
        this.container = container;
        this.source = source;
    }

    public static Resource getType(ReadGraph graph, ImageSource source) throws DatabaseException {
        ImageResource IMAGE = ImageResource.getInstance((ReadGraph)graph);
        String name = source.name.toLowerCase();
        if (name.endsWith("svg")) {
            return IMAGE.SvgImage;
        }
        if (name.endsWith("png")) {
            return IMAGE.PngImage;
        }
        if (name.endsWith("jpg") || name.endsWith("jpeg")) {
            return IMAGE.JpegImage;
        }
        if (name.endsWith("gif")) {
            return IMAGE.GifImage;
        }
        throw new DatabaseException("Unsupported image format " + source.name);
    }

    public static void claimLiteral(WriteGraph graph, Resource image, ImageSource source) throws DatabaseException {
        String name = source.name.toLowerCase();
        if (name.endsWith("svg")) {
            graph.claimValue(image, (Object)new String(source.data), (Binding)Bindings.STRING);
        } else if (name.endsWith("png") || name.endsWith("jpg") || name.endsWith("jpeg") || name.endsWith("gif")) {
            graph.claimValue(image, (Object)source.data, (Binding)Bindings.BYTE_ARRAY);
        } else {
            throw new DatabaseException("Unsupported image format " + source.name);
        }
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        this.doImage(graph, this.container, this.source);
    }

    public Resource doImage(WriteGraph graph, Resource parent, ImageSource source) throws DatabaseException {
        graph.markUndoPoint();
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource image = graph.newResource();
        graph.claim(image, L0.InstanceOf, null, CreateImage.getType((ReadGraph)graph, source));
        graph.claimLiteral(image, L0.HasName, (Object)source.name, (Binding)Bindings.STRING);
        CreateImage.claimLiteral(graph, image, source);
        graph.claim(parent, L0.ConsistsOf, image);
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Imported image " + source.name + " " + image.toString()));
        return image;
    }
}

