/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor.e4;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Named;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.charts.editor.e4.TimeSeriesEditor;
import org.simantics.charts.ui.CSVProgressMonitor;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.parser.StringEscapeUtils;
import org.simantics.databoard.util.Bean;
import org.simantics.databoard.util.StreamUtil;
import org.simantics.history.HistoryException;
import org.simantics.history.ItemManager;
import org.simantics.history.csv.CSVFormatter;
import org.simantics.history.csv.ColumnSeparator;
import org.simantics.history.csv.DecimalSeparator;
import org.simantics.history.csv.ExportInterpolation;
import org.simantics.history.util.ProgressMonitor;
import org.simantics.history.util.subscription.SamplingFormat;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.impl.TrendNode;
import org.simantics.utils.format.FormattingUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ChartCopyHandler {
    String lastFile;

    @CanExecute
    public boolean canExecute(@Named(value="e4ActivePart") MPart part) {
        if (part == null) {
            return false;
        }
        return part.getObject() instanceof TimeSeriesEditor;
    }

    @Execute
    public void execute(@Named(value="e4ActivePart") MPart part, final @Named(value="activeShell") Shell shell) throws ExecutionException {
        if (!(part.getObject() instanceof TimeSeriesEditor)) {
            return;
        }
        TimeSeriesEditor editor = (TimeSeriesEditor)((Object)part.getObject());
        final TrendNode trendNode = editor.trendNode;
        IWorkbenchPart wbpart = WorkbenchUtils.getActiveWorkbenchPart();
        IStatusLineManager status = WorkbenchUtils.getStatusLine((IWorkbenchPart)wbpart);
        final AtomicBoolean result = new AtomicBoolean(false);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    result.set(ChartCopyHandler.this.copyDataToClipboard(monitor, trendNode, Format.JOINED_TIME, shell));
                }
            });
            if (!result.get()) {
                status.setMessage("No data to copy");
            } else {
                status.setMessage("Copied chart data to clipboard");
            }
            status.setErrorMessage(null);
        }
        catch (InvocationTargetException e) {
            ErrorLogger.defaultLogError((Throwable)e.getCause());
        }
        catch (InterruptedException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean copyDataToClipboard(IProgressMonitor monitor, TrendNode t, Format format, final Shell shell) {
        Charset UTF8 = Charset.forName("UTF-8");
        try {
            ScopedPreferenceStore csvnode = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling");
            String ext = csvnode.getString("csv.file.extension");
            File tmpFile = File.createTempFile("clipboard", ext);
            tmpFile.deleteOnExit();
            FileOutputStream fos = new FileOutputStream(tmpFile);
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, UTF8));
            try {
                ItemManager im = new ItemManager(t.historian.getItems());
                CSVFormatter formatter = new CSVFormatter();
                formatter.setTimeRange(t.horizRuler.from, t.horizRuler.end);
                formatter.setStartTime(csvnode.getDouble("csv.start"));
                formatter.setTimeStep(csvnode.getDouble("csv.step"));
                formatter.setDecimalSeparator(DecimalSeparator.fromPreference((String)csvnode.getString("csv.decimal.separator")));
                formatter.setColumnSeparator(ColumnSeparator.fromPreference((String)StringEscapeUtils.unescape((String)csvnode.getString("csv.value.separator"))));
                formatter.setResample(csvnode.getBoolean("csv.resample"));
                formatter.setNumberInterpolation(ExportInterpolation.fromPreference((String)csvnode.getString("csv.sampling.mode")));
                formatter.setTimeFormat(FormattingUtils.significantDigitFormat((int)csvnode.getInt("csv.format.time.digits")));
                formatter.setFloatFormat(FormattingUtils.significantDigitFormat((int)csvnode.getInt("csv.format.float.digits")));
                formatter.setNumberFormat(FormattingUtils.significantDigitFormat((int)csvnode.getInt("csv.format.double.digits")));
                for (TrendItem i : t.spec.items) {
                    if (i.hidden) continue;
                    List items = im.search("variableId", (Object)i.variableId);
                    Collections.sort(items, SamplingFormat.INTERVAL_COMPARATOR);
                    if (items.isEmpty()) continue;
                    Bean config = (Bean)items.get(0);
                    String historyId = (String)config.getFieldUnchecked("id");
                    formatter.addItem(t.historian, historyId, i.simpleLabel, i.variableReference, i.unit);
                }
                formatter.sort();
                switch (format) {
                    case TIME_VALUE_PAIRS: {
                        break;
                    }
                    case JOINED_TIME: {
                        formatter.formulate2((ProgressMonitor)new CSVProgressMonitor(monitor), (Appendable)w);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("unsupported format " + (Object)((Object)format));
                    }
                }
                w.flush();
                if (tmpFile.length() == 0L) {
                    return false;
                }
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Clipboard clipboard = toolkit.getSystemClipboard();
                w.flush();
                fos.close();
                fos = null;
                System.out.println("Exported to " + tmpFile + " size: " + tmpFile.length());
                if (tmpFile.length() > 0xA00000L) {
                    final File csvFile = tmpFile;
                    tmpFile = null;
                    shell.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            FileDialog fd = new FileDialog(shell, 8192);
                            fd.setText("Write CSV to File");
                            fd.setFileName(ChartCopyHandler.this.lastFile != null ? ChartCopyHandler.this.lastFile : csvFile.getAbsolutePath());
                            String newFile = fd.open();
                            if (newFile != null) {
                                ChartCopyHandler.this.lastFile = newFile;
                                File ff = new File(newFile);
                                ff.delete();
                                csvFile.renameTo(ff);
                            } else {
                                csvFile.delete();
                            }
                        }
                    });
                }
                String str = StreamUtil.readString((File)tmpFile, (Charset)UTF8);
                StringSelection strSel = new StringSelection(str);
                clipboard.setContents(strSel, null);
            }
            catch (BindingException e1) {
                ErrorLogger.defaultLogError((Throwable)e1);
                return false;
            }
            catch (IOException e) {
                ErrorLogger.defaultLogError((Throwable)e);
                return true;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                }
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
        catch (HistoryException e) {
            ErrorLogger.defaultLogError((Throwable)e);
            return false;
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((Throwable)e);
        }
        return false;
    }

    static enum Format {
        TIME_VALUE_PAIRS,
        JOINED_TIME;

    }
}

