/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.simantics.charts.ITrendSupport;
import org.simantics.charts.editor.ChartData;
import org.simantics.charts.editor.ChartKeys;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.util.Bean;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.history.HistoryException;
import org.simantics.history.HistorySamplerItem;
import org.simantics.history.HistorySamplerItem2;
import org.simantics.history.ItemManager;
import org.simantics.history.util.subscription.SamplingFormat;
import org.simantics.modeling.subscription.SubscriptionItem;
import org.simantics.modeling.subscription.SubscriptionItemQuery;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.utils.datastructures.hints.IHintContext;

public final class Charts {
    public static final Comparator<HistorySamplerItem2.LevelItem> ASCENDING_INTERVAL_ORDER = (o1, o2) -> SamplingFormat.compareSamplingInterval((double)o1.samplingInterval, (double)o2.samplingInterval);

    public static void resetChartEditorData(IProject project, Resource model, ChartData editorData) {
        if (editorData != null) {
            project.setHint((IHintContext.Key)ChartKeys.chartSourceKey(model), (Object)editorData);
        } else {
            project.removeHint((IHintContext.Key)ChartKeys.chartSourceKey(model));
        }
    }

    public static HistorySamplerItem createHistorySamplerItem(ReadGraph graph, Variable run, Resource subscriptionItem) throws DatabaseException {
        IExperiment exp = (IExperiment)run.getPropertyValue(graph, "iExperiment");
        ITrendSupport support = (ITrendSupport)exp.getService(ITrendSupport.class);
        ChartData data = support.getChartData();
        return Charts.createHistorySamplerItem(graph, subscriptionItem, data);
    }

    public static HistorySamplerItem createHistorySamplerItem(ReadGraph graph, Resource subscriptionItem, ChartData data) throws DatabaseException {
        try {
            Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(subscriptionItem));
            if (indexRoot == null) {
                throw new DatabaseException("There is no index root for " + subscriptionItem);
            }
            if (data == null) {
                throw new DatabaseException("There is no chart data for " + subscriptionItem);
            }
            ItemManager im = new ItemManager(data.history.getItems());
            SubscriptionItem i = (SubscriptionItem)graph.syncRequest((Read)new SubscriptionItemQuery(subscriptionItem));
            List items = im.search("variableId", (Object)i.variableId);
            Collections.sort(items, SamplingFormat.INTERVAL_COMPARATOR);
            if (items.isEmpty()) {
                throw new DatabaseException("There is history item for " + i.variableId);
            }
            Bean config = (Bean)items.get(0);
            String historyId = (String)config.getFieldUnchecked("id");
            return new HistorySamplerItem(data.collector, data.history, historyId, System.identityHashCode(data));
        }
        catch (HistoryException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (BindingException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static HistorySamplerItem2 createHistorySamplerItem2(ReadGraph graph, Variable run, Resource subscriptionItem) throws DatabaseException {
        IExperiment exp = (IExperiment)run.getPropertyValue(graph, "iExperiment");
        ITrendSupport support = (ITrendSupport)exp.getService(ITrendSupport.class);
        ChartData data = support.getChartData();
        return Charts.createHistorySamplerItem2(graph, subscriptionItem, data);
    }

    public static HistorySamplerItem2 createHistorySamplerItem2(ReadGraph graph, Resource subscriptionItem, ChartData data) throws DatabaseException {
        try {
            Resource indexRoot = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(subscriptionItem));
            if (indexRoot == null) {
                throw new DatabaseException("There is no index root for " + subscriptionItem);
            }
            if (data == null) {
                throw new DatabaseException("There is no chart data for " + subscriptionItem);
            }
            SubscriptionItem i = (SubscriptionItem)graph.syncRequest((Read)new SubscriptionItemQuery(subscriptionItem));
            ItemManager im = new ItemManager(data.history.getItems());
            List items = im.search("variableId", (Object)i.variableId);
            if (items.isEmpty()) {
                throw new DatabaseException("There is history item for " + i.variableId);
            }
            HistorySamplerItem2.LevelItem[] historyItems = (HistorySamplerItem2.LevelItem[])items.stream().map(Charts::toLevelItem).sorted(ASCENDING_INTERVAL_ORDER).toArray(HistorySamplerItem2.LevelItem[]::new);
            return new HistorySamplerItem2(data.collector, data.history, historyItems, System.identityHashCode(data));
        }
        catch (HistoryException e) {
            throw new DatabaseException((Throwable)e);
        }
        catch (BindingException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    private static HistorySamplerItem2.LevelItem toLevelItem(Bean bean) {
        String id = (String)bean.getFieldUnchecked("id");
        double interval = (Double)bean.getFieldUnchecked("interval");
        return new HistorySamplerItem2.LevelItem(id, interval);
    }
}

