/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.debug.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.primitiverequest.PossibleAdapter;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.migration.OntologiesFromLibrary;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.debug.ui.LabeledResource;
import org.simantics.debug.ui.ResourceSearch;
import org.simantics.debug.ui.ShowInBrowser;
import org.simantics.debug.ui.internal.Activator;
import org.simantics.debug.ui.internal.DebugUtils;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.scl.runtime.function.Function;
import org.simantics.ui.selection.ResourceWorkbenchSelectionElement;
import org.simantics.ui.workbench.dialogs.ResourceLabelProvider;
import org.simantics.utils.Container;
import org.simantics.utils.ui.BundleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResourceDialog
extends FilteredItemsSelectionDialog {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchResourceDialog.class);
    private static final int DEFAULT_MAX_INDEX_HITS = 1000;
    private static final Pattern ID_PATTERN = Pattern.compile("\\$([0-9]+)");
    private static final String SEARCH_RESOURCE_DIALOG = "SearchResourceDialog";
    private static final int SHOW_IN_BROWSER_ID = 1025;
    private static final String SHOW_IN_BROWSER_LABEL = "Show In Browser";
    private Session session;
    private IStructuredSelection selection;
    private ResourceManager resourceManager;
    private ResourceSearch.IResourceFilter resourceFilter = ResourceSearch.FILTER_ALL;
    LabelProvider detailsLabelProvider = new LabelProvider(){

        public String getText(Object element) {
            if (element == null) {
                return "null";
            }
            if (element instanceof String) {
                return (String)element;
            }
            Container rc = (Container)element;
            final Resource r = (Resource)rc.get();
            try {
                return (String)SearchResourceDialog.this.session.syncRequest((Read)new Read<String>(){

                    public String perform(ReadGraph g) throws DatabaseException {
                        String name = NameUtils.getSafeName((ReadGraph)g, (Resource)r);
                        String uri = DebugUtils.getPossibleRootRelativePath(g, r);
                        return "[" + r.getResourceId() + "] - " + name + (uri != null ? " - " : "") + (uri != null ? uri : "");
                    }
                });
            }
            catch (DatabaseException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.debug.ui", "Resource label provider failed unexpectedly.", (Throwable)e));
                return "";
            }
        }
    };
    ElementLabelProvider labelProvider;

    public SearchResourceDialog(Session s, boolean multi, Shell shell, String title) {
        this(s, multi, shell, title, null);
    }

    public SearchResourceDialog(Session s, boolean multi, Shell shell, String title, IStructuredSelection selection) {
        super(shell, multi);
        this.session = s;
        this.selection = selection;
        this.labelProvider = new ElementLabelProvider(shell.getDisplay());
        this.setMessage("Enter name, resource URI or ID");
        this.setListLabelProvider((ILabelProvider)this.labelProvider);
        this.setDetailsLabelProvider((ILabelProvider)this.detailsLabelProvider);
        this.setTitle(title);
        this.setSelectionHistory(new ResourceSelectionHistory());
        this.setSeparatorLabel("Previously selected above, others below");
    }

    protected void configureShell(Shell shell) {
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)shell);
        this.setImage((Image)this.resourceManager.get((DeviceResourceDescriptor)BundleUtils.getImageDescriptorFromPlugin((String)"org.simantics.debug.ui", (String)"icons/cog_blue.png")));
        super.configureShell(shell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1025, SHOW_IN_BROWSER_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.okPressed();
            LabeledResource lr = (LabeledResource)this.getFirstResult();
            ShowInBrowser.defaultExecute((ISelection)new StructuredSelection((Object)new ResourceWorkbenchSelectionElement(lr.resource)));
            return;
        }
        super.buttonPressed(buttonId);
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new ItemsFilterWithSearchResults();
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        ((ItemsFilterWithSearchResults)itemsFilter).fillContentProvider(contentProvider);
        progressMonitor.done();
    }

    private long referencedResourceId(String pattern) {
        Matcher m = ID_PATTERN.matcher(pattern);
        if (m.matches()) {
            String id = m.group(1);
            try {
                return Long.parseLong(id);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0L;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings().getSection(SEARCH_RESOURCE_DIALOG);
        if (settings == null) {
            settings = Activator.getDefault().getDialogSettings().addNewSection(SEARCH_RESOURCE_DIALOG);
        }
        return settings;
    }

    public String getElementName(Object item) {
        return String.valueOf(((Resource)((Container)item).get()).getResourceId());
    }

    protected Comparator<?> getItemsComparator() {
        return (arg0, arg1) -> arg0.toString().compareTo(arg1.toString());
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    public ResourceSearch.IResourceFilter getResourceFilter() {
        return this.resourceFilter;
    }

    public void setResourceFilter(ResourceSearch.IResourceFilter resourceFilter) {
        this.resourceFilter = resourceFilter;
    }

    private String getFilterForResourceFilter(ResourceSearch.IResourceFilter filter) {
        if (filter == null || filter == ResourceSearch.FILTER_ALL) {
            return "";
        }
        if (filter == ResourceSearch.FILTER_RELATIONS) {
            return "Types:Relation";
        }
        if (filter == ResourceSearch.FILTER_TYPES) {
            return "Types:Type";
        }
        return "";
    }

    static class ElementLabelProvider
    extends ResourceLabelProvider {
        public ElementLabelProvider(Display display) {
            super(display);
        }

        public String getText(Object element) {
            if (element == null) {
                return "null";
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element == null) {
                return null;
            }
            Container rc = (Container)element;
            Resource r = (Resource)rc.get();
            return super.getImage((Object)r);
        }
    }

    private class ItemsFilterWithSearchResults
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private Set<Object> searchResults;

        public ItemsFilterWithSearchResults() {
            super((FilteredItemsSelectionDialog)SearchResourceDialog.this);
            this.searchResults = new HashSet<Object>();
            final String pattern = this.getPattern();
            final boolean findUris = pattern.trim().startsWith("http:/");
            final long referencedResourceId = SearchResourceDialog.this.referencedResourceId(pattern);
            final boolean findIds = referencedResourceId != 0L;
            this.searchResults.clear();
            if (pattern.isEmpty()) {
                return;
            }
            try {
                SearchResourceDialog.this.session.syncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        block10: {
                            block9: {
                                Resource r;
                                if (findIds) {
                                    try {
                                        Resource r2 = ((SerialisationSupport)graph.getService(SerialisationSupport.class)).getResource(referencedResourceId);
                                        ItemsFilterWithSearchResults.this.searchResults.add(new LabeledResource(DebugUtils.getSafeLabel(graph, r2), r2));
                                    }
                                    catch (DatabaseException databaseException) {}
                                }
                                if (!findUris) break block9;
                                String uri = pattern;
                                if (uri.endsWith(Variables.Role.CHILD.getIdentifier())) {
                                    uri = uri.substring(0, uri.length() - 1);
                                }
                                if ((r = graph.getPossibleResource(uri)) == null) break block10;
                                ItemsFilterWithSearchResults.this.searchResults.add(new LabeledResource(DebugUtils.getSafeURI(graph, r), r));
                                Map children = (Map)graph.syncRequest((Read)new UnescapedChildMapOfResource(r));
                                for (Resource child : children.values()) {
                                    ItemsFilterWithSearchResults.this.searchResults.add(new LabeledResource(DebugUtils.getSafeURI(graph, child), child));
                                }
                                break block10;
                            }
                            Resource project = Simantics.peekProjectResource();
                            if (project != null) {
                                ResourceSearch.IResourceFilter rf = SearchResourceDialog.this.resourceFilter;
                                String filter = SearchResourceDialog.this.getFilterForResourceFilter(rf);
                                if (!filter.isEmpty()) {
                                    filter = String.valueOf(filter) + " AND ";
                                }
                                filter = String.valueOf(filter) + "Name:" + pattern + "*";
                                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                                HashSet indexRoots = new HashSet();
                                indexRoots.addAll((Collection)graph.syncRequest((Read)new ObjectsWithType(project, L0.ConsistsOf, L0.IndexRoot)));
                                indexRoots.addAll((Collection)graph.syncRequest((Read)new OntologiesFromLibrary(graph.getRootLibrary())));
                                for (Resource indexRoot : indexRoots) {
                                    Collection<Resource> hits = this.find(graph, indexRoot, filter);
                                    for (Resource r : hits) {
                                        if (rf != null && !rf.acceptResource(graph, r)) continue;
                                        ItemsFilterWithSearchResults.this.searchResults.add(new LabeledResource(DebugUtils.getSafeLabel(graph, r), r));
                                    }
                                }
                            }
                        }
                    }

                    public Collection<Resource> find(ReadGraph graph, Resource index, String filter) throws DatabaseException {
                        Collection indexResult = (Collection)graph.syncRequest((Read)new QueryIndex(index, filter), (Listener)TransientCacheListener.instance());
                        return indexResult;
                    }
                });
            }
            catch (DatabaseException ex) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.debug.ui", ex.getMessage(), (Throwable)ex));
            }
        }

        public boolean matchItem(Object item) {
            return this.searchResults.contains(item);
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            return false;
        }

        public boolean isConsistentItem(Object item) {
            return true;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            return false;
        }

        public void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider) {
            for (Object item : this.searchResults) {
                contentProvider.add(item, (FilteredItemsSelectionDialog.ItemsFilter)this);
            }
        }
    }

    static class QueryIndex
    extends BinaryRead<Resource, String, Collection<Resource>> {
        public QueryIndex(Resource index, String filter) {
            super((Object)index, (Object)filter);
        }

        public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
            Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
            Function dependencies = (Function)graph.syncRequest((AsyncRead)new PossibleAdapter(L0X.DependencyResources, Function.class), (Listener)TransientCacheListener.instance());
            if (dependencies == null) {
                return Collections.emptyList();
            }
            List results = (List)dependencies.apply((Object)graph, this.parameter, this.parameter2, (Object)1000);
            if (results == null || results.isEmpty()) {
                return Collections.emptyList();
            }
            TreeSet<Resource> resultSet = new TreeSet<Resource>();
            for (Resource res : results) {
                if (res == null || resultSet.contains(res)) continue;
                resultSet.add(res);
            }
            return new ArrayList<Resource>(resultSet);
        }
    }

    class ResourceSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        ResourceSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            String name;
            Resource r;
            block5: {
                block4: {
                    String data = memento.getTextData();
                    SerialisationSupport support = (SerialisationSupport)Simantics.getSession().getService(SerialisationSupport.class);
                    r = support.getResource(Long.parseLong(data));
                    if (r != null) break block4;
                    return null;
                }
                name = (String)SearchResourceDialog.this.session.syncRequest((Read)new UniqueRead<String>(){

                    public String perform(ReadGraph g) throws DatabaseException {
                        if (!SearchResourceDialog.this.resourceFilter.acceptResource(g, r)) {
                            return null;
                        }
                        try {
                            try {
                                return DebugUtils.getSafeLabel(g, r);
                            }
                            catch (Exception exception) {
                                System.out.println("Exception thrown from restoreItemFromMemento");
                            }
                        }
                        catch (Throwable throwable) {}
                        return "" + r.getResourceId();
                    }
                });
                if (name != null) break block5;
                return null;
            }
            try {
                return new LabeledResource(name, r);
            }
            catch (NumberFormatException | DatabaseException e) {
                LOGGER.info("Search memento restoration failed.", e);
                return null;
            }
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
            if (item instanceof Container) {
                try {
                    SerialisationSupport support = (SerialisationSupport)Simantics.getSession().getService(SerialisationSupport.class);
                    memento.putTextData(String.valueOf(support.getRandomAccessId((Resource)((Container)item).get())));
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

