/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.ObjectTable;

class CalculateStatements
implements ClusterI.PredicateProcedure<CalculateStatements> {
    private ObjectTable ot;
    private final int sRef;

    CalculateStatements(int sRef, ObjectTable ot) {
        this.sRef = sRef;
        this.ot = ot;
    }

    public boolean execute(CalculateStatements context, int pKey, int oIndex) {
        if (ClusterTraits.statementIndexIsDirect(oIndex)) {
            return false;
        }
        try {
            oIndex = ClusterTraits.statementIndexGet(oIndex);
        }
        catch (DatabaseException databaseException) {
            Logger.getDefault().logError("Missing object set for s=" + this.sRef + " p=" + pKey, null);
            return false;
        }
        int osize = this.ot.getObjectSetSize(oIndex);
        if (osize == 3 || osize > 9) {
            System.out.println("Resource " + this.sRef + " predicate " + pKey + " has " + osize + " objects.");
        }
        return true;
    }
}

