/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.BijectionMap;
import fi.vtt.simantics.procore.internal.BuiltinSupportImpl;
import fi.vtt.simantics.procore.internal.ClientChangesImpl;
import fi.vtt.simantics.procore.internal.ClusterBuilderFactoryImpl;
import fi.vtt.simantics.procore.internal.ClusterBuilderImpl;
import fi.vtt.simantics.procore.internal.ClusterControlImpl;
import fi.vtt.simantics.procore.internal.ClusterSetsSupportImpl2;
import fi.vtt.simantics.procore.internal.ClusterStream;
import fi.vtt.simantics.procore.internal.ClusterTable;
import fi.vtt.simantics.procore.internal.ClusterWriteOnly;
import fi.vtt.simantics.procore.internal.ClusteringSupportImpl;
import fi.vtt.simantics.procore.internal.CollectionSupportImpl;
import fi.vtt.simantics.procore.internal.DebugSupportImpl;
import fi.vtt.simantics.procore.internal.DirectQuerySupportImpl;
import fi.vtt.simantics.procore.internal.ExternalValueSupportImpl;
import fi.vtt.simantics.procore.internal.GraphChangeListenerSupportImpl;
import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.InitSupportImpl;
import fi.vtt.simantics.procore.internal.LifecycleSupportImpl;
import fi.vtt.simantics.procore.internal.ManagementSupportImpl;
import fi.vtt.simantics.procore.internal.QueryControlImpl;
import fi.vtt.simantics.procore.internal.QueryDebugImpl;
import fi.vtt.simantics.procore.internal.QuerySupportImpl;
import fi.vtt.simantics.procore.internal.RandomAccessValueSupportImpl;
import fi.vtt.simantics.procore.internal.ResourceSupportImpl;
import fi.vtt.simantics.procore.internal.SerialisationSupportImpl;
import fi.vtt.simantics.procore.internal.ServiceLocatorImpl;
import fi.vtt.simantics.procore.internal.SessionEventSupportImpl;
import fi.vtt.simantics.procore.internal.SessionMonitorSupportImpl;
import fi.vtt.simantics.procore.internal.SessionRequestManager;
import fi.vtt.simantics.procore.internal.SessionUserSupportImpl;
import fi.vtt.simantics.procore.internal.State;
import fi.vtt.simantics.procore.internal.StatementSupportImpl;
import fi.vtt.simantics.procore.internal.StaticSessionProperties;
import fi.vtt.simantics.procore.internal.TransactionSupportImpl;
import fi.vtt.simantics.procore.internal.TransferableGraphSupportImpl;
import fi.vtt.simantics.procore.internal.UndoRedoSupportImpl;
import fi.vtt.simantics.procore.internal.VirtualGraphServerSupportImpl;
import fi.vtt.simantics.procore.internal.WriteState;
import fi.vtt.simantics.procore.internal.WriteStateBase;
import fi.vtt.simantics.procore.internal.XSupportImpl;
import gnu.trove.procedure.TLongProcedure;
import gnu.trove.set.hash.TLongHashSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.eclipse.core.runtime.Platform;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.ChangeSet;
import org.simantics.db.Disposable;
import org.simantics.db.ExternalValueSupport;
import org.simantics.db.Metadata;
import org.simantics.db.MonitorContext;
import org.simantics.db.MonitorHandler;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ResourceSerializer;
import org.simantics.db.ServiceLocator;
import org.simantics.db.Session;
import org.simantics.db.SessionManager;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.authentication.UserAuthenticationAgent;
import org.simantics.db.authentication.UserAuthenticator;
import org.simantics.db.common.Indexing;
import org.simantics.db.common.TransactionPolicyRelease;
import org.simantics.db.common.procedure.adapter.AsyncMultiProcedureAdapter;
import org.simantics.db.common.procedure.adapter.ProcedureAdapter;
import org.simantics.db.common.procedure.wrapper.NoneToAsyncListener;
import org.simantics.db.common.procedure.wrapper.NoneToAsyncMultiListener;
import org.simantics.db.common.procedure.wrapper.NoneToAsyncMultiProcedure;
import org.simantics.db.common.procedure.wrapper.NoneToAsyncProcedure;
import org.simantics.db.common.procedure.wrapper.SyncToAsyncListener;
import org.simantics.db.common.procedure.wrapper.SyncToAsyncMultiListener;
import org.simantics.db.common.procedure.wrapper.SyncToAsyncMultiProcedure;
import org.simantics.db.common.procedure.wrapper.SyncToAsyncProcedure;
import org.simantics.db.common.service.ServiceActivityMonitorImpl;
import org.simantics.db.common.service.ServiceActivityUpdaterForWriteTransactions;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.event.ChangeEvent;
import org.simantics.db.event.ChangeListener;
import org.simantics.db.event.SessionEventListener;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.ClusterSetExistException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ImmutableException;
import org.simantics.db.exception.InvalidResourceReferenceException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ServiceNotFoundException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ClusterTranslator;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.TransientGraph;
import org.simantics.db.impl.VirtualGraphImpl;
import org.simantics.db.impl.graph.DelayedWriteGraph;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.graph.WriteGraphImpl;
import org.simantics.db.impl.graph.WriteSupport;
import org.simantics.db.impl.internal.RandomAccessValueSupport;
import org.simantics.db.impl.procedure.ResultCallWrappedQueryProcedure4;
import org.simantics.db.impl.procedure.ResultCallWrappedSingleQueryProcedure4;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.impl.service.QueryDebug;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.impl.support.VirtualGraphServerSupport;
import org.simantics.db.impl.support.WriteRequestScheduleSupport;
import org.simantics.db.procedure.AsyncListener;
import org.simantics.db.procedure.AsyncMultiListener;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.ListenerBase;
import org.simantics.db.procedure.MultiListener;
import org.simantics.db.procedure.MultiProcedure;
import org.simantics.db.procedure.Procedure;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.procedure.SyncMultiListener;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.procedure.SyncProcedure;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.protocol.DebugPolicy;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.DelayedWrite;
import org.simantics.db.request.DelayedWriteResult;
import org.simantics.db.request.ExternalRead;
import org.simantics.db.request.MultiRead;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteInterface;
import org.simantics.db.request.WriteOnly;
import org.simantics.db.request.WriteOnlyResult;
import org.simantics.db.request.WriteResult;
import org.simantics.db.request.WriteTraits;
import org.simantics.db.service.ByteReader;
import org.simantics.db.service.ClusterBuilder;
import org.simantics.db.service.ClusterBuilderFactory;
import org.simantics.db.service.ClusterControl;
import org.simantics.db.service.ClusterSetsSupport;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.db.service.CollectionSupport;
import org.simantics.db.service.DebugSupport;
import org.simantics.db.service.DirectQuerySupport;
import org.simantics.db.service.GraphChangeListenerSupport;
import org.simantics.db.service.InitSupport;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.ManagementSupport;
import org.simantics.db.service.QueryControl;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.db.service.ServerInformation;
import org.simantics.db.service.ServiceActivityMonitor;
import org.simantics.db.service.SessionEventSupport;
import org.simantics.db.service.SessionMonitorSupport;
import org.simantics.db.service.SessionUserSupport;
import org.simantics.db.service.StatementSupport;
import org.simantics.db.service.TransactionPolicySupport;
import org.simantics.db.service.TransactionSupport;
import org.simantics.db.service.TransferableGraphSupport;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.db.service.XSupport;
import org.simantics.layer0.Layer0;
import org.simantics.utils.DataContainer;
import org.simantics.utils.threads.logger.ITask;
import org.simantics.utils.threads.logger.ThreadLogger;

public abstract class SessionImplSocket
implements Session,
WriteRequestScheduleSupport {
    protected static final boolean DEBUG = false;
    private static final boolean DIAGNOSTICS = false;
    private TransactionPolicySupport transactionPolicy;
    private final ClusterControl clusterControl;
    protected final BuiltinSupportImpl builtinSupport;
    protected final VirtualGraphServerSupportImpl virtualGraphServerSupport;
    protected final ClusterSetsSupport clusterSetsSupport;
    protected final LifecycleSupportImpl lifecycleSupport;
    protected QuerySupportImpl querySupport;
    protected ResourceSupportImpl resourceSupport;
    protected WriteSupport writeSupport;
    public ClusterTranslator clusterTranslator;
    boolean dirtyPrimitives = false;
    public static final int SERVICE_MODE_CREATE = 2;
    public static final int SERVICE_MODE_ALLOW = 1;
    public int serviceMode = 0;
    public boolean createdImmutableClusters = false;
    public TLongHashSet createdClusters = new TLongHashSet();
    private Layer0 L0;
    protected final ServiceLocatorImpl serviceLocator = new ServiceLocatorImpl();
    public final ResourceSerializerImpl resourceSerializer = new ResourceSerializerImpl();
    final CopyOnWriteArrayList<ChangeListener> changeListeners2 = new CopyOnWriteArrayList();
    final CopyOnWriteArrayList<ChangeListener> metadataListeners = new CopyOnWriteArrayList();
    final CopyOnWriteArrayList<SessionEventListener> eventListeners = new CopyOnWriteArrayList();
    final HashSet<Thread> sessionThreads = new HashSet();
    final BijectionMap<MonitorContext, MonitorHandler> monitorContexts = new BijectionMap();
    protected final State state = new State();
    protected GraphSession graphSession = null;
    protected SessionManager sessionManagerImpl = null;
    protected UserAuthenticationAgent authAgent = null;
    protected UserAuthenticator authenticator = null;
    protected Resource user = null;
    protected ClusterStream clusterStream = null;
    protected SessionRequestManager requestManager = null;
    public ClusterTable clusterTable = null;
    public QueryProcessor queryProvider2 = null;
    ClientChangesImpl clientChanges = null;
    MonitorHandler[] monitorHandlers = new MonitorHandler[0];
    protected int flushCounter = 0;
    protected boolean writeOnly = false;
    WriteState<?> writeState = null;
    WriteStateBase<?> delayedWriteState = null;
    protected Resource defaultClusterSet = null;
    public static final Charset UTF8 = Charset.forName("utf-8");
    private Class<?> serviceKey1 = null;
    private Class<?> serviceKey2 = null;
    private Object service1 = null;
    private Object service2 = null;
    static int counter = 0;
    public static final ThreadGroup SessionThreadGroup = new ThreadGroup("Session Thread Group");

    public SessionImplSocket(SessionManager sessionManagerImpl, UserAuthenticationAgent authAgent) {
        File t = StaticSessionProperties.virtualGraphStoragePath;
        if (t == null) {
            t = new File(".");
        }
        this.clusterTable = new ClusterTable(this, t);
        this.builtinSupport = new BuiltinSupportImpl(this);
        this.sessionManagerImpl = sessionManagerImpl;
        this.user = null;
        this.serviceLocator.registerService(Session.class, this);
        this.serviceLocator.registerService(InitSupport.class, new InitSupportImpl(this));
        this.serviceLocator.registerService(ManagementSupport.class, new ManagementSupportImpl(this));
        this.serviceLocator.registerService(QueryControl.class, new QueryControlImpl(this));
        this.serviceLocator.registerService(SessionUserSupport.class, new SessionUserSupportImpl(this));
        this.serviceLocator.registerService(GraphChangeListenerSupport.class, new GraphChangeListenerSupportImpl(this));
        this.serviceLocator.registerService(SessionEventSupport.class, new SessionEventSupportImpl(this));
        this.serviceLocator.registerService(SerialisationSupport.class, new SerialisationSupportImpl(this));
        this.serviceLocator.registerService(UndoRedoSupport.class, new UndoRedoSupportImpl(this));
        this.serviceLocator.registerService(ClusteringSupport.class, new ClusteringSupportImpl(this));
        this.serviceLocator.registerService(TransactionSupport.class, new TransactionSupportImpl(this));
        this.serviceLocator.registerService(SessionMonitorSupport.class, new SessionMonitorSupportImpl(this));
        this.serviceLocator.registerService(TransferableGraphSupport.class, new TransferableGraphSupportImpl(this));
        this.serviceLocator.registerService(QueryDebug.class, new QueryDebugImpl(this));
        this.serviceLocator.registerService(CollectionSupport.class, new CollectionSupportImpl(this));
        this.serviceLocator.registerService(StatementSupport.class, new StatementSupportImpl(this));
        this.serviceLocator.registerService(DirectQuerySupport.class, new DirectQuerySupportImpl(this));
        this.serviceLocator.registerService(XSupport.class, new XSupportImpl(this));
        this.serviceLocator.registerService(DebugSupport.class, new DebugSupportImpl());
        this.serviceLocator.registerService(ExternalValueSupport.class, new ExternalValueSupportImpl(this));
        this.serviceLocator.registerService(RandomAccessValueSupport.class, new RandomAccessValueSupportImpl());
        this.serviceLocator.registerService(ServiceActivityMonitor.class, new ServiceActivityMonitorImpl());
        ServiceActivityUpdaterForWriteTransactions.register((Session)this);
        this.virtualGraphServerSupport = new VirtualGraphServerSupportImpl(this, t);
        this.serviceLocator.registerService(VirtualGraphSupport.class, this.virtualGraphServerSupport);
        this.serviceLocator.registerService(VirtualGraphServerSupport.class, this.virtualGraphServerSupport);
        this.lifecycleSupport = new LifecycleSupportImpl(this);
        this.serviceLocator.registerService(LifecycleSupport.class, this.lifecycleSupport);
        this.transactionPolicy = new TransactionPolicyRelease();
        this.serviceLocator.registerService(TransactionPolicySupport.class, this.transactionPolicy);
        this.clusterControl = new ClusterControlImpl(this);
        this.serviceLocator.registerService(ClusterControl.class, this.clusterControl);
        this.clusterSetsSupport = new ClusterSetsSupportImpl2();
        this.clusterSetsSupport.setReadDirectory(t.toPath());
        this.clusterSetsSupport.updateWriteDirectory(t.toPath());
        this.serviceLocator.registerService(ClusterSetsSupport.class, this.clusterSetsSupport);
    }

    public Resource getRootLibrary() {
        return this.queryProvider2.getRootLibraryResource();
    }

    void refresh(int thread, ClusterUID[] clusterUID, long csid) throws DatabaseException {
        if (!this.graphSession.dbSession.refreshEnabled()) {
            return;
        }
        try {
            this.getClusterTable().refresh(csid, this, clusterUID);
        }
        catch (Throwable t) {
            Logger.defaultLogError((String)"Refesh failed.", (Throwable)t);
        }
    }

    private ListenerBase getListenerBase(Object procedure) {
        if (procedure instanceof ListenerBase) {
            return (ListenerBase)procedure;
        }
        return null;
    }

    public <T> void scheduleRequest(Write request, Consumer<DatabaseException> callback, Semaphore notify) {
        this.scheduleRequest(request, callback, notify, null);
    }

    public <T> void scheduleRequest(final Write request, final Consumer<DatabaseException> callback, final Semaphore notify, Boolean combine) {
        assert (request != null);
        int thread = request.hashCode() & this.queryProvider2.THREAD_MASK;
        this.requestManager.scheduleWrite(new QueryProcessor.SessionTask(request, thread, thread){

            public void run(int thread) {
                ITask task;
                block12: {
                    task = ThreadLogger.getInstance().begin("WriteRequest " + request);
                    SessionImplSocket.this.fireSessionVariableChange("writes");
                    try {
                        try {
                            SessionImplSocket.this.flushCounter = 0;
                            Disposable.safeDispose((Disposable)SessionImplSocket.this.clientChanges);
                            SessionImplSocket.this.clientChanges = new ClientChangesImpl(SessionImplSocket.this);
                            VirtualGraph vg = SessionImplSocket.this.getProvider(request.getProvider());
                            WriteGraphImpl writer = WriteGraphImpl.create((QueryProcessor)SessionImplSocket.this.getQueryProvider2(), (WriteSupport)SessionImplSocket.this.writeSupport, (VirtualGraph)vg);
                            SessionImplSocket.this.writeState = new WriteState<Object>(writer, (WriteTraits)request, notify, new Procedure<Object>(){

                                public void execute(Object result) {
                                    if (callback != null) {
                                        callback.accept(null);
                                    }
                                }

                                public void exception(Throwable t) {
                                    if (callback != null) {
                                        callback.accept((DatabaseException)t);
                                    }
                                }
                            });
                            if (!$assertionsDisabled && writer == null) {
                                throw new AssertionError();
                            }
                            try {
                                request.perform((WriteGraph)writer);
                                if (!$assertionsDisabled && writer == null) {
                                    throw new AssertionError();
                                }
                            }
                            catch (Throwable t) {
                                if (!(t instanceof CancelTransactionException)) {
                                    Logger.defaultLogError((String)"Write transaction caused an unexpected error, see exception.", (Throwable)t);
                                }
                                SessionImplSocket.this.writeState.except(t);
                            }
                            if (!$assertionsDisabled && SessionImplSocket.this.queryProvider2.dirty) {
                                throw new AssertionError();
                            }
                        }
                        catch (Throwable e) {
                            if (!(e instanceof CancelTransactionException)) {
                                Logger.defaultLogError((String)"Write transaction caused an unexpected error, see exception.", (Throwable)e);
                            }
                            SessionImplSocket.this.writeState.except(e);
                            SessionImplSocket.this.fireSessionVariableChange("writes");
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        SessionImplSocket.this.fireSessionVariableChange("writes");
                        throw throwable;
                    }
                    SessionImplSocket.this.fireSessionVariableChange("writes");
                }
                task.finish();
            }
        }, combine);
    }

    public <T> void scheduleRequest(WriteResult<T> request, Procedure<T> procedure, Semaphore notify) {
        this.scheduleRequest(request, procedure, notify, null);
    }

    public <T> void scheduleRequest(WriteResult<T> request, Procedure<T> procedure, Semaphore notify, Boolean combine) {
        assert (request != null);
        int thread = request.hashCode() & this.queryProvider2.THREAD_MASK;
        this.requestManager.scheduleWrite(new QueryProcessor.SessionTask((WriteTraits)request, thread, (WriteResult)request, notify, (Procedure)procedure){
            private final /* synthetic */ WriteResult val$request;
            private final /* synthetic */ Semaphore val$notify;
            private final /* synthetic */ Procedure val$procedure;
            {
                this.val$request = writeResult;
                this.val$notify = semaphore;
                this.val$procedure = procedure;
                super($anonymous0, $anonymous1);
            }

            public void run(int thread) {
                ITask task;
                block7: {
                    task = ThreadLogger.getInstance().begin("WriteRequest " + this.val$request);
                    SessionImplSocket.this.fireSessionVariableChange("writes");
                    SessionImplSocket.this.flushCounter = 0;
                    Disposable.safeDispose((Disposable)SessionImplSocket.this.clientChanges);
                    SessionImplSocket.this.clientChanges = new ClientChangesImpl(SessionImplSocket.this);
                    VirtualGraph vg = SessionImplSocket.this.getProvider(this.val$request.getProvider());
                    WriteGraphImpl writer = WriteGraphImpl.create((QueryProcessor)SessionImplSocket.this.getQueryProvider2(), (WriteSupport)SessionImplSocket.this.writeSupport, (VirtualGraph)vg);
                    try {
                        try {
                            WriteState writeStateT = new WriteState(writer, (WriteTraits)this.val$request, this.val$notify, this.val$procedure);
                            SessionImplSocket.this.writeState = writeStateT;
                            if (!$assertionsDisabled && writer == null) {
                                throw new AssertionError();
                            }
                            writeStateT.setResult(this.val$request.perform((WriteGraph)writer));
                            if (!$assertionsDisabled && writer == null) {
                                throw new AssertionError();
                            }
                        }
                        catch (Throwable e) {
                            SessionImplSocket.this.writeState.except(e);
                            SessionImplSocket.this.fireSessionVariableChange("writes");
                            break block7;
                        }
                    }
                    catch (Throwable throwable) {
                        SessionImplSocket.this.fireSessionVariableChange("writes");
                        throw throwable;
                    }
                    SessionImplSocket.this.fireSessionVariableChange("writes");
                }
                task.finish();
            }
        }, combine);
    }

    public <T> void scheduleRequest(DelayedWrite request, Consumer<DatabaseException> callback, Semaphore notify) {
        this.scheduleRequest(request, callback, notify, null);
    }

    public <T> void scheduleRequest(final DelayedWrite request, final Consumer<DatabaseException> callback, final Semaphore notify, Boolean combine) {
        final ITask total = ThreadLogger.getInstance().begin("ScheduleDelayedWrite");
        assert (request != null);
        int thread = request.hashCode() & this.queryProvider2.THREAD_MASK;
        this.requestManager.scheduleWrite(new QueryProcessor.SessionTask((WriteTraits)request, thread){

            public void run(int thread) {
                SessionImplSocket.this.fireSessionVariableChange("reads");
                Procedure<Object> stateProcedure = new Procedure<Object>(){

                    public void execute(Object result) {
                        if (callback != null) {
                            callback.accept(null);
                        }
                    }

                    public void exception(Throwable t) {
                        if (callback != null) {
                            if (t instanceof DatabaseException) {
                                callback.accept((DatabaseException)t);
                            } else {
                                callback.accept(new DatabaseException(t));
                            }
                        } else {
                            Logger.defaultLogError((String)"Unhandled exception", (Throwable)t);
                        }
                    }
                };
                ReadGraphImpl newGraph = ReadGraphImpl.create((QueryProcessor)SessionImplSocket.this.getQueryProvider2());
                SessionImplSocket.this.delayedWriteState = new WriteStateBase<Object>((WriteTraits)request, notify, stateProcedure);
                DelayedWriteGraph dwg = null;
                try {
                    try {
                        dwg = new DelayedWriteGraph((ReadGraph)newGraph);
                        request.perform((WriteGraph)dwg);
                    }
                    catch (Throwable e) {
                        SessionImplSocket.this.delayedWriteState.except(e);
                        total.finish();
                        dwg.close();
                        SessionImplSocket.this.fireSessionVariableChange("reads");
                        return;
                    }
                }
                finally {
                    SessionImplSocket.this.fireSessionVariableChange("reads");
                }
                SessionImplSocket.this.delayedWriteState = null;
                ITask task2 = ThreadLogger.getInstance().begin("DelayedWriteCommit");
                SessionImplSocket.this.fireSessionVariableChange("writes");
                SessionImplSocket.this.flushCounter = 0;
                Disposable.safeDispose((Disposable)SessionImplSocket.this.clientChanges);
                SessionImplSocket.this.clientChanges = new ClientChangesImpl(SessionImplSocket.this);
                SessionImplSocket.this.acquireWriteOnly();
                VirtualGraph vg = SessionImplSocket.this.getProvider(request.getProvider());
                Object writeSupport = vg != null ? new VirtualWriteOnlySupport() : new WriteOnlySupport();
                WriteGraphImpl writer = WriteGraphImpl.create((QueryProcessor)SessionImplSocket.this.getQueryProvider2(), (WriteSupport)writeSupport, (VirtualGraph)vg);
                SessionImplSocket.this.writeState = new WriteState<Object>(writer, (WriteTraits)request, notify, stateProcedure);
                if (!$assertionsDisabled && writer == null) {
                    throw new AssertionError();
                }
                try {
                    try {
                        dwg.commit((WriteOnlyGraph)writer, (WriteTraits)request);
                        if (SessionImplSocket.this.defaultClusterSet != null) {
                            XSupport xs = SessionImplSocket.this.getService(XSupport.class);
                            SessionImplSocket.this.defaultClusterSet = xs.convertDelayedResourceToResource(SessionImplSocket.this.defaultClusterSet);
                            ClusteringSupport cs = SessionImplSocket.this.getService(ClusteringSupport.class);
                            SessionImplSocket.this.clusterSetsSupport.put(SessionImplSocket.this.defaultClusterSet.getResourceId(), cs.getCluster(SessionImplSocket.this.defaultClusterSet));
                        }
                        SessionImplSocket.this.clusterStream.reallyFlush();
                        SessionImplSocket.this.releaseWriteOnly((ReadGraphImpl)writer);
                        SessionImplSocket.this.handleUpdatesAndMetadata(writer);
                    }
                    catch (ServiceException e) {
                        SessionImplSocket.this.clusterTable.removeWriteOnlyClusters();
                        SessionImplSocket.this.clusterStream.reallyFlush();
                        SessionImplSocket.this.releaseWriteOnly((ReadGraphImpl)writer);
                        SessionImplSocket.this.writeState.except(e);
                        SessionImplSocket.this.fireSessionVariableChange("writes");
                        task2.finish();
                        total.finish();
                    }
                }
                finally {
                    SessionImplSocket.this.fireSessionVariableChange("writes");
                    task2.finish();
                    total.finish();
                }
            }
        }, combine);
    }

    public <T> void scheduleRequest(DelayedWriteResult<T> request, Procedure<T> procedure, Semaphore notify) {
        this.scheduleRequest(request, procedure, notify, null);
    }

    public <T> void scheduleRequest(DelayedWriteResult<T> request, Procedure<T> procedure, Semaphore notify, Boolean combine) {
        throw new Error("Not implemented");
    }

    protected ClusterImpl getNewResourceCluster() throws DatabaseException {
        ClusterImpl cluster = this.clusterTable.getNewResourceCluster((ClusterSupport)this.clusterTranslator, this.graphSession, this.writeOnly);
        if ((this.serviceMode & 2) > 0) {
            this.createdClusters.add(cluster.clusterId);
        }
        return cluster;
    }

    private <T> void performWriteOnly(WriteOnlyResult<T> request, Semaphore notify, Procedure<T> callback) {
        try {
            try {
                this.fireSessionVariableChange("writes");
                this.flushCounter = 0;
                Disposable.safeDispose((Disposable)this.clientChanges);
                this.clientChanges = new ClientChangesImpl(this);
                this.acquireWriteOnly();
                Object writeSupport = request.getProvider() != null ? new VirtualWriteOnlySupport() : new WriteOnlySupport();
                WriteGraphImpl writer = WriteGraphImpl.create((QueryProcessor)this.getQueryProvider2(), (WriteSupport)writeSupport, (VirtualGraph)request.getProvider());
                WriteState<T> writeStateT = new WriteState<T>(writer, (WriteTraits)request, notify, callback);
                this.writeState = writeStateT;
                assert (writer != null);
                long start = System.nanoTime();
                Object result = request.perform((WriteOnlyGraph)writer);
                long duration = System.nanoTime() - start;
                writeStateT.setResult(result);
                this.clusterStream.reallyFlush();
                this.releaseWriteOnly((ReadGraphImpl)writer);
                assert (writer != null);
                this.handleUpdatesAndMetadata(writer);
            }
            catch (CancelTransactionException cancelTransactionException) {
                this.releaseWriteOnly((ReadGraphImpl)this.writeState.getGraph());
                this.clusterTable.removeWriteOnlyClusters();
                this.state.stopWriteTransaction(this.clusterStream);
                this.fireSessionVariableChange("writes");
            }
            catch (Throwable e) {
                e.printStackTrace();
                this.releaseWriteOnly((ReadGraphImpl)this.writeState.getGraph());
                this.clusterTable.removeWriteOnlyClusters();
                if (callback != null) {
                    callback.exception((Throwable)new DatabaseException(e));
                }
                this.state.stopWriteTransaction(this.clusterStream);
                Logger.defaultLogError((String)"Write transaction caused an unexpected error, see exception.", (Throwable)e);
                this.fireSessionVariableChange("writes");
            }
        }
        finally {
            this.fireSessionVariableChange("writes");
        }
    }

    public <T> void scheduleRequest(WriteOnly request, Consumer<DatabaseException> callback, Semaphore notify) {
        this.scheduleRequest(request, callback, notify, null);
    }

    public <T> void scheduleRequest(final WriteOnly request, final Consumer<DatabaseException> callback, final Semaphore notify, Boolean combine) {
        this.assertAlive();
        assert (request != null);
        int thread = request.hashCode() & this.queryProvider2.THREAD_MASK;
        this.requestManager.scheduleWrite(new QueryProcessor.SessionTask(request, thread, thread){

            public void run(int thread) {
                ITask task = ThreadLogger.getInstance().begin("WriteRequest " + request);
                try {
                    SessionImplSocket.this.fireSessionVariableChange("writes");
                    SessionImplSocket.this.flushCounter = 0;
                    Disposable.safeDispose((Disposable)SessionImplSocket.this.clientChanges);
                    SessionImplSocket.this.clientChanges = new ClientChangesImpl(SessionImplSocket.this);
                    SessionImplSocket.this.acquireWriteOnly();
                    VirtualGraph vg = SessionImplSocket.this.getProvider(request.getProvider());
                    Object writeSupport = vg != null ? new VirtualWriteOnlySupport() : new WriteOnlySupport();
                    WriteGraphImpl writer = WriteGraphImpl.create((QueryProcessor)SessionImplSocket.this.getQueryProvider2(), (WriteSupport)writeSupport, (VirtualGraph)vg);
                    SessionImplSocket.this.writeState = new WriteState<Object>(writer, (WriteTraits)request, notify, new Procedure<Object>(){

                        public void execute(Object result) {
                            if (callback != null) {
                                callback.accept(null);
                            }
                        }

                        public void exception(Throwable t) {
                            if (callback != null) {
                                callback.accept((DatabaseException)t);
                            }
                        }
                    });
                    if (!$assertionsDisabled && writer == null) {
                        throw new AssertionError();
                    }
                    try {
                        request.perform((WriteOnlyGraph)writer);
                    }
                    catch (Throwable e) {
                        SessionImplSocket.this.releaseWriteOnly((ReadGraphImpl)writer);
                        SessionImplSocket.this.clusterTable.removeWriteOnlyClusters();
                        if (!(e instanceof CancelTransactionException) && callback != null) {
                            callback.accept(new DatabaseException(e));
                        }
                        SessionImplSocket.this.writeState.except(e);
                        SessionImplSocket.this.fireSessionVariableChange("writes");
                        return;
                    }
                    boolean empty = SessionImplSocket.this.clusterStream.reallyFlush();
                    if (!empty && SessionImplSocket.this.clientChanges.isEmpty()) {
                        SessionImplSocket.this.clientChanges.setNotEmpty(true);
                    }
                    SessionImplSocket.this.releaseWriteOnly((ReadGraphImpl)writer);
                    if (!$assertionsDisabled && writer == null) {
                        throw new AssertionError();
                    }
                }
                finally {
                    SessionImplSocket.this.fireSessionVariableChange("writes");
                }
                task.finish();
            }
        }, combine);
    }

    public <T> void scheduleRequest(WriteOnlyResult<T> request, Procedure<T> callback, Semaphore notify) {
        this.scheduleRequest(request, callback, notify, null);
    }

    public <T> void scheduleRequest(WriteOnlyResult<T> request, Procedure<T> callback, Semaphore notify, Boolean combine) {
        assert (request != null);
        int thread = request.hashCode() & this.queryProvider2.THREAD_MASK;
        this.requestManager.scheduleWrite(new QueryProcessor.SessionTask((WriteTraits)request, thread, (WriteOnlyResult)request, notify, (Procedure)callback){
            private final /* synthetic */ WriteOnlyResult val$request;
            private final /* synthetic */ Semaphore val$notify;
            private final /* synthetic */ Procedure val$callback;
            {
                this.val$request = writeOnlyResult;
                this.val$notify = semaphore;
                this.val$callback = procedure;
                super($anonymous0, $anonymous1);
            }

            public void run(int thread) {
                ITask task = ThreadLogger.getInstance().begin("WriteRequest " + this.val$request);
                SessionImplSocket.this.performWriteOnly(this.val$request, this.val$notify, this.val$callback);
                task.finish();
            }
        }, combine);
    }

    public <T> void scheduleRequest(final Read<T> request, final AsyncProcedure<T> procedure, Semaphore notify, DataContainer<Throwable> throwable, final DataContainer<T> result) {
        assert (request != null);
        assert (procedure != null);
        int thread = request.hashCode() & this.queryProvider2.THREAD_MASK;
        this.requestManager.scheduleRead(new QueryProcessor.SessionRead(request, throwable, notify, thread, thread){

            public void run(int thread) {
                block17: {
                    SessionImplSocket.this.fireSessionVariableChange("reads");
                    ListenerBase listener = SessionImplSocket.this.getListenerBase(procedure);
                    ReadGraphImpl newGraph = ReadGraphImpl.create((QueryProcessor)SessionImplSocket.this.getQueryProvider2());
                    try {
                        if (listener != null) {
                            try {
                                newGraph.processor.queryRead(newGraph, request, null, new AsyncProcedure<T>(){

                                    public void exception(AsyncReadGraph graph, Throwable t) {
                                        procedure.exception(graph, t);
                                        if (throwable != null) {
                                            throwable.set((Object)t);
                                        }
                                    }

                                    public void execute(AsyncReadGraph graph, T t) {
                                        if (result != null) {
                                            result.set(t);
                                        }
                                        procedure.execute(graph, t);
                                    }
                                }, listener);
                            }
                            catch (Throwable throwable) {}
                            break block17;
                        }
                        try {
                            Object t = request.perform((ReadGraph)newGraph);
                            try {
                                if (result != null) {
                                    result.set(t);
                                }
                                procedure.execute((AsyncReadGraph)newGraph, t);
                            }
                            catch (Throwable th) {
                                if (this.throwable != null) {
                                    this.throwable.set((Object)th);
                                    break block17;
                                }
                                Logger.defaultLogError((String)"Unhandled exception", (Throwable)th);
                            }
                        }
                        catch (Throwable t) {
                            if (this.throwable != null) {
                                this.throwable.set((Object)t);
                            } else {
                                Logger.defaultLogError((String)"Unhandled exception", (Throwable)t);
                            }
                            try {
                                procedure.exception((AsyncReadGraph)newGraph, t);
                            }
                            catch (Throwable t2) {
                                if (this.throwable != null) {
                                    this.throwable.set((Object)t2);
                                    break block17;
                                }
                                Logger.defaultLogError((String)"Unhandled exception", (Throwable)t2);
                            }
                        }
                    }
                    finally {
                        SessionImplSocket.this.fireSessionVariableChange("reads");
                    }
                }
            }
        });
    }

    public <T> void scheduleRequest(final AsyncRead<T> request, final AsyncProcedure<T> procedure, final ListenerBase listener, Semaphore notify) {
        assert (request != null);
        assert (procedure != null);
        int thread = request.hashCode() & this.queryProvider2.THREAD_MASK;
        this.requestManager.scheduleRead(new QueryProcessor.SessionRead(request, null, notify, thread){

            public void run(int thread) {
                SessionImplSocket.this.fireSessionVariableChange("reads");
                ReadGraphImpl newGraph = ReadGraphImpl.create((QueryProcessor)SessionImplSocket.this.getQueryProvider2());
                try {
                    if (listener != null) {
                        newGraph.processor.query(newGraph, request, null, procedure, listener);
                    } else {
                        ResultCallWrappedSingleQueryProcedure4 wrapper = new ResultCallWrappedSingleQueryProcedure4(procedure, (Object)"request");
                        try {
                            request.perform((AsyncReadGraph)newGraph, (AsyncProcedure)wrapper);
                        }
                        catch (Throwable t) {
                            wrapper.exception((AsyncReadGraph)newGraph, t);
                        }
                    }
                }
                finally {
                    SessionImplSocket.this.fireSessionVariableChange("reads");
                }
            }
        });
    }

    public <T> void scheduleRequest(final AsyncMultiRead<T> request, final AsyncMultiProcedure<T> procedure, Semaphore notify) {
        assert (request != null);
        assert (procedure != null);
        int thread = request.hashCode() & this.queryProvider2.THREAD_MASK;
        int sync = notify != null ? thread : -1;
        this.requestManager.scheduleRead(new QueryProcessor.SessionRead(request, null, notify, thread, sync){

            public void run(int thread) {
                SessionImplSocket.this.fireSessionVariableChange("reads");
                ListenerBase listener = SessionImplSocket.this.getListenerBase(procedure);
                ReadGraphImpl newGraph = ReadGraphImpl.create((QueryProcessor)SessionImplSocket.this.getQueryProvider2());
                try {
                    if (listener != null) {
                        newGraph.processor.query(newGraph, request, null, procedure, listener);
                    } else {
                        ResultCallWrappedQueryProcedure4 wrapper = new ResultCallWrappedQueryProcedure4(procedure);
                        try {
                            request.perform((AsyncReadGraph)newGraph, (AsyncMultiProcedure)wrapper);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
                finally {
                    SessionImplSocket.this.fireSessionVariableChange("reads");
                }
            }
        });
    }

    public <T> void scheduleRequest(final ExternalRead<T> request, final Procedure<T> procedure, Semaphore notify, DataContainer<Throwable> throwable, final DataContainer<T> result) {
        assert (request != null);
        assert (procedure != null);
        int thread = request.hashCode() & this.queryProvider2.THREAD_MASK;
        this.requestManager.scheduleRead(new QueryProcessor.SessionRead(request, throwable, notify, thread, thread){

            public void run(int thread) {
                SessionImplSocket.this.fireSessionVariableChange("reads");
                ListenerBase listener = SessionImplSocket.this.getListenerBase(procedure);
                ReadGraphImpl newGraph = ReadGraphImpl.create((QueryProcessor)SessionImplSocket.this.getQueryProvider2());
                try {
                    if (listener != null) {
                        newGraph.processor.query(newGraph, request, null, new Procedure<T>(){

                            public void exception(Throwable t) {
                                procedure.exception(t);
                                if (throwable != null) {
                                    throwable.set((Object)t);
                                }
                            }

                            public void execute(T t) {
                                if (result != null) {
                                    result.set(t);
                                }
                                procedure.execute(t);
                            }
                        }, listener);
                    } else {
                        request.register((ReadGraph)newGraph, new Listener<T>(){

                            public void exception(Throwable t) {
                                if (throwable != null) {
                                    throwable.set((Object)t);
                                }
                                procedure.exception(t);
                            }

                            public void execute(T t) {
                                if (result != null) {
                                    result.set(t);
                                }
                                procedure.execute(t);
                            }

                            public boolean isDisposed() {
                                return true;
                            }
                        });
                    }
                }
                finally {
                    SessionImplSocket.this.fireSessionVariableChange("reads");
                }
            }
        });
    }

    public <T> void asyncRequest(Read<T> request, AsyncProcedure<T> procedure) {
        this.scheduleRequest(request, procedure, null, null, null);
    }

    public <T> T syncRequest(Read<T> request, AsyncProcedure<T> procedure) throws DatabaseException {
        this.assertNotSession();
        Semaphore notify = new Semaphore(0);
        DataContainer container = new DataContainer();
        DataContainer result = new DataContainer();
        this.scheduleRequest(request, procedure, notify, (DataContainer<Throwable>)container, result);
        this.acquire(notify, request);
        Throwable throwable = (Throwable)container.get();
        if (throwable != null) {
            if (throwable instanceof DatabaseException) {
                throw (DatabaseException)throwable;
            }
            throw new DatabaseException("Unexpected exception", throwable);
        }
        return (T)result.get();
    }

    public <T> T syncRequest(AsyncRead<T> request, final AsyncProcedure<T> procedure) throws DatabaseException {
        this.assertNotSession();
        Semaphore notify = new Semaphore(0);
        final DataContainer exceptionContainer = new DataContainer();
        final DataContainer resultContainer = new DataContainer();
        this.scheduleRequest(request, new AsyncProcedure<T>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                exceptionContainer.set((Object)throwable);
                procedure.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, T result) {
                resultContainer.set(result);
                procedure.execute(graph, result);
            }
        }, this.getListenerBase(procedure), notify);
        this.acquire(notify, request, procedure);
        Throwable throwable = (Throwable)exceptionContainer.get();
        if (throwable != null) {
            if (throwable instanceof DatabaseException) {
                throw (DatabaseException)throwable;
            }
            throw new DatabaseException("Unexpected exception", throwable);
        }
        return (T)resultContainer.get();
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> request, final AsyncMultiProcedure<T> procedure) throws DatabaseException {
        this.assertNotSession();
        Semaphore notify = new Semaphore(0);
        final DataContainer exceptionContainer = new DataContainer();
        this.scheduleRequest(request, new AsyncMultiProcedure<T>(){

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                exceptionContainer.set((Object)throwable);
                procedure.exception(graph, throwable);
            }

            public void execute(AsyncReadGraph graph, T result) {
                procedure.execute(graph, result);
            }

            public void finished(AsyncReadGraph graph) {
                procedure.finished(graph);
            }
        }, notify);
        this.acquire(notify, request, procedure);
        Throwable throwable = (Throwable)exceptionContainer.get();
        if (throwable != null) {
            if (throwable instanceof DatabaseException) {
                throw (DatabaseException)throwable;
            }
            throw new DatabaseException("Unexpected exception", throwable);
        }
        System.err.println("TODO: implement return value for syncRequest(AsyncMultiRead, AsyncMultiProcedure)");
        return null;
    }

    public <T> T syncRequest(ExternalRead<T> request) throws DatabaseException {
        return this.syncRequest(request, (Procedure<T>)new ProcedureAdapter());
    }

    public <T> T syncRequest(ExternalRead<T> request, Listener<T> procedure) throws DatabaseException {
        return this.syncRequest(request, (Procedure<T>)procedure);
    }

    public <T> T syncRequest(ExternalRead<T> request, Procedure<T> procedure) throws DatabaseException {
        this.assertNotSession();
        Semaphore notify = new Semaphore(0);
        DataContainer container = new DataContainer();
        DataContainer result = new DataContainer();
        this.scheduleRequest(request, procedure, notify, (DataContainer<Throwable>)container, result);
        this.acquire(notify, request);
        Throwable throwable = (Throwable)container.get();
        if (throwable != null) {
            if (throwable instanceof DatabaseException) {
                throw (DatabaseException)throwable;
            }
            throw new DatabaseException("Unexpected exception", throwable);
        }
        return (T)result.get();
    }

    public void syncRequest(Write request) throws DatabaseException {
        this.assertNotSession();
        this.assertAlive();
        Semaphore notify = new Semaphore(0);
        DataContainer exception = new DataContainer();
        this.scheduleRequest(request, (DatabaseException e) -> exception.set((Object)e), notify);
        this.acquire(notify, request);
        if (exception.get() != null) {
            throw (DatabaseException)((Object)exception.get());
        }
    }

    public <T> T syncRequest(WriteResult<T> request) throws DatabaseException {
        this.assertNotSession();
        Semaphore notify = new Semaphore(0);
        final DataContainer exception = new DataContainer();
        final DataContainer result = new DataContainer();
        this.scheduleRequest(request, new Procedure<T>(){

            public void exception(Throwable t) {
                exception.set((Object)t);
            }

            public void execute(T t) {
                result.set(t);
            }
        }, notify);
        this.acquire(notify, request);
        if (exception.get() != null) {
            Throwable t = (Throwable)exception.get();
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException(t);
        }
        return (T)result.get();
    }

    public <T> T syncRequest(WriteOnlyResult<T> request) throws DatabaseException {
        this.assertNotSession();
        Semaphore notify = new Semaphore(0);
        final DataContainer exception = new DataContainer();
        final DataContainer result = new DataContainer();
        this.scheduleRequest(request, new Procedure<T>(){

            public void exception(Throwable t) {
                exception.set((Object)t);
            }

            public void execute(T t) {
                result.set(t);
            }
        }, notify);
        this.acquire(notify, request);
        if (exception.get() != null) {
            Throwable t = (Throwable)exception.get();
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException(t);
        }
        return (T)result.get();
    }

    public <T> T syncRequest(DelayedWriteResult<T> request) throws DatabaseException {
        this.assertNotSession();
        Semaphore notify = new Semaphore(0);
        final DataContainer exception = new DataContainer();
        final DataContainer result = new DataContainer();
        this.scheduleRequest(request, new Procedure<T>(){

            public void exception(Throwable t) {
                exception.set((Object)t);
            }

            public void execute(T t) {
                result.set(t);
            }
        }, notify);
        this.acquire(notify, request);
        if (exception.get() != null) {
            Throwable t = (Throwable)exception.get();
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException(t);
        }
        return (T)result.get();
    }

    public void syncRequest(DelayedWrite request) throws DatabaseException {
        this.assertNotSession();
        Semaphore notify = new Semaphore(0);
        DataContainer exception = new DataContainer();
        this.scheduleRequest(request, (DatabaseException e) -> exception.set((Object)e), notify);
        this.acquire(notify, request);
        if (exception.get() != null) {
            throw (DatabaseException)((Object)exception.get());
        }
    }

    public void syncRequest(WriteOnly request) throws DatabaseException {
        this.assertNotSession();
        this.assertAlive();
        Semaphore notify = new Semaphore(0);
        DataContainer exception = new DataContainer();
        this.scheduleRequest(request, (DatabaseException e) -> exception.set((Object)e), notify);
        this.acquire(notify, request);
        if (exception.get() != null) {
            throw (DatabaseException)((Object)exception.get());
        }
    }

    public <T> void asyncRequest(AsyncRead<T> request, AsyncProcedure<T> procedure) {
        this.scheduleRequest(request, procedure, null, null);
    }

    public <T> void asyncRequest(AsyncMultiRead<T> request, AsyncMultiProcedure<T> procedure) {
        this.scheduleRequest(request, procedure, null);
    }

    public <T> void asyncRequest(ExternalRead<T> request, Procedure<T> procedure) {
        this.scheduleRequest(request, procedure, null, null, null);
    }

    public void asyncRequest(Write request, Consumer<DatabaseException> callback) {
        this.scheduleRequest(request, callback, null);
    }

    public <T> void asyncRequest(WriteResult<T> request, Procedure<T> procedure) {
        this.scheduleRequest(request, procedure, null);
    }

    public <T> void asyncRequest(WriteOnlyResult<T> request, Procedure<T> procedure) {
        this.scheduleRequest(request, procedure, null);
    }

    public <T> void asyncRequest(DelayedWriteResult<T> request, Procedure<T> procedure) {
        this.scheduleRequest(request, procedure, null);
    }

    public void asyncRequest(DelayedWrite request, Consumer<DatabaseException> callback) {
        this.scheduleRequest(request, callback, null);
    }

    public void asyncRequest(Write r) {
        this.asyncRequest(r, null);
    }

    public void asyncRequest(DelayedWrite r) {
        this.asyncRequest(r, null);
    }

    public void asyncRequest(WriteOnly request, Consumer<DatabaseException> callback) {
        this.scheduleRequest(request, callback, null);
    }

    public void asyncRequest(WriteOnly request) {
        this.asyncRequest(request, null);
    }

    public <T> void async(ReadInterface<T> r, AsyncProcedure<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> void async(ReadInterface<T> r, Procedure<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> void async(ReadInterface<T> r, SyncProcedure<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> void async(ReadInterface<T> r, AsyncListener<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> void async(ReadInterface<T> r, Listener<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> void async(ReadInterface<T> r, SyncListener<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> T sync(ReadInterface<T> r) throws DatabaseException {
        return (T)r.request((RequestProcessor)this);
    }

    public <T> T sync(WriteInterface<T> r) throws DatabaseException {
        return (T)r.request((RequestProcessor)this);
    }

    public <T> void async(WriteInterface<T> r, Procedure<T> procedure) {
        r.request((AsyncRequestProcessor)this, procedure);
    }

    public <T> void async(WriteInterface<T> r) {
        r.request((AsyncRequestProcessor)this, (Procedure)new ProcedureAdapter());
    }

    public void incAsync() {
        this.state.incAsync();
    }

    public void decAsync() {
        this.state.decAsync();
    }

    public long getCluster(ResourceImpl resource) {
        Object cluster = this.clusterTable.getClusterByResourceKey(resource.id);
        return cluster.getClusterId();
    }

    public long getCluster(int id) {
        if (this.clusterTable == null) {
            System.out.println("SessionImplSocket.getCluster() clusterTable == null !!!!! how come");
        }
        return this.clusterTable.getClusterIdByResourceKeyNoThrow(id);
    }

    public ResourceImpl getResource(int id) {
        return new ResourceImpl((ResourceSupport)this.resourceSupport, id);
    }

    public ResourceImpl getResource(int resourceIndex, long clusterId) {
        assert (!ClusterTraitsBase.isIllegalResourceIndex((int)resourceIndex));
        ClusterImpl proxy = this.clusterTable.getClusterByClusterId(clusterId);
        int key = proxy.getClusterKey();
        int resourceKey = ClusterTraitsBase.createResourceKeyNoThrow((int)key, (int)resourceIndex);
        return new ResourceImpl((ResourceSupport)this.resourceSupport, resourceKey);
    }

    public ResourceImpl getResource2(int id) {
        assert (id != 0);
        return new ResourceImpl((ResourceSupport)this.resourceSupport, id);
    }

    public final int getId(ResourceImpl impl) {
        return impl.id;
    }

    static boolean areVirtualStatementsLoaded(VirtualGraphServerSupportImpl support, int subject) {
        for (TransientGraph g : support.providers) {
            if (!g.isPending(subject)) continue;
            return false;
        }
        return true;
    }

    static boolean areVirtualStatementsLoaded(VirtualGraphServerSupportImpl support, int subject, int predicate) {
        for (TransientGraph g : support.providers) {
            if (!g.isPending(subject, predicate)) continue;
            return false;
        }
        return true;
    }

    static void loadVirtualStatements(VirtualGraphServerSupportImpl support, ReadGraphImpl graph, int subject, final Consumer<ReadGraphImpl> runnable) {
        Consumer<ReadGraphImpl> composite = new Consumer<ReadGraphImpl>(support){
            AtomicInteger ready;
            {
                this.ready = new AtomicInteger(virtualGraphServerSupportImpl.providers.size() + 1);
            }

            @Override
            public void accept(ReadGraphImpl graph) {
                if (this.ready.decrementAndGet() == 0) {
                    runnable.accept(graph);
                }
            }
        };
        for (TransientGraph g : support.providers) {
            if (g.isPending(subject)) {
                try {
                    g.load(graph, subject, (Consumer)composite);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            composite.accept(graph);
        }
        composite.accept(graph);
    }

    static void loadVirtualStatements(VirtualGraphServerSupportImpl support, ReadGraphImpl graph, int subject, int predicate, final Consumer<ReadGraphImpl> runnable) {
        Consumer<ReadGraphImpl> composite = new Consumer<ReadGraphImpl>(support){
            AtomicInteger ready;
            {
                this.ready = new AtomicInteger(virtualGraphServerSupportImpl.providers.size() + 1);
            }

            @Override
            public void accept(ReadGraphImpl graph) {
                if (this.ready.decrementAndGet() == 0) {
                    runnable.accept(graph);
                }
            }
        };
        for (TransientGraph g : support.providers) {
            if (g.isPending(subject, predicate)) {
                try {
                    g.load(graph, subject, predicate, (Consumer)composite);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                continue;
            }
            composite.accept(graph);
        }
        composite.accept(graph);
    }

    void fireReactionsToSynchronize(ChangeSet cs) {
        if (cs.isEmpty()) {
            return;
        }
        ReadGraphImpl g = ReadGraphImpl.create((QueryProcessor)this.getQueryProvider2());
        if (!cs.isEmpty()) {
            ChangeEvent e2 = new ChangeEvent(g.getSession(), (ReadGraph)g, null, cs);
            for (ChangeListener l : this.changeListeners2) {
                try {
                    l.graphChanged(e2);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    void fireReactionsToCommit(ReadGraphImpl graph, ChangeSet cs2) {
        try {
            if (cs2.isEmpty()) {
                return;
            }
            if (!cs2.isEmpty()) {
                ChangeEvent e2 = new ChangeEvent(graph.getSession(), (ReadGraph)graph, null, cs2);
                for (ChangeListener l : this.changeListeners2) {
                    try {
                        l.graphChanged(e2);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    void fireMetadataListeners(WriteGraphImpl graph, ChangeSet cs2) {
        try {
            if (cs2.isEmpty()) {
                return;
            }
            if (graph.getProvider() != null) {
                return;
            }
            WriteGraphImpl reactionGraph = WriteGraphImpl.create((QueryProcessor)graph.processor, (WriteSupport)this.writeSupport, null);
            ChangeEvent e2 = new ChangeEvent(graph.getSession(), (ReadGraph)reactionGraph, (WriteGraph)graph, cs2);
            for (ChangeListener l : this.metadataListeners) {
                try {
                    l.graphChanged(e2);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public <T> T getService(Class<T> api) {
        T t = this.peekService(api);
        if (t == null) {
            if (this.state.isClosed()) {
                throw new ServiceNotFoundException((ServiceLocator)this, api, "Session has been shut down");
            }
            throw new ServiceNotFoundException((ServiceLocator)this, api);
        }
        return t;
    }

    protected abstract ServerInformation getCachedServerInformation();

    public synchronized <T> T peekService(Class<T> api) {
        if (this.serviceKey1 == api) {
            return (T)this.service1;
        }
        if (this.serviceKey2 == api) {
            Object result = this.service2;
            this.service2 = this.service1;
            this.serviceKey2 = this.serviceKey1;
            this.service1 = result;
            this.serviceKey1 = api;
            return (T)result;
        }
        if (Layer0.class == api) {
            return (T)this.L0;
        }
        if (ServerInformation.class == api) {
            return (T)this.getCachedServerInformation();
        }
        if (WriteGraphImpl.class == api) {
            return (T)this.writeState.getGraph();
        }
        if (ClusterBuilder.class == api) {
            return (T)new ClusterBuilderImpl(this, (WriteOnlySupport)this.writeState.getGraph().writeSupport);
        }
        if (ClusterBuilderFactory.class == api) {
            return (T)new ClusterBuilderFactoryImpl(this);
        }
        this.service2 = this.service1;
        this.serviceKey2 = this.serviceKey1;
        this.service1 = this.serviceLocator.peekService(api);
        this.serviceKey1 = api;
        return (T)this.service1;
    }

    public boolean hasService(Class<?> api) {
        return this.serviceLocator.hasService(api);
    }

    public <T> void registerService(Class<T> api, T service) {
        if (Layer0.class == api) {
            this.L0 = (Layer0)service;
            return;
        }
        this.serviceLocator.registerService(api, service);
        if (TransactionPolicySupport.class == api) {
            this.transactionPolicy = (TransactionPolicySupport)service;
            this.state.resetTransactionPolicy();
        }
        if (api == this.serviceKey1) {
            this.service1 = service;
        } else if (api == this.serviceKey2) {
            this.service2 = service;
        }
    }

    void fireSessionVariableChange(String variable) {
        MonitorHandler[] monitorHandlerArray = this.monitorHandlers;
        int n = this.monitorHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            MonitorHandler h = monitorHandlerArray[n2];
            MonitorContext ctx = this.monitorContexts.getLeft(h);
            assert (ctx != null);
            try {
                h.valuesChanged(ctx);
            }
            catch (Exception e) {
                Logger.defaultLogError((String)"monitor handler notification produced the following exception", (Throwable)e);
            }
            catch (LinkageError e) {
                Logger.defaultLogError((String)"monitor handler notification produced a linkage error", (Throwable)e);
            }
            ++n2;
        }
    }

    void check() {
        if (this.state.isClosed()) {
            throw new Error("Session closed.");
        }
    }

    public ResourceImpl getNewResource(long clusterId) {
        int newId;
        ClusterImpl cluster = this.clusterTable.getClusterByClusterIdOrThrow(clusterId);
        try {
            newId = cluster.createResource((ClusterSupport)this.clusterTranslator);
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
        return new ResourceImpl((ResourceSupport)this.resourceSupport, newId);
    }

    public ResourceImpl getNewResource(Resource clusterSet) throws DatabaseException {
        long resourceId = clusterSet.getResourceId();
        Long clusterId = this.clusterSetsSupport.get(Long.valueOf(resourceId));
        if (clusterId == null) {
            throw new ClusterSetExistException("Cluster set does not exist. Resource=" + clusterSet);
        }
        if (-1L == clusterId) {
            clusterId = this.getService(ClusteringSupport.class).createCluster();
            if ((this.serviceMode & 2) > 0) {
                this.createdClusters.add(clusterId.longValue());
            }
            this.clusterSetsSupport.put(resourceId, clusterId.longValue());
            return this.getNewResource(clusterId);
        }
        ClusterBase cb = this.clusterTranslator.getClusterByClusterId(clusterId.longValue());
        if (cb.getNumberOfResources((ClusterSupport)this.clusterTranslator) >= ClusterTable.CLUSTER_FILL_SIZE) {
            clusterId = this.getService(ClusteringSupport.class).createCluster();
            if ((this.serviceMode & 2) > 0) {
                this.createdClusters.add(clusterId.longValue());
            }
            this.clusterSetsSupport.put(resourceId, clusterId.longValue());
            return this.getNewResource(clusterId);
        }
        ResourceImpl result = this.getNewResource(clusterId);
        int resultKey = this.querySupport.getId((Resource)result);
        long resultCluster = this.querySupport.getClusterId(resultKey);
        if (clusterId != resultCluster) {
            this.clusterSetsSupport.put(resourceId, resultCluster);
        }
        return result;
    }

    public void getNewClusterSet(Resource clusterSet) throws DatabaseException {
        long resourceId = clusterSet.getResourceId();
        if (this.clusterSetsSupport.containsKey(resourceId)) {
            throw new ClusterSetExistException("Cluster set exist already. Resource=" + clusterSet);
        }
        this.clusterSetsSupport.put(resourceId, -1L);
    }

    public boolean containsClusterSet(Resource clusterSet) throws ServiceException {
        long resourceId = clusterSet.getResourceId();
        return this.clusterSetsSupport.containsKey(resourceId);
    }

    public Resource setDefaultClusterSet4NewResource(Resource clusterSet) {
        Resource r = this.defaultClusterSet;
        this.defaultClusterSet = clusterSet;
        return r;
    }

    void printDiagnostics() {
    }

    public void fireStartReadTransaction() {
        for (SessionEventListener listener : this.eventListeners) {
            try {
                listener.readTransactionStarted();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void fireFinishReadTransaction() {
        for (SessionEventListener listener : this.eventListeners) {
            try {
                listener.readTransactionFinished();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void fireStartWriteTransaction() {
        for (SessionEventListener listener : this.eventListeners) {
            try {
                listener.writeTransactionStarted();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void fireFinishWriteTransaction() {
        for (SessionEventListener listener : this.eventListeners) {
            try {
                listener.writeTransactionFinished();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        Indexing.resetDependenciesIndexingDisabled();
    }

    Resource deserialize(long resourceId, long clusterId) throws IOException {
        throw new Error("Not supported at the moment.");
    }

    State getState() {
        return this.state;
    }

    ClusterTable getClusterTable() {
        return this.clusterTable;
    }

    public GraphSession getGraphSession() {
        return this.graphSession;
    }

    public QueryProcessor getQueryProvider2() {
        return this.queryProvider2;
    }

    ClientChangesImpl getClientChanges() {
        return this.clientChanges;
    }

    boolean getWriteOnly() {
        return this.writeOnly;
    }

    public void onClusterLoaded(long clusterId) {
        this.clusterTable.updateSize();
    }

    public <T> T syncRequest(Read<T> request) throws DatabaseException {
        this.assertNotSession();
        this.assertAlive();
        assert (request != null);
        final DataContainer result = new DataContainer();
        final DataContainer exception = new DataContainer();
        this.syncRequest(request, new AsyncProcedure<T>(){

            public void execute(AsyncReadGraph graph, T t) {
                result.set(t);
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                exception.set((Object)t);
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException("Unexpected exception in ReadGraph.syncRequest(Read)", t);
        }
        return (T)result.get();
    }

    public <T> T syncRequest(Read<T> request, SyncListener<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncProcedure<T>)new SyncToAsyncListener(procedure));
    }

    public <T> T syncRequest(Read<T> request, Listener<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncProcedure<T>)new NoneToAsyncListener(procedure));
    }

    public <T> T syncRequest(Read<T> request, SyncProcedure<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> T syncRequest(Read<T> request, Procedure<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> T syncRequest(AsyncRead<T> request) throws DatabaseException {
        this.assertNotSession();
        assert (request != null);
        final DataContainer result = new DataContainer();
        final DataContainer exception = new DataContainer();
        this.syncRequest(request, new AsyncProcedure<T>(){

            public void execute(AsyncReadGraph graph, T t) {
                result.set(t);
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                exception.set((Object)t);
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException("Unexpected exception in ReadGraph.syncRequest(Read)", t);
        }
        return (T)result.get();
    }

    public <T> T syncRequest(AsyncRead<T> request, AsyncListener<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncProcedure<T>)procedure);
    }

    public <T> T syncRequest(AsyncRead<T> request, SyncListener<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncListener<T>)new SyncToAsyncListener(procedure));
    }

    public <T> T syncRequest(AsyncRead<T> request, Listener<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncListener<T>)new NoneToAsyncListener(procedure));
    }

    public <T> T syncRequest(AsyncRead<T> request, SyncProcedure<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public final <T> T syncRequest(AsyncRead<T> request, Procedure<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> Collection<T> syncRequest(MultiRead<T> request) throws DatabaseException {
        this.assertNotSession();
        assert (request != null);
        final ArrayList result = new ArrayList();
        final DataContainer exception = new DataContainer();
        this.syncRequest(request, new AsyncMultiProcedure<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(AsyncReadGraph graph, T t) {
                ArrayList arrayList = result;
                synchronized (arrayList) {
                    result.add(t);
                }
            }

            public void finished(AsyncReadGraph graph) {
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                exception.set((Object)t);
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException("Unexpected exception in ReadGraph.syncRequest(Read)", t);
        }
        return result;
    }

    public <T> Collection<T> syncRequest(MultiRead<T> request, AsyncMultiListener<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncMultiProcedure<T>)procedure);
    }

    public <T> Collection<T> syncRequest(MultiRead<T> request, SyncMultiListener<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncMultiListener<T>)new SyncToAsyncMultiListener(procedure));
    }

    public <T> Collection<T> syncRequest(MultiRead<T> request, MultiListener<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncMultiListener<T>)new NoneToAsyncMultiListener(procedure));
    }

    public <T> Collection<T> syncRequest(MultiRead<T> request, SyncMultiProcedure<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncMultiProcedure<T>)new SyncToAsyncMultiProcedure(procedure));
    }

    public <T> Collection<T> syncRequest(MultiRead<T> request, MultiProcedure<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncMultiProcedure<T>)new NoneToAsyncMultiProcedure(procedure));
    }

    public final <T> Collection<T> syncRequest(AsyncMultiRead<T> request) throws DatabaseException {
        this.assertNotSession();
        assert (request != null);
        final ArrayList result = new ArrayList();
        final DataContainer exception = new DataContainer();
        this.syncRequest(request, new AsyncMultiProcedure<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(AsyncReadGraph graph, T t) {
                ArrayList arrayList = result;
                synchronized (arrayList) {
                    result.add(t);
                }
            }

            public void finished(AsyncReadGraph graph) {
            }

            public void exception(AsyncReadGraph graph, Throwable t) {
                exception.set((Object)t);
            }
        });
        Throwable t = (Throwable)exception.get();
        if (t != null) {
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException("Unexpected exception in ReadGraph.syncRequest(Read)", t);
        }
        return result;
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> request, AsyncMultiListener<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncMultiProcedure<T>)procedure);
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> request, SyncMultiListener<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncMultiListener<T>)new SyncToAsyncMultiListener(procedure));
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> request, MultiListener<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncMultiListener<T>)new NoneToAsyncMultiListener(procedure));
    }

    public <T> Collection<T> syncRequest(AsyncMultiRead<T> request, SyncMultiProcedure<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncMultiProcedure<T>)new SyncToAsyncMultiProcedure(procedure));
    }

    public final <T> Collection<T> syncRequest(AsyncMultiRead<T> request, MultiProcedure<T> procedure) throws DatabaseException {
        this.assertNotSession();
        return this.syncRequest(request, (AsyncMultiProcedure<T>)new NoneToAsyncMultiProcedure(procedure));
    }

    public <T> void asyncRequest(Read<T> request) {
        this.asyncRequest(request, (Procedure<T>)new ProcedureAdapter<T>(){

            public void exception(Throwable t) {
                t.printStackTrace();
            }
        });
    }

    public <T> void asyncRequest(Read<T> request, AsyncListener<T> procedure) {
        this.asyncRequest(request, (AsyncProcedure<T>)procedure);
    }

    public <T> void asyncRequest(Read<T> request, SyncListener<T> procedure) {
        this.asyncRequest(request, (AsyncListener<T>)new SyncToAsyncListener(procedure));
    }

    public <T> void asyncRequest(Read<T> request, Listener<T> procedure) {
        this.asyncRequest(request, (AsyncListener<T>)new NoneToAsyncListener(procedure));
    }

    public <T> void asyncRequest(Read<T> request, SyncProcedure<T> procedure) {
        this.asyncRequest(request, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public <T> void asyncRequest(Read<T> request, Procedure<T> procedure) {
        this.asyncRequest(request, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public final <T> void asyncRequest(AsyncRead<T> request) {
        assert (request != null);
        this.asyncRequest(request, (Procedure<T>)new ProcedureAdapter<T>(){

            public void exception(Throwable t) {
                t.printStackTrace();
            }
        });
    }

    public <T> void asyncRequest(AsyncRead<T> request, AsyncListener<T> procedure) {
        this.scheduleRequest(request, (AsyncProcedure<T>)procedure, (ListenerBase)procedure, null);
    }

    public <T> void asyncRequest(AsyncRead<T> request, SyncListener<T> procedure) {
        this.asyncRequest(request, (AsyncListener<T>)new SyncToAsyncListener(procedure));
    }

    public <T> void asyncRequest(AsyncRead<T> request, Listener<T> procedure) {
        this.asyncRequest(request, (AsyncListener<T>)new NoneToAsyncListener(procedure));
    }

    public <T> void asyncRequest(AsyncRead<T> request, SyncProcedure<T> procedure) {
        this.asyncRequest(request, (AsyncProcedure<T>)new SyncToAsyncProcedure(procedure));
    }

    public final <T> void asyncRequest(AsyncRead<T> request, Procedure<T> procedure) {
        this.asyncRequest(request, (AsyncProcedure<T>)new NoneToAsyncProcedure(procedure));
    }

    public <T> void asyncRequest(MultiRead<T> request) {
        assert (request != null);
        this.asyncRequest(request, (AsyncMultiProcedure<T>)new AsyncMultiProcedureAdapter<T>(){

            public void exception(AsyncReadGraph graph, Throwable t) {
                t.printStackTrace();
            }
        });
    }

    public <T> void asyncRequest(MultiRead<T> request, AsyncMultiListener<T> procedure) {
        this.asyncRequest(request, (AsyncMultiProcedure<T>)procedure);
    }

    public <T> void asyncRequest(MultiRead<T> request, SyncMultiListener<T> procedure) {
        this.asyncRequest(request, (AsyncMultiListener<T>)new SyncToAsyncMultiListener(procedure));
    }

    public <T> void asyncRequest(MultiRead<T> request, MultiListener<T> procedure) {
        this.asyncRequest(request, (AsyncMultiListener<T>)new NoneToAsyncMultiListener(procedure));
    }

    public <T> void asyncRequest(MultiRead<T> request, SyncMultiProcedure<T> procedure) {
        this.asyncRequest(request, (AsyncMultiProcedure<T>)new SyncToAsyncMultiProcedure(procedure));
    }

    public <T> void asyncRequest(MultiRead<T> request, MultiProcedure<T> procedure) {
        this.asyncRequest(request, (AsyncMultiProcedure<T>)new NoneToAsyncMultiProcedure(procedure));
    }

    public final <T> void asyncRequest(AsyncMultiRead<T> request) {
        assert (request != null);
        this.asyncRequest(request, (AsyncMultiProcedure<T>)new AsyncMultiProcedureAdapter<T>(){

            public void exception(AsyncReadGraph graph, Throwable t) {
                t.printStackTrace();
            }
        });
    }

    public <T> void asyncRequest(AsyncMultiRead<T> request, AsyncMultiListener<T> procedure) {
        this.asyncRequest(request, (AsyncMultiProcedure<T>)procedure);
    }

    public <T> void asyncRequest(AsyncMultiRead<T> request, SyncMultiListener<T> procedure) {
        this.asyncRequest(request, (AsyncMultiListener<T>)new SyncToAsyncMultiListener(procedure));
    }

    public <T> void asyncRequest(AsyncMultiRead<T> request, MultiListener<T> procedure) {
        this.asyncRequest(request, (AsyncMultiListener<T>)new NoneToAsyncMultiListener(procedure));
    }

    public <T> void asyncRequest(AsyncMultiRead<T> request, SyncMultiProcedure<T> procedure) {
        this.asyncRequest(request, (AsyncMultiProcedure<T>)new SyncToAsyncMultiProcedure(procedure));
    }

    public final <T> void asyncRequest(AsyncMultiRead<T> request, MultiProcedure<T> procedure) {
        this.asyncRequest(request, (AsyncMultiProcedure<T>)new NoneToAsyncMultiProcedure(procedure));
    }

    public <T> Collection<T> syncRequest(MultiRead<T> arg0, AsyncMultiProcedure<T> arg1) throws DatabaseException {
        this.assertNotSession();
        throw new Error("Not implemented!");
    }

    public <T> void asyncRequest(MultiRead<T> arg0, AsyncMultiProcedure<T> arg1) {
        throw new Error("Not implemented!");
    }

    public final <T> void asyncRequest(ExternalRead<T> request) {
        assert (request != null);
        this.asyncRequest(request, (Procedure<T>)new ProcedureAdapter<T>(){

            public void exception(Throwable t) {
                t.printStackTrace();
            }
        });
    }

    public <T> void asyncRequest(ExternalRead<T> request, Listener<T> procedure) {
        this.asyncRequest(request, (Procedure<T>)procedure);
    }

    void check(Throwable t) throws DatabaseException {
        if (t != null) {
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException("Unexpected exception", t);
        }
    }

    void check(DataContainer<Throwable> container) throws DatabaseException {
        Throwable t = (Throwable)container.get();
        if (t != null) {
            if (t instanceof DatabaseException) {
                throw (DatabaseException)t;
            }
            throw new DatabaseException("Unexpected exception", t);
        }
    }

    boolean sameProvider(Write request) {
        if (this.writeState.getGraph().provider != null) {
            return this.writeState.getGraph().provider.equals(request.getProvider());
        }
        return request.getProvider() == null;
    }

    boolean plainWrite(WriteGraphImpl graph) {
        if (graph == null) {
            return false;
        }
        return !graph.writeSupport.writeOnly();
    }

    private void assertNotSession() throws DatabaseException {
        Thread current = Thread.currentThread();
        if (this.sessionThreads.contains(current)) {
            throw new DatabaseException("Caller is already inside a transaction.");
        }
    }

    void assertAlive() {
        if (!this.state.isAlive()) {
            throw new RuntimeDatabaseException("Session has been shut down.");
        }
    }

    public InputStream getValueStream(ReadGraphImpl graph, Resource resource) {
        return this.querySupport.getValueStream(graph, this.querySupport.getId(resource));
    }

    public byte[] getValue(ReadGraphImpl graph, Resource resource) {
        return this.querySupport.getValue(graph, this.querySupport.getId(resource));
    }

    <T> void acquire(Semaphore semaphore, T request) throws DatabaseException {
        this.acquire(semaphore, request, null);
    }

    private <T, P> void acquire(Semaphore semaphore, T request, P procedure) throws DatabaseException {
        this.assertAlive();
        try {
            while (true) {
                if (semaphore.tryAcquire(10000L, DebugPolicy.LONG_EXECUTION_REPORT_PERIOD_UNIT)) {
                    return;
                }
                this.assertAlive();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return;
        }
    }

    public Session getSession() {
        return this;
    }

    protected abstract VirtualGraph getProvider(VirtualGraph var1);

    protected abstract ResourceImpl getNewResource() throws DatabaseException;

    public void ceased(int thread) {
        this.requestManager.ceased(thread);
    }

    public int getAmountOfQueryThreads() {
        return 1;
    }

    public Resource getResourceByKey(int key) throws ResourceNotFoundException {
        return new ResourceImpl((ResourceSupport)this.resourceSupport, key);
    }

    public void acquireWriteOnly() {
        this.writeOnly = true;
    }

    public void releaseWriteOnly(ReadGraphImpl graph) {
        this.writeOnly = false;
        this.queryProvider2.releaseWrite(graph);
    }

    public void handleUpdatesAndMetadata(WriteGraphImpl writer) {
        long start = System.nanoTime();
        while (this.dirtyPrimitives) {
            this.dirtyPrimitives = false;
            this.getQueryProvider2().performDirtyUpdates((ReadGraphImpl)writer);
            this.getQueryProvider2().performScheduledUpdates(writer);
        }
        this.fireMetadataListeners(writer, this.clientChanges);
    }

    void removeTemporaryData() {
        File platform = Platform.getLocation().toFile();
        File tempFiles = new File(platform, "tempFiles");
        File temp = new File(tempFiles, "db");
        if (!temp.exists()) {
            return;
        }
        try {
            Files.walkFileTree(temp.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    try {
                        Files.delete(file);
                    }
                    catch (IOException e) {
                        Logger.defaultLogError((Throwable)e);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            Logger.defaultLogError((Throwable)e);
        }
    }

    public void handleCreatedClusters() {
        if ((this.serviceMode & 2) > 0) {
            this.createdClusters.forEach(new TLongProcedure(){

                public boolean execute(long value) {
                    ClusterImpl cluster = SessionImplSocket.this.clusterTable.getClusterByClusterId(value);
                    cluster.setImmutable(true, (ClusterSupport)SessionImplSocket.this.clusterTranslator);
                    return true;
                }
            });
        }
        this.createdClusters.clear();
    }

    public Object getModificationCounter() {
        return this.queryProvider2.modificationCounter;
    }

    public void markUndoPoint() {
        this.state.setCombine(false);
    }

    class ResourceSerializerImpl
    implements ResourceSerializer {
        ResourceSerializerImpl() {
        }

        public long createRandomAccessId(int id) throws DatabaseException {
            if (id < 0) {
                return id;
            }
            short index = ClusterTraitsBase.getResourceIndexFromResourceKey((int)id);
            long cluster = SessionImplSocket.this.getCluster(id);
            if (0L == cluster) {
                return 0L;
            }
            long result = ClusterTraitsBase.createResourceId((long)cluster, (int)index);
            return result;
        }

        public long getRandomAccessId(Resource resource) throws DatabaseException {
            ResourceImpl resourceImpl = (ResourceImpl)resource;
            return this.createRandomAccessId(resourceImpl.id);
        }

        public int getTransientId(Resource resource) throws DatabaseException {
            ResourceImpl resourceImpl = (ResourceImpl)resource;
            return resourceImpl.id;
        }

        public String createRandomAccessId(Resource resource) throws InvalidResourceReferenceException {
            short r;
            if (resource == null) {
                throw new IllegalArgumentException();
            }
            ResourceImpl resourceImpl = (ResourceImpl)resource;
            if (resourceImpl.id < 0) {
                return String.valueOf(String.valueOf(resourceImpl.id)) + "_0";
            }
            try {
                r = ClusterTraits.getResourceIndexFromResourceKey((int)resourceImpl.id);
            }
            catch (DatabaseException e1) {
                throw new InvalidResourceReferenceException((Throwable)e1);
            }
            try {
                return r + "_" + SessionImplSocket.this.getCluster(resourceImpl);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new InvalidResourceReferenceException(e);
            }
        }

        public int getTransientId(long serialized) throws DatabaseException {
            if (serialized <= 0L) {
                return (int)serialized;
            }
            int index = ClusterTraitsBase.getResourceIndexFromResourceId((long)serialized);
            long c = ClusterTraitsBase.getClusterIdFromResourceId((long)serialized);
            ClusterBase cluster = SessionImplSocket.this.clusterTranslator.getClusterByClusterId(c);
            if (cluster == null) {
                throw new DatabaseException("Couldn't load cluster for id " + c + " for resource id " + serialized);
            }
            int key = ClusterTraits.createResourceKey((int)cluster.getClusterKey(), (int)index);
            return key;
        }

        public Resource getResource(long randomAccessId) throws DatabaseException {
            return SessionImplSocket.this.getResourceByKey(this.getTransientId(randomAccessId));
        }

        public Resource getResource(int transientId) throws DatabaseException {
            return SessionImplSocket.this.getResourceByKey(transientId);
        }

        public Resource getResource(String randomAccessId) throws InvalidResourceReferenceException {
            try {
                int key;
                int i = randomAccessId.indexOf(95);
                if (i == -1) {
                    throw new InvalidResourceReferenceException("Could not parse resource id + cluster id from '" + randomAccessId + "'");
                }
                int r = Integer.parseInt(randomAccessId.substring(0, i));
                if (r < 0) {
                    return SessionImplSocket.this.getResourceByKey(r);
                }
                long c = Long.parseLong(randomAccessId.substring(i + 1));
                ClusterBase cluster = SessionImplSocket.this.clusterTranslator.getClusterByClusterId(c);
                if (cluster.hasResource(key = ClusterTraits.createResourceKey((int)cluster.getClusterKey(), (int)r), (ClusterSupport)SessionImplSocket.this.clusterTranslator)) {
                    return SessionImplSocket.this.getResourceByKey(key);
                }
            }
            catch (InvalidResourceReferenceException e) {
                throw e;
            }
            catch (NumberFormatException e) {
                throw new InvalidResourceReferenceException((Throwable)e);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new InvalidResourceReferenceException(e);
            }
            throw new InvalidResourceReferenceException("Resource does not exist " + randomAccessId);
        }

        public boolean disposeRandomAccessId(String randomAccessId) throws InvalidResourceReferenceException {
            return true;
        }
    }

    static final class TaskHelper {
        private final String name;
        private Object result;
        final Semaphore sema = new Semaphore(0);
        private Throwable throwable = null;
        final Consumer<DatabaseException> callback = e -> {
            TaskHelper taskHelper = this;
            synchronized (taskHelper) {
                this.throwable = e;
            }
        };
        final Procedure<Object> proc = new Procedure<Object>(){

            public void execute(Object result) {
                callback.accept(null);
            }

            public void exception(Throwable t) {
                if (t instanceof DatabaseException) {
                    callback.accept((DatabaseException)t);
                } else {
                    callback.accept(new DatabaseException(name + "operation failed.", t));
                }
            }
        };
        final WriteTraits writeTraits = new WriteTraits(){};

        TaskHelper(String name) {
            this.name = name;
        }

        <T> T getResult() {
            return (T)this.result;
        }

        void setResult(Object result) {
            this.result = result;
        }

        synchronized void throwableSet(Throwable t) {
            this.throwable = t;
        }

        synchronized void throwableCheck() throws DatabaseException {
            if (this.throwable != null) {
                if (this.throwable instanceof DatabaseException) {
                    throw (DatabaseException)this.throwable;
                }
                throw new DatabaseException("Undo operation failed.", this.throwable);
            }
        }

        void throw_(String message) throws DatabaseException {
            throw new DatabaseException(this.name + " operation failed. " + message);
        }
    }

    class VirtualWriteOnlySupport
    implements WriteSupport {
        VirtualWriteOnlySupport() {
        }

        public void claim(VirtualGraph provider, Resource subject, Resource predicate, Resource object) {
            TransientGraph impl = (TransientGraph)provider;
            impl.claim(SessionImplSocket.this.querySupport.getId(subject), SessionImplSocket.this.querySupport.getId(predicate), SessionImplSocket.this.querySupport.getId(object));
            SessionImplSocket.this.getQueryProvider2().updateStatements(SessionImplSocket.this.querySupport.getId(subject), SessionImplSocket.this.querySupport.getId(predicate));
            SessionImplSocket.this.clientChanges.claim(subject, predicate, object);
        }

        public void claim(VirtualGraph provider, int subject, int predicate, int object) {
            TransientGraph impl = (TransientGraph)provider;
            impl.claim(subject, predicate, object);
            SessionImplSocket.this.getQueryProvider2().updateStatements(subject, predicate);
            SessionImplSocket.this.clientChanges.claim(subject, predicate, object);
        }

        public void claimValue(VirtualGraph provider, Resource resource, byte[] value) throws DatabaseException {
            this.claimValue(provider, ((ResourceImpl)resource).id, value, value.length);
        }

        public void claimValue(VirtualGraph provider, int resource, byte[] value, int length) {
            ((VirtualGraphImpl)provider).claimValue(resource, value, length);
            SessionImplSocket.this.getQueryProvider2().updateValue(resource);
            SessionImplSocket.this.clientChanges.claimValue(resource);
        }

        public void claimValue(VirtualGraph provider, Resource resource, ByteReader reader, int amount) throws DatabaseException {
            byte[] value = reader.readBytes(null, amount);
            this.claimValue(provider, resource, value);
        }

        public Resource createResource(VirtualGraph provider) {
            TransientGraph impl = (TransientGraph)provider;
            return impl.getResource(impl.newResource(false));
        }

        public Resource createResource(VirtualGraph provider, long clusterId) {
            throw new UnsupportedOperationException();
        }

        public Resource createResource(VirtualGraph provider, Resource clusterSet) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public void createClusterSet(VirtualGraph provider, Resource clusterSet) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public boolean hasClusterSet(VirtualGraph provider, Resource clusterSet) throws ServiceException {
            throw new UnsupportedOperationException();
        }

        public Resource setDefaultClusterSet(Resource clusterSet) throws ServiceException {
            return null;
        }

        public void denyValue(VirtualGraph provider, Resource resource) {
            ((VirtualGraphImpl)provider).denyValue(((ResourceImpl)resource).id);
            SessionImplSocket.this.getQueryProvider2().updateValue(SessionImplSocket.this.querySupport.getId(resource));
            SessionImplSocket.this.clientChanges.claimValue(resource);
        }

        public void flush(boolean intermediate) {
            throw new UnsupportedOperationException();
        }

        public void flushCluster() {
            throw new UnsupportedOperationException();
        }

        public void flushCluster(Resource r) {
            throw new UnsupportedOperationException("Resource " + r);
        }

        public void gc() {
        }

        public boolean removeStatement(VirtualGraph provider, Resource subject, Resource predicate, Resource object) {
            TransientGraph impl = (TransientGraph)provider;
            impl.deny(SessionImplSocket.this.querySupport.getId(subject), SessionImplSocket.this.querySupport.getId(predicate), SessionImplSocket.this.querySupport.getId(object));
            SessionImplSocket.this.getQueryProvider2().updateStatements(SessionImplSocket.this.querySupport.getId(subject), SessionImplSocket.this.querySupport.getId(predicate));
            SessionImplSocket.this.clientChanges.deny(subject, predicate, object);
            return true;
        }

        public void setValue(VirtualGraph provider, Resource resource, byte[] value) {
            throw new UnsupportedOperationException();
        }

        public boolean writeOnly() {
            return true;
        }

        public void performWriteRequest(WriteGraph graph, Write request) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public <T> T performWriteRequest(WriteGraph graph, WriteResult<T> request) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public void performWriteRequest(WriteGraph graph, WriteOnly request) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public <T> void addMetadata(Metadata data) throws ServiceException {
            throw new UnsupportedOperationException();
        }

        public <T extends Metadata> T getMetadata(Class<T> clazz) throws ServiceException {
            throw new UnsupportedOperationException();
        }

        public TreeMap<String, byte[]> getMetadata() {
            throw new UnsupportedOperationException();
        }

        public void commitDone(WriteTraits writeTraits, long csid) {
        }

        public void clearUndoList(WriteTraits writeTraits) {
        }

        public int clearMetadata() {
            return 0;
        }

        public void startUndo() {
        }
    }

    class WriteOnlySupport
    implements WriteSupport {
        ClusterStream stream;
        ClusterImpl currentCluster;

        public WriteOnlySupport() {
            this.stream = SessionImplSocket.this.clusterStream;
        }

        public void claim(VirtualGraph provider, Resource subject, Resource predicate, Resource object) throws ServiceException {
            this.claim(provider, ((ResourceImpl)subject).id, ((ResourceImpl)predicate).id, ((ResourceImpl)object).id);
        }

        public void claim(VirtualGraph provider, int s, int p, int o) throws ServiceException {
            ClusterImpl cluster = (ClusterImpl)((Object)SessionImplSocket.this.clusterTable.getClusterByResourceKey(s));
            if (cluster.getImmutable() && (SessionImplSocket.this.serviceMode & 1) == 0 && s != SessionImplSocket.this.queryProvider2.getRootLibrary()) {
                throw new ImmutableException("Trying to modify immutable resource key=" + s);
            }
            try {
                this.maintainCluster(cluster, cluster.addRelation(s, p, o, (ClusterSupport)SessionImplSocket.this.clusterTranslator));
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
            SessionImplSocket.this.clientChanges.invalidate(s);
            if (cluster.isWriteOnly()) {
                return;
            }
            SessionImplSocket.this.queryProvider2.updateStatements(s, p);
        }

        public void claimValue(VirtualGraph provider, Resource resource, byte[] value) throws DatabaseException {
            this.claimValue(provider, ((ResourceImpl)resource).id, value, value.length);
        }

        public void claimValue(VirtualGraph provider, int rid, byte[] value, int length) {
            ClusterImpl cluster = (ClusterImpl)((Object)SessionImplSocket.this.clusterTable.getClusterByResourceKey(rid));
            try {
                this.maintainCluster(cluster, cluster.setValue(rid, value, length, (ClusterSupport)SessionImplSocket.this.clusterTranslator));
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
            SessionImplSocket.this.clientChanges.invalidate(rid);
            if (cluster.isWriteOnly()) {
                return;
            }
            SessionImplSocket.this.queryProvider2.updateValue(rid);
        }

        public void claimValue(VirtualGraph provider, Resource resource, ByteReader reader, int amount) throws DatabaseException {
            if (amount < 65536) {
                this.claimValue(provider, resource, reader.readBytes(null, amount));
                return;
            }
            byte[] bytes = new byte[65536];
            int rid = ((ResourceImpl)resource).id;
            ClusterImpl cluster = (ClusterImpl)((Object)SessionImplSocket.this.clusterTable.getClusterByResourceKey(rid));
            try {
                int left = amount;
                while (left > 0) {
                    int block = Math.min(left, 65536);
                    reader.readBytes(bytes, block);
                    this.maintainCluster(cluster, cluster.modiValueEx(rid, amount - left, block, bytes, 0, (ClusterSupport)SessionImplSocket.this.clusterTranslator));
                    left -= block;
                }
            }
            catch (DatabaseException e) {
                Logger.defaultLogError((Throwable)e);
            }
            SessionImplSocket.this.clientChanges.invalidate(rid);
            if (cluster.isWriteOnly()) {
                return;
            }
            SessionImplSocket.this.queryProvider2.updateValue(rid);
        }

        private void maintainCluster(ClusterImpl before, ClusterI after_) {
            if (after_ != null && after_ != before) {
                ClusterImpl after = (ClusterImpl)after_;
                if (this.currentCluster == before) {
                    this.currentCluster = after;
                }
                SessionImplSocket.this.clusterTable.replaceCluster((ClusterI)after);
            }
        }

        public int createResourceKey(int foreignCounter) throws DatabaseException {
            if (this.currentCluster == null) {
                this.currentCluster = SessionImplSocket.this.getNewResourceCluster();
            }
            if (this.currentCluster.getNumberOfResources((ClusterSupport)SessionImplSocket.this.clusterTranslator) == ClusterTable.CLUSTER_FILL_SIZE) {
                ClusterWriteOnly newCluster = (ClusterWriteOnly)SessionImplSocket.this.getNewResourceCluster();
                newCluster.foreignLookup = new byte[foreignCounter];
                this.currentCluster = newCluster;
            }
            return this.currentCluster.createResource((ClusterSupport)SessionImplSocket.this.clusterTranslator);
        }

        public Resource createResource(VirtualGraph provider) throws DatabaseException {
            if (this.currentCluster == null) {
                if (SessionImplSocket.this.defaultClusterSet != null) {
                    ResourceImpl result = SessionImplSocket.this.getNewResource(SessionImplSocket.this.defaultClusterSet);
                    this.currentCluster = (ClusterImpl)((Object)SessionImplSocket.this.clusterTable.getClusterByResourceKey(result.id));
                    return result;
                }
                this.currentCluster = SessionImplSocket.this.getNewResourceCluster();
            }
            if (this.currentCluster.getNumberOfResources((ClusterSupport)SessionImplSocket.this.clusterTranslator) >= ClusterTable.CLUSTER_FILL_SIZE) {
                if (SessionImplSocket.this.defaultClusterSet != null) {
                    ResourceImpl result = SessionImplSocket.this.getNewResource(SessionImplSocket.this.defaultClusterSet);
                    this.currentCluster = (ClusterImpl)((Object)SessionImplSocket.this.clusterTable.getClusterByResourceKey(result.id));
                    return result;
                }
                this.currentCluster = SessionImplSocket.this.getNewResourceCluster();
            }
            return new ResourceImpl((ResourceSupport)SessionImplSocket.this.resourceSupport, this.currentCluster.createResource((ClusterSupport)SessionImplSocket.this.clusterTranslator));
        }

        public Resource createResource(VirtualGraph provider, long clusterId) throws DatabaseException {
            return SessionImplSocket.this.getNewResource(clusterId);
        }

        public Resource createResource(VirtualGraph provider, Resource clusterSet) throws DatabaseException {
            return SessionImplSocket.this.getNewResource(clusterSet);
        }

        public void createClusterSet(VirtualGraph provider, Resource clusterSet) throws DatabaseException {
            SessionImplSocket.this.getNewClusterSet(clusterSet);
        }

        public boolean hasClusterSet(VirtualGraph dummy, Resource clusterSet) throws ServiceException {
            return SessionImplSocket.this.containsClusterSet(clusterSet);
        }

        public void selectCluster(long cluster) {
            this.currentCluster = SessionImplSocket.this.clusterTable.getClusterByClusterId(cluster);
            long setResourceId = SessionImplSocket.this.clusterSetsSupport.getSet(cluster);
            SessionImplSocket.this.clusterSetsSupport.put(setResourceId, cluster);
        }

        public Resource setDefaultClusterSet(Resource clusterSet) throws ServiceException {
            Resource result = SessionImplSocket.this.setDefaultClusterSet4NewResource(clusterSet);
            if (clusterSet != null) {
                long id = SessionImplSocket.this.clusterSetsSupport.get(Long.valueOf(clusterSet.getResourceId()));
                this.currentCluster = SessionImplSocket.this.clusterTable.getClusterByClusterId(id);
                return result;
            }
            this.currentCluster = null;
            return null;
        }

        public void denyValue(VirtualGraph provider, Resource resource) throws ServiceException {
            if ((provider = SessionImplSocket.this.getProvider(provider)) == null) {
                int key = ((ResourceImpl)resource).id;
                Object cluster = SessionImplSocket.this.clusterTable.getClusterProxyByResourceKey(key);
                SessionImplSocket.this.clusterTable.writeOnlyInvalidate((ClusterI)cluster);
                try {
                    short sResourceKey = ClusterTraits.getResourceIndexFromResourceKey((int)key);
                    SessionImplSocket.this.clusterTranslator.addStatementIndex(cluster, (int)sResourceKey, cluster.getClusterUID(), (byte)5);
                    SessionImplSocket.this.clusterTranslator.removeValue(cluster);
                }
                catch (DatabaseException e) {
                    Logger.defaultLogError((Throwable)e);
                }
                SessionImplSocket.this.queryProvider2.invalidateResource(key);
                SessionImplSocket.this.clientChanges.invalidate(key);
            } else {
                ((VirtualGraphImpl)provider).denyValue(((ResourceImpl)resource).id);
                SessionImplSocket.this.queryProvider2.updateValue(SessionImplSocket.this.querySupport.getId(resource));
                SessionImplSocket.this.clientChanges.claimValue(resource);
            }
        }

        public void flush(boolean intermediate) {
            throw new UnsupportedOperationException();
        }

        public void flushCluster() {
            SessionImplSocket.this.clusterTable.flushCluster(SessionImplSocket.this.graphSession);
            if (SessionImplSocket.this.defaultClusterSet != null) {
                SessionImplSocket.this.clusterSetsSupport.put(SessionImplSocket.this.defaultClusterSet.getResourceId(), -1L);
            }
            this.currentCluster = null;
        }

        public void flushCluster(Resource r) {
            throw new UnsupportedOperationException("flushCluster resource " + r);
        }

        public void gc() {
        }

        public boolean removeStatement(VirtualGraph provider, Resource subject, Resource predicate, Resource object) {
            int s = ((ResourceImpl)subject).id;
            int p = ((ResourceImpl)predicate).id;
            int o = ((ResourceImpl)object).id;
            if ((provider = SessionImplSocket.this.getProvider(provider)) == null) {
                Object cluster = SessionImplSocket.this.clusterTable.getClusterProxyByResourceKey(s);
                SessionImplSocket.this.clusterTable.writeOnlyInvalidate((ClusterI)cluster);
                try {
                    short sResourceKey = ClusterTraits.getResourceIndexFromResourceKey((int)s);
                    Object pc = SessionImplSocket.this.clusterTable.getClusterProxyByResourceKey(p);
                    Object oc = SessionImplSocket.this.clusterTable.getClusterProxyByResourceKey(o);
                    SessionImplSocket.this.clusterTranslator.addStatementIndex(cluster, (int)sResourceKey, cluster.getClusterUID(), (byte)3);
                    SessionImplSocket.this.clusterTranslator.addStatementIndex(cluster, p, pc.getClusterUID(), (byte)0);
                    SessionImplSocket.this.clusterTranslator.addStatementIndex(cluster, o, oc.getClusterUID(), (byte)0);
                    SessionImplSocket.this.clusterTranslator.removeStatement(cluster);
                    SessionImplSocket.this.queryProvider2.invalidateResource(s);
                    SessionImplSocket.this.clientChanges.invalidate(s);
                }
                catch (DatabaseException e) {
                    Logger.defaultLogError((Throwable)e);
                }
                return true;
            }
            ((VirtualGraphImpl)provider).deny(s, p, o);
            SessionImplSocket.this.queryProvider2.invalidateResource(s);
            SessionImplSocket.this.clientChanges.invalidate(s);
            return true;
        }

        public void setValue(VirtualGraph provider, Resource resource, byte[] value) {
            throw new UnsupportedOperationException();
        }

        public boolean writeOnly() {
            return true;
        }

        public void performWriteRequest(WriteGraph graph, Write request) throws DatabaseException {
            SessionImplSocket.this.writeSupport.performWriteRequest(graph, request);
        }

        public <T> T performWriteRequest(WriteGraph graph, WriteResult<T> request) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public void performWriteRequest(WriteGraph graph, WriteOnly request) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public <T> void addMetadata(Metadata data) throws ServiceException {
            SessionImplSocket.this.writeSupport.addMetadata(data);
        }

        public <T extends Metadata> T getMetadata(Class<T> clazz) throws ServiceException {
            return (T)SessionImplSocket.this.writeSupport.getMetadata(clazz);
        }

        public TreeMap<String, byte[]> getMetadata() {
            return SessionImplSocket.this.writeSupport.getMetadata();
        }

        public void commitDone(WriteTraits writeTraits, long csid) {
            SessionImplSocket.this.writeSupport.commitDone(writeTraits, csid);
        }

        public void clearUndoList(WriteTraits writeTraits) {
            SessionImplSocket.this.writeSupport.clearUndoList(writeTraits);
        }

        public int clearMetadata() {
            return SessionImplSocket.this.writeSupport.clearMetadata();
        }

        public void startUndo() {
            SessionImplSocket.this.writeSupport.startUndo();
        }
    }
}

