/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.GraphSession;
import fi.vtt.simantics.procore.internal.ServerInformationImpl;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import fi.vtt.simantics.procore.internal.SynchronizeContextI;
import org.simantics.db.Database;
import org.simantics.db.SessionReference;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;

final class GraphSessionSocket
extends GraphSession {
    public GraphSessionSocket(SessionImplSocket sessionImpl, SessionReference sessionReference, Database.Session dbSession) throws DatabaseException {
        super(sessionImpl, sessionReference, dbSession);
    }

    @Override
    protected ServerInformationImpl getServerInformation() throws DatabaseException {
        Database.Session.Information t = this.dbSession.getInformation();
        return new ServerInformationImpl(t.getServerId(), t.getProtocolId(), t.getDatabaseId(), t.getFirstChangeSetId());
    }

    @Override
    public long askReadTransaction(int thread) throws DatabaseException {
        Database.Session.Transaction t = this.dbSession.askReadTransaction();
        this.updateLastChangeSetId(thread, t.getHeadChangeSetId(), true);
        return t.getTransactionId();
    }

    @Override
    public long askWriteTransaction(int thread, long transactionId) throws DatabaseException {
        Database.Session.Transaction t = this.dbSession.askWriteTransaction(transactionId);
        this.updateLastChangeSetId(thread, t.getHeadChangeSetId(), true);
        return t.getTransactionId();
    }

    @Override
    public void endTransaction(long transactionId, boolean write) throws DatabaseException {
        long headChangeSetId = this.dbSession.endTransaction(transactionId);
        this.updateLastChangeSetId(Integer.MIN_VALUE, headChangeSetId, false);
    }

    @Override
    public void cancelCommit(long transactionId, long csid, byte[] metadata, SynchronizeContextI context) throws DatabaseException {
        try {
            assert (this.synchronizeContext == null);
            this.synchronizeContext = context;
            long headChangeSetId = this.dbSession.cancelCommit(transactionId, csid, metadata, (Database.Session.OnChangeSetUpdate)context);
            if (csid + 1L != headChangeSetId) {
                Logger.defaultLogError((String)("Client and server out of synchronisation. Client cs=" + (csid + 1L) + "server cs=" + headChangeSetId));
            }
            this.metadataCache.addNext(headChangeSetId, metadata);
        }
        finally {
            this.synchronizeContext = null;
        }
    }

    @Override
    public void acceptCommit(long transactionId, long csid, byte[] metadata) throws DatabaseException {
        this.dbSession.acceptCommit(transactionId, csid, metadata);
        this.metadataCache.addNext(csid + 1L, metadata);
    }

    @Override
    public void stop() throws DatabaseException {
        this.dbSession.close();
    }

    @Override
    public long reserveIds(int count) throws DatabaseException {
        Logger.defaultLogTrace((String)("Asking for ids " + count + "."));
        long firstId = this.dbSession.reserveIds(count);
        Logger.defaultLogTrace((String)("First id is " + firstId + "."));
        return firstId;
    }
}

