/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation.expressions;

import java.util.ArrayList;
import org.simantics.db.ReadGraph;
import org.simantics.objmap.annotations.GraphType;
import org.simantics.objmap.annotations.RelatedValue;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.Stock;
import org.simantics.sysdyn.representation.Valve;
import org.simantics.sysdyn.representation.expressions.Expression;
import org.simantics.sysdyn.representation.expressions.IExpression;
import org.simantics.sysdyn.representation.utils.FormatUtils;
import org.simantics.sysdyn.representation.utils.IndexUtils;
import org.simantics.sysdyn.representation.utils.UnitUtils;

@GraphType(value="http://www.simantics.org/Sysdyn-1.1/StockExpression")
public class StockExpression
extends Expression {
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/StockExpression/initialEquation")
    private String initialEquation;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/StockExpression/integralEquation")
    private String integralEquation;

    @Override
    public String getExpression() {
        return this.initialEquation;
    }

    @Override
    public String getModelicaExpression() {
        return FormatUtils.replaceWhitespace(this.initialEquation);
    }

    @Override
    public String getEquation() {
        return this.getEquation(true);
    }

    private String getEquation(boolean modelicaEquation) {
        String range = IndexUtils.rangeToIndexes(this.parent, this.getArrayRange());
        StringBuilder b = new StringBuilder();
        b.append("    der(").append(String.valueOf(this.parent.getModelicaName()) + (range.equals("[:]") ? "" : range)).append(") = ");
        if (this.integralEquation != null) {
            if (modelicaEquation) {
                String equation = FormatUtils.replaceWhitespace(this.integralEquation);
                equation = FormatUtils.formatExpressionForModelica(this.parent, equation);
                b.append(equation).append(";\n");
            } else {
                b.append(this.integralEquation).append(";\n");
            }
        } else {
            ArrayList<Valve> incoming = ((Stock)this.parent).getIncomingValves();
            ArrayList<Valve> outgoing = ((Stock)this.parent).getOutgoingValves();
            if (incoming.isEmpty() && outgoing.isEmpty()) {
                ArrayList<Enumeration> enumerations = this.parent.getArrayIndexes();
                if (enumerations == null || enumerations.isEmpty()) {
                    b.append(" 0.0");
                } else {
                    b.append(" zeros(");
                    int i = 0;
                    while (i < enumerations.size()) {
                        b.append(modelicaEquation ? enumerations.get(i).getModelicaName() : String.valueOf(enumerations.get(i).getName()) + ".size");
                        if (i != enumerations.size() - 1) {
                            b.append(", ");
                        }
                        ++i;
                    }
                    b.append(")");
                }
            } else {
                for (Valve valve : outgoing) {
                    b.append("\n        - ").append(modelicaEquation ? valve.getModelicaName() : String.valueOf(valve.getName()) + range);
                }
                for (Valve valve : incoming) {
                    b.append("\n        + ").append(modelicaEquation ? valve.getModelicaName() : String.valueOf(valve.getName()) + range);
                }
            }
            b.append(";\n");
        }
        return b.toString();
    }

    @Override
    public String getInitialEquation() {
        String initialEquation = FormatUtils.replaceWhitespace(this.initialEquation);
        String equation = FormatUtils.formatExpressionForModelica(this.parent, initialEquation, false);
        String range = IndexUtils.rangeToIndexes(this.parent, this.getArrayRange());
        return "    " + this.parent.getModelicaName() + (range != null ? range : "") + " = " + equation + ";\n";
    }

    public Double getStartValue() {
        IExpression e;
        Double value = null;
        ArrayList<IExpression> expressions = this.parent.getExpressions();
        if (expressions.size() == 1 && (e = expressions.get(0)).getInitialEquation() == null) {
            try {
                value = Double.parseDouble(this.initialEquation);
            }
            catch (NumberFormatException e1) {
                return null;
            }
        }
        return value;
    }

    @Override
    public String validateUnits(ReadGraph graph, SysdynModel model) {
        String integralEquation;
        String result = UnitUtils.matchUnits(graph, model, this.parent.getParentConfiguration(), this.parent.getUnit(), this.initialEquation);
        if (result == null && (integralEquation = this.getEquation(false)).contains("=")) {
            result = UnitUtils.matchUnits(graph, model, this.parent.getParentConfiguration(), this.parent.getUnit(), "(" + integralEquation.substring(integralEquation.indexOf("=") + 1, integralEquation.lastIndexOf(";")) + ") * time");
        }
        return result;
    }

    public String getPlainInitialEquation() {
        return this.initialEquation;
    }

    public String getPlainIntegralEquation() {
        return this.integralEquation;
    }
}

