/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.graph.impl;

import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.DataSource;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.common.NodeContextUtil;
import org.simantics.browsing.ui.common.viewpoints.LazyContainerViewpoint;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;

public class OrderedSetViewpointFactory
implements ViewpointFactory {
    public Viewpoint create(final PrimitiveQueryUpdater updater, final NodeContext context, final BuiltinKeys.ViewpointKey key) {
        assert (updater != null);
        assert (context != null);
        final LazyContainerViewpoint result = new LazyContainerViewpoint();
        DataSource source = updater.getDataSource(ReadGraph.class);
        if (source == null) {
            return result;
        }
        final Resource inputResource = (Resource)context.getConstant(BuiltinKeys.INPUT);
        assert (inputResource != null);
        source.schedule((Consumer)new Consumer<ReadGraph>(){

            @Override
            public void accept(ReadGraph source) {
                try {
                    List children = OrderedSetUtils.toList((ReadGraph)source, (Resource)inputResource);
                    NodeContext[] resultContexts = NodeContextUtil.toContextsWithInput((Collection)children);
                    result.setChildren(updater, resultContexts);
                    result.setHasChildren(Boolean.valueOf(resultContexts.length > 0));
                    updater.scheduleReplace(context, (NodeContext.PrimitiveQueryKey)key, (Object)result);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }
        });
        return result;
    }

    public String toString() {
        return "List";
    }
}

