/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.simulator.toolkit.db;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.NodeSupport;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.ExternalRead;
import org.simantics.simulator.toolkit.StandardNodeManagerSupport;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.simulator.variable.NodeManager;

public abstract class StandardSessionManager<Node, Engine extends StandardNodeManagerSupport<Node>> {
    private ConcurrentHashMap<String, Listener<StandardRealm<Node, Engine>>> realmListeners = new ConcurrentHashMap();
    private ConcurrentHashMap<String, StandardRealm<Node, Engine>> REALMS = new ConcurrentHashMap();
    private ConcurrentHashMap<String, NodeSupport<Node>> SUPPORTS = new ConcurrentHashMap();

    protected StandardSessionManager() {
    }

    private Listener<StandardRealm<Node, Engine>> getOrDisposeListener(String key) {
        Listener<StandardRealm<Node, Engine>> listener = this.realmListeners.get(key);
        if (listener != null) {
            if (listener.isDisposed()) {
                this.realmListeners.remove(key);
            } else {
                return listener;
            }
        }
        return null;
    }

    private void modifyRealms(String key, StandardRealm<Node, Engine> realm) {
        if (realm != null) {
            this.REALMS.put(key, realm);
        } else {
            StandardRealm<Node, Engine> removedRealm = this.REALMS.remove(key);
            if (removedRealm != null) {
                removedRealm.close();
            }
        }
        Listener<StandardRealm<Node, Engine>> listener = this.getOrDisposeListener(key);
        if (listener != null) {
            listener.execute(realm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeSupport<Node> getOrCreateNodeSupport(ReadGraph graph, String id) throws DatabaseException {
        ConcurrentHashMap<String, NodeSupport<Node>> concurrentHashMap = this.SUPPORTS;
        synchronized (concurrentHashMap) {
            NodeSupport result = this.SUPPORTS.get(id);
            if (result == null) {
                StandardRealm<Node, Engine> realm = this.getOrCreateRealm(graph, id);
                result = new NodeSupport((NodeManager)realm.getNodeManager());
                this.SUPPORTS.put(id, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardRealm<Node, Engine> getOrCreateRealm(ReadGraph graph, String id) throws DatabaseException {
        ConcurrentHashMap<String, StandardRealm<Node, Engine>> concurrentHashMap = this.REALMS;
        synchronized (concurrentHashMap) {
            return (StandardRealm)graph.syncRequest((ExternalRead)new RealmRequest(id));
        }
    }

    protected abstract Engine createEngine(ReadGraph var1, String var2) throws DatabaseException;

    protected abstract StandardRealm<Node, Engine> createRealm(Engine var1, String var2);

    public void removeRealm(WriteGraph graph, String id) throws DatabaseException {
        this.modifyRealms(id, null);
        this.realmListeners.remove(id);
        NodeSupport<Node> support = this.SUPPORTS.remove(id);
        if (support != null) {
            support.dispose();
        }
    }

    public Collection<String> getRealms() {
        return this.REALMS.keySet();
    }

    private class RealmRequest
    extends ParametrizedPrimitiveRead<String, StandardRealm<Node, Engine>> {
        public RealmRequest(String parameter) {
            super((Object)parameter);
        }

        public void register(ReadGraph graph, Listener<StandardRealm<Node, Engine>> procedure) {
            StandardRealm realm = (StandardRealm)StandardSessionManager.this.REALMS.get(this.parameter);
            if (realm == null) {
                try {
                    realm = this.createRealmInner(graph, (String)this.parameter);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }
            if (procedure.isDisposed()) {
                procedure.execute((Object)realm);
                return;
            }
            Listener existing = StandardSessionManager.this.getOrDisposeListener((String)this.parameter);
            assert (existing == null);
            StandardSessionManager.this.realmListeners.put((String)this.parameter, procedure);
            procedure.execute(realm);
        }

        private StandardRealm<Node, Engine> createRealmInner(ReadGraph graph, String id) throws DatabaseException {
            Object engine = StandardSessionManager.this.createEngine(graph, id);
            StandardRealm realm = StandardSessionManager.this.createRealm(engine, id);
            StandardSessionManager.this.modifyRealms(id, realm);
            return realm;
        }
    }
}

