/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.services.adaption.reflection;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.adaption.Adapter;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.services.adaption.reflection.IDynamicAdapter2;
import org.simantics.db.services.adaption.reflection.ThisResource2;

public class ReflectionAdapter2<T>
implements Adapter<T, Resource> {
    Constructor<? extends T> constructor;
    IDynamicAdapter2[] parameters;

    public ReflectionAdapter2(Class<? extends T> clazz, IDynamicAdapter2 ... parameters) throws SecurityException, NoSuchMethodException, DatabaseException {
        Class[] parameterTypes = new Class[parameters.length];
        int i = 0;
        while (i < parameters.length) {
            parameterTypes[i] = parameters[i].getType();
            ++i;
        }
        this.constructor = clazz.getConstructor(parameterTypes);
        this.parameters = parameters;
    }

    public void adapt(AsyncReadGraph g, Resource source, final Resource r, final AsyncProcedure<T> procedure) {
        if (this.parameters.length == 0) {
            try {
                procedure.execute(g, this.constructor.newInstance(new Object[0]));
            }
            catch (IllegalArgumentException e) {
                procedure.exception(g, (Throwable)e);
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                procedure.exception(g, (Throwable)e);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                procedure.exception(g, (Throwable)e);
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                procedure.exception(g, e.getCause());
                e.getCause().printStackTrace();
            }
        } else if (this.parameters.length == 1 && this.parameters[0] instanceof ThisResource2) {
            try {
                procedure.execute(g, this.constructor.newInstance(r));
            }
            catch (IllegalArgumentException e) {
                procedure.exception(g, (Throwable)e);
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                procedure.exception(g, (Throwable)e);
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                procedure.exception(g, (Throwable)e);
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                procedure.exception(g, e.getCause());
                e.getCause().printStackTrace();
            }
        } else {
            g.asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    Object[] args = new Object[ReflectionAdapter2.this.parameters.length];
                    try {
                        int i = 0;
                        while (i < ReflectionAdapter2.this.parameters.length) {
                            args[i] = ReflectionAdapter2.this.parameters[i].adapt(graph, r);
                            ++i;
                        }
                        procedure.execute((AsyncReadGraph)graph, ReflectionAdapter2.this.constructor.newInstance(args));
                    }
                    catch (IllegalArgumentException e) {
                        procedure.exception((AsyncReadGraph)graph, (Throwable)e);
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        procedure.exception((AsyncReadGraph)graph, (Throwable)e);
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        procedure.exception((AsyncReadGraph)graph, (Throwable)e);
                        e.printStackTrace();
                    }
                    catch (InvocationTargetException e) {
                        procedure.exception((AsyncReadGraph)graph, e.getCause());
                        e.getCause().printStackTrace();
                    }
                    catch (DatabaseException e) {
                        procedure.exception((AsyncReadGraph)graph, (Throwable)e);
                        e.printStackTrace();
                    }
                    catch (Throwable t) {
                        procedure.exception((AsyncReadGraph)graph, t);
                        t.printStackTrace();
                    }
                }

                public String toString() {
                    return "ReflectionAdapter$1" + ReflectionAdapter2.this.constructor + "$" + Arrays.toString(ReflectionAdapter2.this.parameters);
                }
            });
        }
    }

    public String toString() {
        return "ReflectionAdapter for " + this.constructor.getName();
    }
}

