/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.parser.grammar.input;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntByteHashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import org.simantics.scl.compiler.parser.grammar.Grammar;
import org.simantics.scl.compiler.parser.grammar.Production;
import org.simantics.scl.compiler.parser.grammar.input.GrammarLexer;
import org.simantics.scl.compiler.parser.grammar.input.GrammarParser;
import org.simantics.scl.compiler.parser.grammar.input.Token;
import org.simantics.scl.compiler.parser.regexp.RAtom;
import org.simantics.scl.compiler.parser.regexp.Regexp;

public class GrammarParserImpl
extends GrammarParser {
    private final GrammarLexer lexer;
    ArrayList<String> terminals = new ArrayList();
    ArrayList<String> nonterminals = new ArrayList();
    TObjectIntHashMap<String> symbols = new TObjectIntHashMap();
    ArrayList<Production> productions = new ArrayList();
    TIntArrayList initials = new TIntArrayList();

    public GrammarParserImpl(Reader reader) {
        this.lexer = new GrammarLexer(reader);
    }

    private int getId(String symbol) {
        int id;
        if (this.symbols.contains((Object)symbol)) {
            return this.symbols.get((Object)symbol);
        }
        if (Character.isUpperCase(symbol.charAt(0))) {
            id = this.terminals.size();
            this.terminals.add(symbol);
        } else {
            id = ~this.nonterminals.size();
            this.nonterminals.add(symbol);
        }
        this.symbols.put((Object)symbol, id);
        return id;
    }

    @Override
    protected Token nextToken() {
        try {
            Token token = this.lexer.nextToken();
            return token;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    protected RuntimeException syntaxError(Token token, String description) {
        return new RuntimeException(description);
    }

    @Override
    protected Object reduceFile() {
        return null;
    }

    @Override
    protected Object reduceProduction() {
        int lhs = this.getId(((Token)this.get((int)0)).text);
        int i = 2;
        while (i < this.length()) {
            Production prod = (Production)this.get(i);
            prod.lhs = lhs;
            this.productions.add(prod);
            i += 2;
        }
        return null;
    }

    @Override
    protected Object reduceInitial() {
        this.initials.add(this.getId(((Token)this.get((int)1)).text));
        return null;
    }

    @Override
    protected Object reduceTerminal() {
        return new RAtom(this.getId(((Token)this.get((int)0)).text));
    }

    private static Regexp postOp(Regexp regexp, Token op) {
        switch (op.id) {
            case 10: {
                return Regexp.star(regexp);
            }
            case 11: {
                return Regexp.plus(regexp);
            }
            case 12: {
                return Regexp.optional(regexp);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    protected Object reduceConcatenation() {
        ArrayList<Regexp> regexps = new ArrayList<Regexp>(this.length());
        int i = 0;
        while (i < this.length()) {
            Object obj = this.get(i);
            if (obj instanceof Regexp) {
                regexps.add((Regexp)obj);
            } else {
                Token token = (Token)obj;
                Regexp regexp = (Regexp)regexps.remove(regexps.size() - 1);
                regexps.add(GrammarParserImpl.postOp(regexp, token));
            }
            ++i;
        }
        return Regexp.seq(regexps.toArray(new Regexp[regexps.size()]));
    }

    @Override
    protected Object reduceUnion() {
        Regexp[] regexps = new Regexp[this.length() / 2];
        int i = 1;
        while (i < this.length()) {
            regexps[i / 2] = (Regexp)this.get(i);
            i += 2;
        }
        return Regexp.or(regexps);
    }

    @Override
    protected Object reduceProductionRhs() {
        Regexp rhs = (Regexp)this.get(0);
        String name = ((Token)this.get((int)2)).text;
        TIntByteHashMap annotations = new TIntByteHashMap();
        int i = 4;
        while (i < this.length()) {
            Token type = (Token)this.get(i);
            int id = this.getId(((Token)this.get((int)(i + 1))).text);
            annotations.put(id, (byte)(type.id != 8 ? 1 : 0));
            i += 3;
        }
        return new Production(name, 0, rhs, annotations);
    }

    public Grammar getGrammar() {
        return new Grammar(this.productions.toArray(new Production[this.productions.size()]), this.terminals.toArray(new String[this.terminals.size()]), this.nonterminals.toArray(new String[this.nonterminals.size()]), this.initials.toArray());
    }

    public static Grammar read(InputStream inputStream) throws IOException {
        GrammarParserImpl parser = new GrammarParserImpl(new InputStreamReader(inputStream, "UTF-8"));
        parser.parseFile();
        return parser.getGrammar();
    }
}

